/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wurstclient.glass.test;

import static net.wurstclient.glass.test.WiModsTestHelper.*;

import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.wurstclient.glass.MoGlassBlocks;

public enum TintedGlassLightBlockingTest
{
	;
	
	public static void testTintedGlassBlocksLightCorrectly()
	{
		System.out.println("Testing tinted glass light blocking...");
		class_2338 playerPos = submitAndGet(mc -> mc.field_1724.method_24515());
		class_2338 top = playerPos.method_10069(0, 1, 4);
		class_2338 front = playerPos.method_10069(0, 0, 3);
		
		// Build test rig
		runChatCommand("fill ~-1 ~ ~3 ~1 ~1 ~5 tinted_glass");
		runChatCommand("setblock ~ ~ ~4 air");
		clearChat();
		
		// Slab on top - should always block light
		for(class_2771 type : class_2771.values())
			testSlab(top, type, 0);
		
		// Slab in front - depends on type
		testSlab(front, class_2771.field_12681, 13);
		testSlab(front, class_2771.field_12679, 13);
		testSlab(front, class_2771.field_12682, 0);
		
		// Stairs on top - should always block light
		for(class_2350 dir : class_2350.class_2353.field_11062)
			for(class_2760 half : class_2760.values())
				for(class_2778 shape : class_2778.values())
					testStairs(top, dir, half, shape, 0);
				
		// Straight stairs in front - depends on direction
		for(class_2350 dir : class_2350.class_2353.field_11062)
		{
			int light = dir.method_10166() == class_2350.class_2351.field_11048 ? 13 : 0;
			for(class_2760 half : class_2760.values())
				testStairs(front, dir, half, class_2778.field_12710, light);
		}
		
		// Curved stairs in front - depends on curve type
		for(class_2350 dir : class_2350.class_2353.field_11062)
			for(class_2760 half : class_2760.values())
			{
				testStairs(front, dir, half, class_2778.field_12712, 0);
				testStairs(front, dir, half, class_2778.field_12713, 0);
				testStairs(front, dir, half, class_2778.field_12708, 13);
				testStairs(front, dir, half, class_2778.field_12709, 13);
			}
		
		// Clean up
		runChatCommand("fill ~-7 ~ ~-4 ~7 ~30 ~10 air");
		clearChat();
	}
	
	private static void testSlab(class_2338 pos, class_2771 type, int light)
	{
		testConfiguration(pos, MoGlassBlocks.TINTED_GLASS_SLAB.method_9564()
			.method_11657(class_2482.field_11501, type), light);
	}
	
	private static void testStairs(class_2338 pos, class_2350 facing,
		class_2760 half, class_2778 shape, int light)
	{
		testConfiguration(pos,
			MoGlassBlocks.TINTED_GLASS_STAIRS.method_9564()
				.method_11657(class_2510.field_11571, facing).method_11657(class_2510.field_11572, half)
				.method_11657(class_2510.field_11565, shape),
			light);
	}
	
	private static void testConfiguration(class_2338 pos, class_2680 state,
		int expectedLightLevel)
	{
		setBlock(pos, state);
		waitUntil("block " + state + " is placed at " + pos,
			mc -> (mc.field_1687.method_8320(pos) == state
				&& !mc.field_1687.method_22336().method_15518()));
		assertLightLevel(0, 0, 4, expectedLightLevel);
		setBlock(pos, class_2246.field_27115.method_9564());
	}
	
	private static void assertLightLevel(int x, int y, int z, int expected)
	{
		int lightLevel = submitAndGet(
			mc -> mc.field_1687.method_22339(mc.field_1724.method_24515().method_10069(x, y, z)));
		
		if(lightLevel == expected)
			return;
		
		takeScreenshot("FAILED_TEST_expected_light_level_" + expected + "_got_"
			+ lightLevel);
		throw new RuntimeException("Wrong light level at ~" + x + " ~" + y
			+ " ~" + z + ": Expected " + expected + ", got " + lightLevel);
	}
}
