/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wurstclient.glass;

import java.util.Arrays;
import java.util.List;

import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_11515;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public enum MoGlassBlocks
{
	;
	
	public static final class_5321<class_2248> GLASS_SLAB_KEY =
		blockKey("glass_slab");
	
	public static final class_2248 GLASS_SLAB = new GlassSlabBlock(
		class_4970.class_2251.method_9637().method_51368(class_2766.field_12645)
			.method_9632(0.3F).method_9626(class_2498.field_11537).method_22488()
			.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
			.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122)
			.method_63500(GLASS_SLAB_KEY));
	
	public static final class_5321<class_2248> GLASS_STAIRS_KEY =
		blockKey("glass_stairs");
	
	public static final class_2248 GLASS_STAIRS = new GlassStairsBlock(
		class_4970.class_2251.method_9637().method_51368(class_2766.field_12645)
			.method_9632(0.3F).method_9626(class_2498.field_11537).method_22488()
			.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
			.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122)
			.method_63500(GLASS_STAIRS_KEY));
	
	public static final class_5321<class_2248> TINTED_GLASS_SLAB_KEY =
		blockKey("tinted_glass_slab");
	
	public static final class_2248 TINTED_GLASS_SLAB = new TintedGlassSlabBlock(
		class_4970.class_2251.method_9637().method_51368(class_2766.field_12645)
			.method_9632(0.3F).method_9626(class_2498.field_11537)
			.method_31710(class_3620.field_15978).method_26235(class_2246::method_26114)
			.method_26236(class_2246::method_26122).method_26243(class_2246::method_26122)
			.method_26245(class_2246::method_26122).method_63500(TINTED_GLASS_SLAB_KEY));
	
	public static final class_5321<class_2248> TINTED_GLASS_STAIRS_KEY =
		blockKey("tinted_glass_stairs");
	
	public static final class_2248 TINTED_GLASS_STAIRS = new TintedGlassStairsBlock(
		class_4970.class_2251.method_9637().method_51368(class_2766.field_12645)
			.method_9632(0.3F).method_9626(class_2498.field_11537)
			.method_31710(class_3620.field_15978).method_26235(class_2246::method_26114)
			.method_26236(class_2246::method_26122).method_26243(class_2246::method_26122)
			.method_26245(class_2246::method_26122).method_63500(TINTED_GLASS_STAIRS_KEY));
	
	public static final List<class_5321<class_2248>> STAINED_GLASS_SLAB_KEYS =
		Arrays.stream(class_1767.values())
			.map(color -> color.method_7792() + "_stained_glass_slab")
			.map(MoGlassBlocks::blockKey).toList();
	
	public static final List<StainedGlassSlabBlock> STAINED_GLASS_SLABS = Arrays
		.stream(class_1767.values()).map(color -> createStainedGlassSlab(color,
			STAINED_GLASS_SLAB_KEYS.get(color.ordinal())))
		.toList();
	
	public static final List<class_5321<class_2248>> STAINED_GLASS_STAIRS_KEYS =
		Arrays.stream(class_1767.values())
			.map(color -> color.method_7792() + "_stained_glass_stairs")
			.map(MoGlassBlocks::blockKey).toList();
	
	public static final List<StainedGlassStairsBlock> STAINED_GLASS_STAIRS =
		Arrays.stream(class_1767.values())
			.map(color -> createStainedGlassStairs(color,
				STAINED_GLASS_STAIRS_KEYS.get(color.ordinal())))
			.toList();
	
	public static void initialize()
	{
		registerBlockTranslucent(GLASS_SLAB, GLASS_SLAB_KEY);
		registerBlockTranslucent(GLASS_STAIRS, GLASS_STAIRS_KEY);
		
		registerBlockTranslucent(TINTED_GLASS_SLAB, TINTED_GLASS_SLAB_KEY);
		registerBlockTranslucent(TINTED_GLASS_STAIRS, TINTED_GLASS_STAIRS_KEY);
		
		for(int i = 0; i < 16; i++)
		{
			registerBlockTranslucent(STAINED_GLASS_SLABS.get(i),
				STAINED_GLASS_SLAB_KEYS.get(i));
			registerBlockTranslucent(STAINED_GLASS_STAIRS.get(i),
				STAINED_GLASS_STAIRS_KEYS.get(i));
		}
		
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41059)
			.register(content -> {
				
				// stairs
				content.addBefore(class_2246.field_10285, GLASS_STAIRS,
					TINTED_GLASS_STAIRS);
				content.addBefore(class_2246.field_10285,
					STAINED_GLASS_STAIRS.toArray(new class_1935[0]));
				
				// slabs
				content.addBefore(class_2246.field_10285, GLASS_SLAB,
					TINTED_GLASS_SLAB);
				content.addBefore(class_2246.field_10285,
					STAINED_GLASS_SLABS.toArray(new class_1935[0]));
			});
	}
	
	private static class_5321<class_2248> blockKey(String idPath)
	{
		return class_5321.method_29179(class_7924.field_41254,
			class_2960.method_60655("mo_glass", idPath));
	}
	
	private static void registerBlockTranslucent(class_2248 block,
		class_5321<class_2248> key)
	{
		registerBlock(block, key);
		
		if(MoGlass.INSTANCE.isClient())
			BlockRenderLayerMap.putBlock(block, class_11515.field_60926);
	}
	
	private static void registerBlock(class_2248 block, class_5321<class_2248> blockKey)
	{
		class_2960 id = blockKey.method_29177();
		class_2378.method_39197(class_7923.field_41175, blockKey, block);
		
		class_5321<class_1792> itemKey = class_5321.method_29179(class_7924.field_41197, id);
		class_1793 settings = new class_1792.class_1793().method_63686(itemKey)
			.method_63685();
		class_1747 item = new class_1747(block, settings);
		class_2378.method_10230(class_7923.field_41178, id, item);
	}
	
	private static StainedGlassSlabBlock createStainedGlassSlab(class_1767 color,
		class_5321<class_2248> key)
	{
		return new StainedGlassSlabBlock(color,
			class_4970.class_2251.method_9637().method_51517(color)
				.method_51368(class_2766.field_12645).method_9632(0.3F)
				.method_9626(class_2498.field_11537).method_22488()
				.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
				.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122)
				.method_63500(key));
	}
	
	private static StainedGlassStairsBlock createStainedGlassStairs(
		class_1767 color, class_5321<class_2248> key)
	{
		return new StainedGlassStairsBlock(color,
			class_4970.class_2251.method_9637().method_51517(color)
				.method_51368(class_2766.field_12645).method_9632(0.3F)
				.method_9626(class_2498.field_11537).method_22488()
				.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
				.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122)
				.method_63500(key));
	}
}
