/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm;

import com.google.common.collect.ImmutableSet;
import com.unlikepaladin.pfm.PaladinFurnitureModUpdateChecker;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.behavior.BathtubBehavior;
import com.unlikepaladin.pfm.blocks.behavior.SinkBehavior;
import com.unlikepaladin.pfm.compat.PFMModCompatibility;
import com.unlikepaladin.pfm.compat.cookingforblockheads.PFMCookingForBlockheads;
import com.unlikepaladin.pfm.compat.farmersdelight.PFMFarmersDelight;
import com.unlikepaladin.pfm.compat.imm_ptl.PFMImmersivePortals;
import com.unlikepaladin.pfm.config.PaladinFurnitureModConfig;
import com.unlikepaladin.pfm.data.materials.DynamicBlockRegistry;
import com.unlikepaladin.pfm.data.materials.StoneVariantRegistry;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.forge.PaladinFurnitureModImpl;
import com.unlikepaladin.pfm.mixin.PFMPointOfInterestTypeAccessor;
import com.unlikepaladin.pfm.registry.BlockEntityRegistry;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.dynamic.LateBlockRegistry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaladinFurnitureMod {
    public static final String MOD_ID = "pfm";
    public static final ResourceLocation FURNITURE_DYED_ID = new ResourceLocation("pfm:furniture_dyed");
    public static SoundEvent FURNITURE_DYED_EVENT = new SoundEvent(FURNITURE_DYED_ID);
    public static final Logger GENERAL_LOGGER = LogManager.getLogger();
    public static CreativeModeTab FURNITURE_GROUP;
    public static CreativeModeTab DYE_KITS;
    private static PaladinFurnitureModUpdateChecker updateChecker;
    public static boolean isClient;
    public static List<PFMModCompatibility> pfmModCompatibilities;

    public void commonInit() {
        SinkBehavior.registerBehavior();
        BathtubBehavior.registerBehavior();
        updateChecker = new PaladinFurnitureModUpdateChecker();
        updateChecker.checkForUpdates(PaladinFurnitureMod.getPFMConfig());
        DynamicBlockRegistry.addBlockSetContainer(WoodVariantRegistry.INSTANCE.getType(), WoodVariantRegistry.INSTANCE);
        DynamicBlockRegistry.addBlockSetContainer(StoneVariantRegistry.INSTANCE.getType(), StoneVariantRegistry.INSTANCE);
        if (PaladinFurnitureMod.getModList().contains("cookingforblockheads")) {
            pfmModCompatibilities.add(PFMCookingForBlockheads.getInstance());
        }
        if (PaladinFurnitureMod.getModList().contains("farmersdelight")) {
            pfmModCompatibilities.add(PFMFarmersDelight.getInstance());
        }
        if (PaladinFurnitureMod.getModList().contains("imm_ptl_core")) {
            pfmModCompatibilities.add(PFMImmersivePortals.getInstance());
        }
    }

    public static void registerLateEntries() {
        DynamicBlockRegistry.initialize();
        try {
            LateBlockRegistry.registerBlocks();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        BlockEntityRegistry.registerBlockEntities();
    }

    public static void replaceHomePOIStates() {
        Set<BlockState> originalBedStates = ((PFMPointOfInterestTypeAccessor)PoiType.f_27346_).getBlockStates();
        Set addedBedStates = (Set)Arrays.stream(PaladinFurnitureModBlocksItems.getBeds()).flatMap(block -> block.m_49965_().m_61056_().stream().filter(state -> state.m_61143_((Property)SimpleBedBlock.f_49440_) == BedPart.HEAD)).collect(ImmutableSet.toImmutableSet());
        HashSet<BlockState> newBedStates = new HashSet<BlockState>();
        newBedStates.addAll(originalBedStates);
        newBedStates.addAll(addedBedStates);
        ((PFMPointOfInterestTypeAccessor)PoiType.f_27346_).setBlockStates((Set<BlockState>)ImmutableSet.copyOf(newBedStates));
        addedBedStates.forEach(state -> PFMPointOfInterestTypeAccessor.getBlockStateToPointOfInterestType().put((BlockState)state, PoiType.f_27346_));
        PFMPointOfInterestTypeAccessor.setRegisteredStates((Set<BlockState>)new ObjectOpenHashSet(PFMPointOfInterestTypeAccessor.getBlockStateToPointOfInterestType().keySet()));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PaladinFurnitureModConfig getPFMConfig() {
        return PaladinFurnitureModImpl.getPFMConfig();
    }

    public static PaladinFurnitureModUpdateChecker getUpdateChecker() {
        return updateChecker;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<String> getModList() {
        return PaladinFurnitureModImpl.getModList();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Map<String, String> getVersionMap() {
        return PaladinFurnitureModImpl.getVersionMap();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Loader getLoader() {
        return PaladinFurnitureModImpl.getLoader();
    }

    public static boolean isOptifineLoaded() {
        try {
            Class.forName("net.optifine.shaders.Shaders");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        isClient = false;
        pfmModCompatibilities = new ArrayList<PFMModCompatibility>();
    }

    public static enum Loader implements StringRepresentable
    {
        FORGE("forge"),
        FABRIC_LIKE("fabric_like");

        final String name;

        private Loader(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

