/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.behavior.BathtubBehavior;
import com.unlikepaladin.pfm.blocks.blockentities.BathtubBlockEntity;
import com.unlikepaladin.pfm.entity.ChairEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Entities;
import com.unlikepaladin.pfm.registry.ParticleIDs;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicBathtubBlock
extends BedBlock {
    public static final IntegerProperty LEVEL_8 = IntegerProperty.m_61631_((String)"level", (int)0, (int)8);
    private final Map<Item, BathtubBehavior> behaviorMap;
    private final Predicate<Biome.Precipitation> precipitationPredicate;
    private static final List<BasicBathtubBlock> basicBathtubBlocks = new ArrayList<BasicBathtubBlock>();
    public float height;
    private static final VoxelShape FOOT = Shapes.m_83113_((VoxelShape)BasicBathtubBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), (VoxelShape)BasicBathtubBlock.m_49796_((double)0.0, (double)2.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape FOOT_NORTH = SimpleStoolBlock.rotateShape(Direction.WEST, Direction.NORTH, FOOT);
    private static final VoxelShape FOOT_EAST = SimpleStoolBlock.rotateShape(Direction.WEST, Direction.EAST, FOOT);
    private static final VoxelShape FOOT_SOUTH = SimpleStoolBlock.rotateShape(Direction.WEST, Direction.SOUTH, FOOT);

    public BasicBathtubBlock(BlockBehaviour.Properties settings, Map<Item, BathtubBehavior> map, Predicate<Biome.Precipitation> precipitationPredicate) {
        super(DyeColor.WHITE, settings.m_60953_(state -> 0).m_60991_((blockstate, b, c) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)LEVEL_8, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)f_49441_, (Comparable)Boolean.valueOf(false)));
        this.behaviorMap = map;
        this.precipitationPredicate = precipitationPredicate;
        this.height = 0.05f;
        basicBathtubBlocks.add(this);
    }

    public static Stream<BasicBathtubBlock> basicBathtubBlockStream() {
        return basicBathtubBlocks.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{LEVEL_8});
        super.m_7926_(stateManager);
    }

    protected void onFireCollision(BlockState state, Level world, BlockPos pos) {
        BasicBathtubBlock.decrementFluidLevel(state, world, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        if (state.m_61143_((Property)f_49440_) == BedPart.HEAD) {
            direction = direction.m_122424_();
        }
        return world.m_8055_(pos.m_142300_(direction)).m_60795_() || world.m_8055_(pos.m_142300_(direction)).m_60734_() == this;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.f_46443_) {
            world.m_7731_(pos.m_142300_((Direction)state.m_61143_((Property)f_54117_)), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)f_49440_, (Comparable)BedPart.HEAD), 3);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5548_(BlockGetter world, Entity entity) {
        entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!world.f_46443_ && player.m_7500_() && (bedPart = (BedPart)state.m_61143_((Property)f_49440_)) == BedPart.FOOT && (blockState = world.m_8055_(blockPos = pos.m_142300_(BasicBathtubBlock.getDirectionTowardsOtherPart(bedPart, (Direction)state.m_61143_((Property)f_54117_))))).m_60734_() == this && blockState.m_61143_((Property)f_49440_) == BedPart.HEAD) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        int i = (Integer)state.m_61143_((Property)LEVEL_8);
        if (!world.f_46443_ && entity.m_6060_() && i != 0) {
            entity.m_20095_();
            this.onFireCollision(state, world, pos);
        }
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LEVEL_8);
    }

    protected static boolean canFillWithPrecipitation(Level world, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN) {
            return world.m_5822_().nextFloat() < 0.05f;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            return world.m_5822_().nextFloat() < 0.1f;
        }
        return false;
    }

    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (!BasicBathtubBlock.canFillWithPrecipitation(world, precipitation) || (Integer)state.m_61143_((Property)LEVEL_8) == 8 || !this.precipitationPredicate.test(precipitation)) {
            return;
        }
        world.m_46597_(pos, (BlockState)state.m_61122_((Property)LEVEL_8));
    }

    public static void decrementFluidLevel(BlockState state, Level world, BlockPos pos) {
        int i = (Integer)state.m_61143_((Property)LEVEL_8) - 1;
        if (i < 0) {
            i = 0;
        }
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LEVEL_8, (Comparable)Integer.valueOf(i)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = PaladinFurnitureMod.getPFMConfig().doChairsFacePlayer() ? ctx.m_8125_() : ctx.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState sourceState;
        BlockPos sourcePos = pos.m_7495_().m_7495_();
        ItemStack itemStack = player.m_21120_(hand);
        BathtubBehavior sinkBehavior = this.behaviorMap.get(itemStack.m_41720_());
        if (sinkBehavior != null && itemStack.m_41720_() != Items.f_41852_) {
            return sinkBehavior.interact(state, world, pos, player, hand, itemStack);
        }
        if ((Integer)state.m_61143_((Property)LEVEL_8) > 0 && player.m_6144_() && player.m_21120_(hand).m_41619_()) {
            world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BasicBathtubBlock.decrementFluidLevel(state, world, pos);
            return InteractionResult.SUCCESS;
        }
        if ((Integer)state.m_61143_((Property)LEVEL_8) < 8 && (sourceState = world.m_8055_(sourcePos)).m_60819_().m_76152_() == Fluids.f_76193_ && !sourceState.m_60819_().m_76178_()) {
            BathtubBlockEntity blockEntity;
            if (sourceState.m_61147_().contains(BlockStateProperties.f_61362_)) {
                world.m_46597_(sourcePos, (BlockState)sourceState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            } else {
                world.m_46597_(sourcePos, Blocks.f_50016_.m_49966_());
            }
            BlockPos headPos = pos;
            if (state.m_61143_((Property)f_49440_) != BedPart.HEAD) {
                headPos = headPos.m_142300_(BasicBathtubBlock.getDirectionTowardsOtherPart((BedPart)state.m_61143_((Property)f_49440_), (Direction)state.m_61143_((Property)f_54117_)));
            }
            if ((blockEntity = (BathtubBlockEntity)world.m_7702_(headPos)) != null) {
                blockEntity.setFilling(true);
            }
            BathtubBehavior.fillTub(world, pos, player, hand, player.m_21120_(hand), state, SoundEvents.f_12540_, false);
            return InteractionResult.SUCCESS;
        }
        if (world.m_46462_() && world.m_6042_().m_63961_()) {
            super.m_6227_(state, world, pos, player, hand, hit);
            return InteractionResult.SUCCESS;
        }
        return this.sit(state, world, pos, player, hand, hit);
    }

    public InteractionResult sit(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            if (player.m_5833_() || player.m_6144_()) {
                return InteractionResult.PASS;
            }
            double px = (double)pos.m_123341_() + 0.5;
            double pz = (double)pos.m_123343_() + 0.5;
            double py = (float)pos.m_123342_() + this.height;
            List active = world.m_6443_(ChairEntity.class, new AABB(pos), Entity::m_146898_);
            if (!active.isEmpty()) {
                return InteractionResult.PASS;
            }
            float yaw = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_().m_122435_();
            if (state.m_61143_((Property)f_49440_) == BedPart.FOOT) {
                yaw = ((Direction)state.m_61143_((Property)f_54117_)).m_122435_();
            }
            ChairEntity entity = (ChairEntity)Entities.CHAIR.m_20615_(world);
            entity.m_7678_(px, py, pz, yaw, 0.0f);
            entity.m_20242_(true);
            entity.m_20225_(true);
            entity.m_6842_(false);
            entity.m_20331_(true);
            entity.m_21557_(true);
            entity.m_5616_(yaw);
            entity.m_5618_(yaw);
            if (world.m_7967_((Entity)entity)) {
                player.m_7998_((Entity)entity, true);
                player.m_5616_(yaw);
                entity.m_5618_(yaw);
                entity.m_5616_(yaw);
                player.m_36220_(Statistics.USE_BATHTUB);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BedPart tubPart = (BedPart)state.m_61143_((Property)f_49440_);
        if (direction == BasicBathtubBlock.getDirectionTowardsOtherPart(tubPart, (Direction)state.m_61143_((Property)f_54117_))) {
            if (neighborState.m_60713_((Block)this) && neighborState.m_61143_((Property)f_49440_) != tubPart) {
                return (BlockState)((BlockState)state.m_61124_((Property)LEVEL_8, (Comparable)((Integer)neighborState.m_61143_((Property)LEVEL_8)))).m_61124_((Property)f_49441_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_49441_)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        BedPart part = (BedPart)state.m_61143_((Property)f_49440_);
        if (part == BedPart.FOOT) {
            switch (facing) {
                case WEST: {
                    return FOOT;
                }
                case EAST: {
                    return FOOT_EAST;
                }
                case NORTH: {
                    return FOOT_NORTH;
                }
            }
            return FOOT_SOUTH;
        }
        switch (facing) {
            case WEST: {
                return FOOT_EAST;
            }
            case EAST: {
                return FOOT;
            }
            case NORTH: {
                return FOOT_SOUTH;
            }
        }
        return FOOT_NORTH;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.BATHTUB_BLOCK_ENTITY, BathtubBlockEntity::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BathtubBlockEntity(pos, state);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static void spawnParticles(Direction facing, Level world, BlockPos pos) {
        if (world.f_46443_) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            if (facing == Direction.EAST) {
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
            } else {
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.m_6493_((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }
}

