/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.PowerableBlock;
import com.unlikepaladin.pfm.blocks.blockentities.LampBlockEntity;
import com.unlikepaladin.pfm.blocks.forge.BasicLampBlockImpl;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.items.LightSwitchItem;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicLampBlock
extends PowerableBlock
implements EntityBlock {
    private static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape SINGLE = Shapes.m_83124_((VoxelShape)BasicLampBlock.m_49796_((double)7.0, (double)1.5, (double)7.0, (double)9.0, (double)6.0, (double)9.0), (VoxelShape[])new VoxelShape[]{BasicLampBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.5, (double)13.0), BasicLampBlock.m_49796_((double)1.5, (double)5.0, (double)1.5, (double)14.5, (double)16.0, (double)14.5)});
    private static final VoxelShape TOP = Shapes.m_83110_((VoxelShape)BasicLampBlock.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), (VoxelShape)BasicLampBlock.m_49796_((double)1.5, (double)5.0, (double)1.5, (double)14.5, (double)16.0, (double)14.5));
    private static final VoxelShape MIDDLE = Shapes.m_83124_((VoxelShape)BasicLampBlock.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape BOTTOM = Shapes.m_83110_((VoxelShape)BasicLampBlock.m_49796_((double)7.0, (double)1.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)BasicLampBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.5, (double)13.0));

    public BasicLampBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERLOCKED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void setPowered(Level world, BlockPos lightPos, boolean powered) {
        BlockState state = world.m_8055_(lightPos);
        world.m_46597_(lightPos, (BlockState)((BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)POWERLOCKED, (Comparable)Boolean.valueOf(powered)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            CompoundTag nbtCompound = itemStack.m_41737_("BlockEntityTag");
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof LampBlockEntity && nbtCompound != null) {
                DyeColor color = DyeColor.m_41057_((String)nbtCompound.m_128461_("color"), (DyeColor)DyeColor.WHITE);
                WoodVariant variant = WoodVariantRegistry.getVariant(ResourceLocation.m_135820_((String)nbtCompound.m_128461_("variant")));
                ((LampBlockEntity)blockEntity).setPFMColor(color);
                ((LampBlockEntity)blockEntity).setVariant(variant);
            }
        }
        super.m_6402_(world, pos, state, placer, itemStack);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{LIT});
        stateManager.m_61104_(new Property[]{POWERLOCKED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return BasicLampBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return BasicLampBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public MaterialColor m_60590_() {
        return super.m_60590_();
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof LampBlockEntity) {
            LampBlockEntity lampBlockEntity = (LampBlockEntity)blockEntity;
            if (!world.f_46443_ && !player.m_7500_()) {
                ItemStack itemStack = new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.BASIC_LAMP);
                CompoundTag nbtCompound = lampBlockEntity.writeColorAndVariant(new CompoundTag());
                if (!nbtCompound.m_128456_()) {
                    itemStack.m_41700_("BlockEntityTag", (Tag)nbtCompound);
                }
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean up = world.m_8055_(pos.m_7494_()).m_60734_() instanceof BasicLampBlock;
        boolean down = world.m_8055_(pos.m_7495_()).m_60734_() instanceof BasicLampBlock;
        if (up && down) {
            return MIDDLE;
        }
        if (up) {
            return BOTTOM;
        }
        if (down) {
            return TOP;
        }
        return SINGLE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41720_() instanceof LightSwitchItem) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.m_61143_((Property)POWERLOCKED)).booleanValue()) {
            this.togglePower(state, world, pos);
            float f = (Boolean)state.m_61143_((Property)LIT) != false ? 0.9f : 0.8f;
            world.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, f);
            world.m_142346_((Entity)player, (Boolean)state.m_61143_((Property)LIT) != false ? GameEvent.f_157799_ : GameEvent.f_157801_, pos);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public BlockState togglePower(BlockState state, Level world, BlockPos pos) {
        state = (BlockState)state.m_61122_((Property)LIT);
        world.m_7731_(pos, state, 3);
        world.m_46672_(pos, (Block)this);
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122434_().m_122478_() && neighborState.m_60734_() instanceof BasicLampBlock ? (BlockState)((BlockState)state.m_61124_((Property)LIT, (Comparable)((Boolean)neighborState.m_61143_((Property)LIT)))).m_61124_((Property)POWERLOCKED, (Comparable)((Boolean)neighborState.m_61143_((Property)POWERLOCKED))) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(world, pos, state);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof LampBlockEntity) {
            CompoundTag nbtCompound = ((LampBlockEntity)blockEntity).writeColorAndVariant(new CompoundTag());
            stack.m_41700_("BlockEntityTag", (Tag)nbtCompound);
        }
        return stack;
    }
}

