/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.blockentities.ShowerHandleBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicShowerHandleBlock
extends HorizontalFacingBlockWithEntity {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final List<BasicShowerHandleBlock> SHOWER_HANDLE_BLOCKS = new ArrayList<BasicShowerHandleBlock>();
    private static final VoxelShape SHOWER_HANDLE = Shapes.m_83124_((VoxelShape)BasicShowerHandleBlock.m_49796_((double)11.5, (double)8.0, (double)14.0, (double)12.5, (double)9.0, (double)15.0), (VoxelShape[])new VoxelShape[]{BasicShowerHandleBlock.m_49796_((double)11.0, (double)7.5, (double)15.0, (double)13.0, (double)9.5, (double)16.0), BasicShowerHandleBlock.m_49796_((double)11.5, (double)6.5, (double)13.0, (double)12.5, (double)10.5, (double)14.0), BasicShowerHandleBlock.m_49796_((double)10.0, (double)8.0, (double)13.0, (double)14.0, (double)9.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)3.5, (double)8.0, (double)14.0, (double)4.5, (double)9.0, (double)15.0), BasicShowerHandleBlock.m_49796_((double)3.0, (double)7.5, (double)15.0, (double)5.0, (double)9.5, (double)16.0), BasicShowerHandleBlock.m_49796_((double)3.5, (double)6.5, (double)13.0, (double)4.5, (double)10.5, (double)14.0), BasicShowerHandleBlock.m_49796_((double)2.0, (double)8.0, (double)13.0, (double)6.0, (double)9.0, (double)14.0)});
    private static final VoxelShape SHOWER_HANDLE_SOUTH = BasicTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHOWER_HANDLE);
    private static final VoxelShape SHOWER_HANDLE_EAST = BasicTableBlock.rotateShape(Direction.NORTH, Direction.EAST, SHOWER_HANDLE);
    private static final VoxelShape SHOWER_HANDLE_WEST = BasicTableBlock.rotateShape(Direction.NORTH, Direction.WEST, SHOWER_HANDLE);
    private static final VoxelShape SHOWER_HANDLE_OPEN = Shapes.m_83124_((VoxelShape)BasicShowerHandleBlock.m_49796_((double)11.0, (double)7.5, (double)15.0, (double)13.0, (double)9.5, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicShowerHandleBlock.m_49796_((double)11.5, (double)8.0, (double)13.0, (double)12.5, (double)9.0, (double)15.0), BasicShowerHandleBlock.m_49796_((double)12.5, (double)9.0, (double)13.0, (double)13.5, (double)10.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)12.5, (double)7.0, (double)13.0, (double)13.5, (double)8.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)10.5, (double)9.0, (double)13.0, (double)11.5, (double)10.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)10.5, (double)7.0, (double)13.0, (double)11.5, (double)8.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)3.5, (double)8.0, (double)13.0, (double)4.5, (double)9.0, (double)15.0), BasicShowerHandleBlock.m_49796_((double)4.5, (double)9.0, (double)13.0, (double)5.5, (double)10.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)4.5, (double)7.0, (double)13.0, (double)5.5, (double)8.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)2.5, (double)9.0, (double)13.0, (double)3.5, (double)10.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)2.5, (double)7.0, (double)13.0, (double)3.5, (double)8.0, (double)14.0), BasicShowerHandleBlock.m_49796_((double)3.0, (double)7.5, (double)15.0, (double)5.0, (double)9.5, (double)16.0)});
    private static final VoxelShape SHOWER_HANDLE_SOUTH_OPEN = BasicTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHOWER_HANDLE_OPEN);
    private static final VoxelShape SHOWER_HANDLE_EAST_OPEN = BasicTableBlock.rotateShape(Direction.NORTH, Direction.EAST, SHOWER_HANDLE_OPEN);
    private static final VoxelShape SHOWER_HANDLE_WEST_OPEN = BasicTableBlock.rotateShape(Direction.NORTH, Direction.WEST, SHOWER_HANDLE_OPEN);

    public BasicShowerHandleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        SHOWER_HANDLE_BLOCKS.add(this);
    }

    public static Stream<BasicShowerHandleBlock> streamShowerHandleBlocks() {
        return SHOWER_HANDLE_BLOCKS.stream();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockState blockState = this.toggleOpen(state, world, pos, false, false);
        float f = (Boolean)blockState.m_61143_((Property)POWERED) != false ? 0.9f : 0.8f;
        world.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, f);
        world.m_142346_((Entity)player, (Boolean)blockState.m_61143_((Property)POWERED) != false ? GameEvent.f_157799_ : GameEvent.f_157801_, pos);
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            CompoundTag nbtCompound = itemStack.m_41737_("BlockEntityTag");
            BlockEntity blockEntity = world.m_7702_(pos);
            if (nbtCompound.m_128441_("showerHead") && blockEntity instanceof ShowerHandleBlockEntity) {
                ((ShowerHandleBlockEntity)blockEntity).m_183515_(nbtCompound);
                itemStack.m_41751_(null);
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_142300_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
    }

    public BlockState toggleOpen(BlockState state, Level world, BlockPos pos, boolean listenTo, boolean toggleTo) {
        state = listenTo ? (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(toggleTo)) : (BlockState)state.m_61122_((Property)POWERED);
        world.m_7731_(pos, state, 3);
        this.updateNeighbors(state, world, pos);
        if (world.m_7702_(pos) instanceof ShowerHandleBlockEntity) {
            ((ShowerHandleBlockEntity)world.m_7702_(pos)).setState((Boolean)state.m_61143_((Property)POWERED));
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = BasicShowerHandleBlock.getDirection(state);
        boolean open = (Boolean)state.m_61143_((Property)POWERED);
        switch (facing) {
            case SOUTH: {
                if (open) {
                    return SHOWER_HANDLE_SOUTH_OPEN;
                }
                return SHOWER_HANDLE_SOUTH;
            }
            case EAST: {
                if (open) {
                    return SHOWER_HANDLE_EAST_OPEN;
                }
                return SHOWER_HANDLE_EAST;
            }
            case WEST: {
                if (open) {
                    return SHOWER_HANDLE_WEST_OPEN;
                }
                return SHOWER_HANDLE_WEST;
            }
        }
        if (open) {
            return SHOWER_HANDLE_OPEN;
        }
        return SHOWER_HANDLE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    private void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_142300_(BasicShowerHandleBlock.getDirection(state).m_122424_()), (Block)this);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.m_7702_(pos) != null) {
            ((ShowerHandleBlockEntity)world.m_7702_(pos)).setState(false);
        }
        this.m_142387_(world, player, pos, state);
        if (state.m_60620_((Tag)BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)player, (boolean)false);
        }
        world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShowerHandleBlockEntity(pos, state);
    }

    protected static Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }
}

