/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicTableBlock
extends Block {
    private final Block baseBlock;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_BASIC_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_BASIC_TABLES = new ArrayList<FurnitureBlock>();
    static final VoxelShape TABLE_BASIC_BASE = BasicTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    static final VoxelShape TABLE_BASIC_NORTH_EAST_LEG = BasicTableBlock.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_WEST_LEG = BasicTableBlock.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_NORTH_WEST_LEG = BasicTableBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)14.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_EAST_LEG = BasicTableBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_EAST_WEST_NORTH = BasicTableBlock.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_EAST_WEST_SOUTH = BasicTableBlock.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_SOUTH_EAST_TOP = BasicTableBlock.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_EAST_BOTTOM = BasicTableBlock.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_SOUTH_WEST_BOTTOM = BasicTableBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_SOUTH_WEST_TOP = BasicTableBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_NORTH_SOUTH_WEST = BasicTableBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_NORTH_SOUTH_EAST = BasicTableBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_NORTH_EAST_CORNER = BasicTableBlock.m_49796_((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_EAST_CORNER = BasicTableBlock.m_49796_((double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_NORTH_WEST_CORNER = BasicTableBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_WEST_CORNER = BasicTableBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)2.0, (double)2.0, (double)14.0);
    static final Map<String, VoxelShape> VOXEL_SHAPES = new HashMap<String, VoxelShape>();

    public BasicTableBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60953_(state -> 0).m_60991_((blockstate, b, c) -> false));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        if ((this.f_60442_.equals(Material.f_76320_) || this.f_60442_.equals(Material.f_76321_)) && ((Object)((Object)this)).getClass().isAssignableFrom(BasicTableBlock.class)) {
            WOOD_BASIC_TABLES.add(new FurnitureBlock(this, "table_basic"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(BasicTableBlock.class)) {
            STONE_BASIC_TABLES.add(new FurnitureBlock(this, "table_basic"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodBasicTables() {
        return WOOD_BASIC_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneBasicTables() {
        return STONE_BASIC_TABLES.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{AXIS});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction.Axis facing = ctx.m_8125_().m_122434_();
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)facing);
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.m_60734_() instanceof BasicTableBlock : blockState.m_60734_() == this;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public boolean canConnect(BlockGetter world, BlockState state, BlockPos neighborPos, BlockPos pos) {
        BlockState neighborState = world.m_8055_(neighborPos);
        if (neighborState.m_61138_(AXIS)) {
            return neighborState.m_61143_(AXIS) == state.m_61143_(AXIS) && this.canConnect(neighborState);
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction.Axis dir = (Direction.Axis)state.m_61143_(AXIS);
        Boolean north = this.canConnect(world, state, pos.m_142127_(), pos);
        boolean east = this.canConnect(world, state, pos.m_142126_(), pos);
        boolean west = this.canConnect(world, state, pos.m_142125_(), pos);
        boolean south = this.canConnect(world, state, pos.m_142128_(), pos);
        boolean cornerNorthWest = north != false && west && !this.canConnect(world, state, pos.m_142127_().m_142125_(), pos);
        boolean cornerNorthEast = north != false && east && !this.canConnect(world, state, pos.m_142127_().m_142126_(), pos);
        boolean cornerSouthEast = south && east && !this.canConnect(world, state, pos.m_142128_().m_142126_(), pos);
        boolean cornerSouthWest = south && west && !this.canConnect(world, state, pos.m_142128_().m_142125_(), pos);
        String key = north.toString() + east + west + south + cornerNorthWest + cornerNorthEast + cornerSouthEast + cornerSouthWest + dir.m_7912_();
        if (!VOXEL_SHAPES.containsKey(key)) {
            BasicTableBlock.generateVoxelShape(key, north, east, west, south, cornerNorthWest, cornerNorthEast, cornerSouthEast, cornerSouthWest, dir);
        }
        return VOXEL_SHAPES.get(key);
    }

    private static void generateVoxelShape(String key, Boolean north, Boolean east, Boolean west, Boolean south, Boolean cornerNorthWest, Boolean cornerNorthEast, Boolean cornerSouthEast, Boolean cornerSouthWest, Direction.Axis axis) {
        VoxelShape newVoxelShape = TABLE_BASIC_BASE;
        if (!(north.booleanValue() || south.booleanValue() || east.booleanValue() || west.booleanValue())) {
            newVoxelShape = Shapes.m_83124_((VoxelShape)newVoxelShape, (VoxelShape[])new VoxelShape[]{TABLE_BASIC_EAST_WEST_NORTH, TABLE_BASIC_EAST_WEST_SOUTH});
        }
        if (!north.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)BasicTableBlock.getShapeForAxis(axis, TABLE_BASIC_NORTH_EAST_LEG, TABLE_BASIC_NORTH_WEST_LEG));
        }
        if (!north.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)BasicTableBlock.getShapeForAxis(axis, TABLE_BASIC_NORTH_WEST_LEG, TABLE_BASIC_SOUTH_WEST_LEG));
        }
        if (!south.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)BasicTableBlock.getShapeForAxis(axis, TABLE_BASIC_SOUTH_EAST_LEG, TABLE_BASIC_NORTH_EAST_LEG));
        }
        if (!south.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)BasicTableBlock.getShapeForAxis(axis, TABLE_BASIC_SOUTH_WEST_LEG, TABLE_BASIC_SOUTH_EAST_LEG));
        }
        if (cornerNorthEast.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)BasicTableBlock.getShapeForAxis(axis, Shapes.m_83110_((VoxelShape)TABLE_BASIC_NORTH_EAST_LEG, (VoxelShape)TABLE_BASIC_NORTH_EAST_CORNER), Shapes.m_83110_((VoxelShape)TABLE_BASIC_NORTH_WEST_LEG, (VoxelShape)TABLE_BASIC_NORTH_WEST_CORNER)));
        }
        if (cornerNorthWest.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)BasicTableBlock.getShapeForAxis(axis, Shapes.m_83110_((VoxelShape)TABLE_BASIC_NORTH_WEST_LEG, (VoxelShape)TABLE_BASIC_NORTH_WEST_CORNER), Shapes.m_83110_((VoxelShape)TABLE_BASIC_SOUTH_WEST_LEG, (VoxelShape)TABLE_BASIC_SOUTH_WEST_CORNER)));
        }
        if (cornerSouthWest.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)BasicTableBlock.getShapeForAxis(axis, Shapes.m_83110_((VoxelShape)TABLE_BASIC_SOUTH_WEST_LEG, (VoxelShape)TABLE_BASIC_SOUTH_WEST_CORNER), Shapes.m_83110_((VoxelShape)TABLE_BASIC_SOUTH_EAST_LEG, (VoxelShape)TABLE_BASIC_SOUTH_EAST_CORNER)));
        }
        if (cornerSouthEast.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)BasicTableBlock.getShapeForAxis(axis, Shapes.m_83110_((VoxelShape)TABLE_BASIC_SOUTH_EAST_LEG, (VoxelShape)TABLE_BASIC_SOUTH_EAST_CORNER), Shapes.m_83110_((VoxelShape)TABLE_BASIC_NORTH_EAST_LEG, (VoxelShape)TABLE_BASIC_NORTH_EAST_CORNER)));
        }
        if (axis == Direction.Axis.Z) {
            if (!north.booleanValue() && south.booleanValue() && !east.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_EAST_WEST_NORTH);
            }
            if (north.booleanValue() && !south.booleanValue() && !east.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_EAST_WEST_SOUTH);
            }
            if (!north.booleanValue() && east.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_EAST_TOP);
            }
            if (!south.booleanValue() && !east.booleanValue() && west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_BOTTOM);
            }
            if (!south.booleanValue() && east.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_EAST_BOTTOM);
            }
            if (!north.booleanValue() && !east.booleanValue() && west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_TOP);
            }
            if (!north.booleanValue() && east.booleanValue() && west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_NORTH_SOUTH_WEST);
            }
            if (!south.booleanValue() && east.booleanValue() && west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_NORTH_SOUTH_EAST);
            }
        } else {
            if (!north.booleanValue() && south.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_EAST_BOTTOM);
            }
            if (north.booleanValue() && !south.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_BOTTOM);
            }
            if (!north.booleanValue() && south.booleanValue() && !east.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_EAST_TOP);
            }
            if (north.booleanValue() && !south.booleanValue() && !east.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_TOP);
            }
            if (north.booleanValue() && !south.booleanValue() && !east.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_TOP);
            }
            if (!(north.booleanValue() || south.booleanValue() || east.booleanValue())) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_EAST_WEST_NORTH);
            }
            if (!(north.booleanValue() || south.booleanValue() || west.booleanValue())) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_EAST_WEST_SOUTH);
            }
            if (north.booleanValue() && south.booleanValue() && !east.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_NORTH_SOUTH_WEST);
            }
            if (north.booleanValue() && south.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_NORTH_SOUTH_EAST);
            }
            newVoxelShape = BasicTableBlock.rotateShape(Direction.NORTH, Direction.EAST, newVoxelShape);
        }
        VOXEL_SHAPES.put(key, newVoxelShape);
    }

    private static VoxelShape getShapeForAxis(Direction.Axis axis, VoxelShape a, VoxelShape b) {
        if (axis == Direction.Axis.Z) {
            return a;
        }
        if (axis == Direction.Axis.X) {
            return b;
        }
        return Shapes.m_83040_();
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)))));
    }
}

