/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.ToiletState;
import com.unlikepaladin.pfm.blocks.blockentities.ToiletBlockEntity;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.entity.ChairEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.SoundIDs;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicToiletBlock
extends AbstractSittableBlock
implements EntityBlock {
    private static final List<FurnitureBlock> BASIC_TOILET = new ArrayList<FurnitureBlock>();
    public static final EnumProperty<ToiletState> TOILET_STATE = EnumProperty.m_61587_((String)"toilet", ToiletState.class);
    protected static final VoxelShape TOILET_WEST = Shapes.m_83124_((VoxelShape)BasicToiletBlock.m_49796_((double)2.0, (double)1.0, (double)4.2, (double)14.0, (double)6.0, (double)11.7), (VoxelShape[])new VoxelShape[]{BasicToiletBlock.m_49796_((double)1.0, (double)0.0, (double)3.2, (double)15.0, (double)1.0, (double)12.7), BasicToiletBlock.m_49796_((double)5.0, (double)5.0, (double)2.5, (double)16.0, (double)10.0, (double)13.5), BasicToiletBlock.m_49796_((double)0.0, (double)6.0, (double)2.5, (double)5.0, (double)20.0, (double)13.5), BasicToiletBlock.m_49796_((double)5.0, (double)8.0, (double)3.5, (double)6.0, (double)21.0, (double)12.5)});
    protected static final VoxelShape TOILET_NORTH = DinnerTableBlock.rotateShape(Direction.WEST, Direction.NORTH, TOILET_WEST);
    protected static final VoxelShape TOILET_EAST = DinnerTableBlock.rotateShape(Direction.WEST, Direction.EAST, TOILET_WEST);
    protected static final VoxelShape TOILET_SOUTH = DinnerTableBlock.rotateShape(Direction.WEST, Direction.SOUTH, TOILET_WEST);

    public BasicToiletBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_(TOILET_STATE, (Comparable)((Object)ToiletState.EMPTY)));
        if (((Object)((Object)this)).getClass().isAssignableFrom(BasicToiletBlock.class)) {
            BASIC_TOILET.add(new FurnitureBlock((Block)this, "basic_toilet"));
        }
    }

    public static Stream<FurnitureBlock> streamBasicToilet() {
        return BASIC_TOILET.stream();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{TOILET_STATE});
        super.m_7926_(stateManager);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            player.m_36220_(Statistics.TOILET_USED);
        }
        if (!world.f_46443_ && state.m_61143_(TOILET_STATE) == ToiletState.EMPTY && player.m_21120_(hand).m_41720_() == Items.f_42589_ && PotionUtils.m_43579_((ItemStack)player.m_21120_(hand)) == Potions.f_43599_) {
            world.m_46597_(pos, (BlockState)state.m_61124_(TOILET_STATE, (Comparable)((Object)ToiletState.CLEAN)));
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
            }
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!world.f_46443_ && state.m_61143_(TOILET_STATE) == ToiletState.EMPTY && player.m_21120_(hand).m_41720_() == Items.f_42447_) {
            world.m_46597_(pos, (BlockState)state.m_61124_(TOILET_STATE, (Comparable)((Object)ToiletState.CLEAN)));
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
            }
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!world.f_46443_ && state.m_61143_(TOILET_STATE) == ToiletState.EMPTY) {
            BlockPos sourcePos = pos.m_7495_().m_7495_();
            BlockState sourceState = world.m_8055_(sourcePos);
            if (sourceState.m_60819_().m_76152_() == Fluids.f_76193_ && !sourceState.m_60819_().m_76178_()) {
                if (sourceState.m_61147_().contains(BlockStateProperties.f_61362_)) {
                    world.m_46597_(sourcePos, (BlockState)sourceState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                } else {
                    world.m_46597_(sourcePos, Blocks.f_50016_.m_49966_());
                }
                world.m_46597_(pos, (BlockState)state.m_61124_(TOILET_STATE, (Comparable)((Object)ToiletState.CLEAN)));
                return InteractionResult.SUCCESS;
            }
            if (world.m_6443_(ChairEntity.class, new AABB(pos), Entity::m_20160_).isEmpty()) {
                player.m_5661_((Component)new TranslatableComponent("message.pfm.toilet_use"), false);
            }
        } else if (!world.f_46443_ && state.m_61143_(TOILET_STATE) == ToiletState.DIRTY) {
            world.m_46597_(pos, (BlockState)state.m_61124_(TOILET_STATE, (Comparable)((Object)ToiletState.FLUSHING)));
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundIDs.TOILET_FLUSHING_EVENT, SoundSource.BLOCKS, 0.3f, 1.0f);
            ToiletBlockEntity blockEntity = (ToiletBlockEntity)world.m_7702_(pos);
            blockEntity.setFlushTimer(0);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        super.m_7100_(state, world, pos, random);
        if (state.m_61143_(TOILET_STATE) != ToiletState.DIRTY) {
            return;
        }
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        if (random.nextDouble() < 0.2) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123770_, x, y + 0.6, z, 0.8, 1.0, 0.0);
        }
        if (random.nextDouble() < 0.009) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123770_, x, y + 0.6, z, 0.18, 0.0, 0.34);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ToiletBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.TOILET_BLOCK_ENTITY, ToiletBlockEntity::tick);
    }

    public static void setClean(BlockState state, Level world, BlockPos pos) {
        BlockPos sourcePos = pos.m_7495_().m_7495_();
        BlockState sourceState = world.m_8055_(sourcePos);
        if (sourceState.m_60819_().m_76152_() == Fluids.f_76193_ && !sourceState.m_60819_().m_76178_()) {
            if (sourceState.m_61147_().contains(BlockStateProperties.f_61362_)) {
                world.m_46597_(sourcePos, (BlockState)sourceState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            } else {
                world.m_46597_(sourcePos, Blocks.f_50016_.m_49966_());
            }
            world.m_46597_(pos, (BlockState)state.m_61124_(TOILET_STATE, (Comparable)((Object)ToiletState.CLEAN)));
            return;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_(TOILET_STATE, (Comparable)((Object)ToiletState.EMPTY)), 3);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        return switch (dir) {
            case Direction.NORTH -> TOILET_NORTH;
            case Direction.SOUTH -> TOILET_SOUTH;
            case Direction.EAST -> TOILET_EAST;
            default -> TOILET_WEST;
        };
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

