/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MirrorBlock
extends HorizontalDirectionalBlock {
    protected static List<FurnitureBlock> mirrorBlockList = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape MIRROR_NORTH = Shapes.m_83124_((VoxelShape)MirrorBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape MIRROR_SOUTH = SimpleStoolBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIRROR_NORTH);
    protected static final VoxelShape MIRROR_EAST = SimpleStoolBlock.rotateShape(Direction.NORTH, Direction.EAST, MIRROR_NORTH);
    protected static final VoxelShape MIRROR_WEST = SimpleStoolBlock.rotateShape(Direction.NORTH, Direction.WEST, MIRROR_NORTH);

    public MirrorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        mirrorBlockList.add(new FurnitureBlock((Block)this, "mirror"));
    }

    public static Stream<FurnitureBlock> streamMirrorBlocks() {
        return mirrorBlockList.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_142300_(direction);
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction.m_122424_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == state.m_61143_((Property)f_54117_) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean canConnect(BlockState neighborState, BlockState state) {
        return PaladinFurnitureMod.getPFMConfig().doDifferentMirrorsConnect() ? neighborState.m_60734_() instanceof MirrorBlock && neighborState.m_61143_((Property)f_54117_) == state.m_61143_((Property)f_54117_) : neighborState.m_60734_() == state.m_60734_() && neighborState.m_61143_((Property)f_54117_) == state.m_61143_((Property)f_54117_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch (direction) {
            case SOUTH: {
                return MIRROR_SOUTH;
            }
            case EAST: {
                return MIRROR_EAST;
            }
            case WEST: {
                return MIRROR_WEST;
            }
        }
        return MIRROR_NORTH;
    }
}

