/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.DynamicRenderLayerInterface;
import com.unlikepaladin.pfm.blocks.PowerableBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PendantBlock
extends PowerableBlock
implements DynamicRenderLayerInterface {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    private final BlockState baseBlockState;
    private final Block baseBlock;
    private static final List<PendantBlock> PENDANTS = new ArrayList<PendantBlock>();
    private static final VoxelShape single = Shapes.m_83124_((VoxelShape)PendantBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), (VoxelShape[])new VoxelShape[]{PendantBlock.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), PendantBlock.m_49796_((double)7.5, (double)9.0, (double)7.5, (double)8.5, (double)15.5, (double)8.5), PendantBlock.m_49796_((double)6.5, (double)15.5, (double)6.5, (double)9.5, (double)16.0, (double)9.5)});
    private static final VoxelShape up = Shapes.m_83124_((VoxelShape)PendantBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), (VoxelShape[])new VoxelShape[]{PendantBlock.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), PendantBlock.m_49796_((double)7.5, (double)9.0, (double)7.5, (double)8.5, (double)16.0, (double)8.5)});
    private static final VoxelShape middle = PendantBlock.m_49796_((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)16.0, (double)8.5);
    private static final VoxelShape down = Shapes.m_83110_((VoxelShape)PendantBlock.m_49796_((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)15.5, (double)8.5), (VoxelShape)PendantBlock.m_49796_((double)6.5, (double)15.5, (double)6.5, (double)9.5, (double)16.0, (double)9.5));

    public PendantBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERLOCKED, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        PENDANTS.add(this);
    }

    public static Stream<PendantBlock> streamPendantLights() {
        return PENDANTS.stream();
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    @Override
    public void setPowered(Level world, BlockPos lightPos, boolean powered) {
        BlockState state = world.m_8055_(lightPos);
        world.m_46597_(lightPos, (BlockState)((BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)POWERLOCKED, (Comparable)Boolean.valueOf(powered)));
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public static BlockState canConnect(BlockState state, LevelAccessor world, BlockPos pos) {
        boolean up = world.m_8055_(pos.m_7494_()).m_60734_() instanceof PendantBlock;
        boolean down = world.m_8055_(pos.m_7495_()).m_60734_() instanceof PendantBlock;
        if (up) {
            return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)LIT, (Comparable)((Boolean)world.m_8055_(pos.m_7494_()).m_61143_((Property)LIT)));
        }
        return (BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return direction.m_122434_().m_122478_() ? PendantBlock.canConnect(state, world, pos) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue() && ((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            return middle;
        }
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            return up;
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            return down;
        }
        return single;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean powered = ctx.m_43725_().m_46753_(ctx.m_8083_());
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(powered));
        return PendantBlock.canConnect(state, (LevelAccessor)ctx.m_43725_(), ctx.m_8083_());
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        if (world.m_8055_(pos.m_7494_()).m_60734_() instanceof PendantBlock) {
            return;
        }
        boolean bl = (Boolean)state.m_61143_((Property)LIT);
        if (bl != world.m_46753_(pos)) {
            if (bl) {
                world.m_186460_(pos, (Block)this, 4);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.UP;
        return Block.m_49863_((LevelReader)world, (BlockPos)pos.m_142300_(direction), (Direction)direction.m_122424_()) || world.m_8055_(pos.m_142300_(direction)).m_60734_() instanceof PendantBlock;
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !world.m_46753_(pos) && !((Boolean)state.m_61143_((Property)POWERLOCKED)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP});
        builder.m_61104_(new Property[]{DOWN});
        builder.m_61104_(new Property[]{LIT});
        builder.m_61104_(new Property[]{POWERLOCKED});
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getCustomRenderLayer() {
        return RenderType.m_110466_();
    }
}

