/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShowerTowelBlock
extends HorizontalDirectionalBlock
implements DyeableFurnitureBlock {
    private static final List<FurnitureBlock> SHOWER_TOWELS = new ArrayList<FurnitureBlock>();
    private final DyeColor color;
    private static final VoxelShape TOWEL_SOUTH = Shapes.m_83124_((VoxelShape)ShowerTowelBlock.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)13.0, (double)5.0), (VoxelShape[])new VoxelShape[]{ShowerTowelBlock.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)3.0), ShowerTowelBlock.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)12.0, (double)4.0), ShowerTowelBlock.m_49796_((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0)});
    private static final VoxelShape TOWEL_NORTH = DinnerTableBlock.rotateShape(Direction.SOUTH, Direction.NORTH, TOWEL_SOUTH);
    private static final VoxelShape TOWEL_EAST = DinnerTableBlock.rotateShape(Direction.SOUTH, Direction.EAST, TOWEL_SOUTH);
    private static final VoxelShape TOWEL_WEST = DinnerTableBlock.rotateShape(Direction.SOUTH, Direction.WEST, TOWEL_SOUTH);

    public ShowerTowelBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.color = color;
        if (this.getClass().isAssignableFrom(ShowerTowelBlock.class)) {
            String towelColor = color.m_41065_();
            SHOWER_TOWELS.add(new FurnitureBlock((Block)this, towelColor + "_shower_towel"));
        }
    }

    public static Stream<FurnitureBlock> streamShowerTowels() {
        return SHOWER_TOWELS.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_142300_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)f_54117_) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch (direction) {
            case NORTH: {
                return TOWEL_NORTH;
            }
            case SOUTH: {
                return TOWEL_SOUTH;
            }
            case EAST: {
                return TOWEL_EAST;
            }
        }
        return TOWEL_WEST;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }
}

