/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.ArmChairColoredBlock;
import com.unlikepaladin.pfm.blocks.ArmChairShape;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleSofaBlock
extends ArmChairColoredBlock {
    private static final List<FurnitureBlock> SIMPLE_SOFAS = new ArrayList<FurnitureBlock>();
    public static final VoxelShape STANDARD = Shapes.m_83124_((VoxelShape)SimpleSofaBlock.m_49796_((double)11.7, (double)0.0, (double)12.0, (double)14.2, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{SimpleSofaBlock.m_49796_((double)11.7, (double)0.0, (double)1.5, (double)14.2, (double)3.0, (double)4.0), SimpleSofaBlock.m_49796_((double)0.7, (double)0.0, (double)1.5, (double)3.2, (double)3.0, (double)4.0), SimpleSofaBlock.m_49796_((double)0.7, (double)0.0, (double)12.0, (double)3.2, (double)3.0, (double)14.5), SimpleSofaBlock.m_49796_((double)5.0, (double)9.5, (double)13.0, (double)16.0, (double)13.71, (double)16.0), SimpleSofaBlock.m_49796_((double)5.0, (double)9.5, (double)0.0, (double)16.0, (double)13.71, (double)3.0), SimpleSofaBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.51, (double)16.0), SimpleSofaBlock.m_49796_((double)0.0, (double)9.5, (double)0.0, (double)5.0, (double)19.51, (double)16.0)});
    public static final VoxelShape OUTER = Shapes.m_83124_((VoxelShape)SimpleSofaBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.51, (double)16.0), (VoxelShape[])new VoxelShape[]{SimpleSofaBlock.m_49796_((double)0.0, (double)9.5, (double)0.0, (double)5.0, (double)19.51, (double)5.0), SimpleSofaBlock.m_49796_((double)11.7, (double)0.0, (double)12.0, (double)14.2, (double)3.0, (double)14.5), SimpleSofaBlock.m_49796_((double)0.7, (double)0.0, (double)1.5, (double)3.2, (double)3.0, (double)4.0)});
    public static final VoxelShape MIDDLE = Shapes.m_83110_((VoxelShape)SimpleSofaBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.51, (double)16.0), (VoxelShape)SimpleSofaBlock.m_49796_((double)0.0, (double)9.5, (double)0.0, (double)5.0, (double)19.51, (double)16.0));
    public static final VoxelShape INNER = Shapes.m_83124_((VoxelShape)SimpleSofaBlock.m_49796_((double)11.7, (double)0.0, (double)1.5, (double)14.2, (double)3.0, (double)4.0), (VoxelShape[])new VoxelShape[]{SimpleSofaBlock.m_49796_((double)0.7, (double)0.0, (double)12.0, (double)3.2, (double)3.0, (double)14.5), SimpleSofaBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.51, (double)16.0), SimpleSofaBlock.m_49796_((double)0.0, (double)9.5, (double)0.0, (double)5.0, (double)19.51, (double)11.0), SimpleSofaBlock.m_49796_((double)0.0, (double)9.5, (double)11.0, (double)16.0, (double)19.51, (double)16.0)});
    public static final VoxelShape RIGHT_EDGE = Shapes.m_83124_((VoxelShape)SimpleSofaBlock.m_49796_((double)11.7, (double)0.0, (double)1.5, (double)14.2, (double)3.0, (double)4.0), (VoxelShape[])new VoxelShape[]{SimpleSofaBlock.m_49796_((double)0.7, (double)0.0, (double)1.5, (double)3.2, (double)3.0, (double)4.0), SimpleSofaBlock.m_49796_((double)5.0, (double)9.5, (double)0.0, (double)16.0, (double)13.71, (double)3.0), SimpleSofaBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.51, (double)16.0), SimpleSofaBlock.m_49796_((double)0.0, (double)9.5, (double)0.0, (double)5.0, (double)19.51, (double)16.0)});
    public static final VoxelShape LEFT_EDGE = Shapes.m_83124_((VoxelShape)SimpleSofaBlock.m_49796_((double)0.7, (double)0.0, (double)12.0, (double)3.2, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{SimpleSofaBlock.m_49796_((double)11.7, (double)0.0, (double)12.0, (double)14.2, (double)3.0, (double)14.5), SimpleSofaBlock.m_49796_((double)5.0, (double)9.5, (double)13.0, (double)16.0, (double)13.71, (double)16.0), SimpleSofaBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.51, (double)16.0), SimpleSofaBlock.m_49796_((double)0.0, (double)9.5, (double)0.0, (double)5.0, (double)19.51, (double)16.0)});
    public static final VoxelShape STANDARD_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, STANDARD);
    public static final VoxelShape STANDARD_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, STANDARD);
    public static final VoxelShape STANDARD_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, STANDARD);
    public static final VoxelShape MIDDLE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, MIDDLE);
    public static final VoxelShape MIDDLE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, MIDDLE);
    public static final VoxelShape MIDDLE_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, MIDDLE);
    public static final VoxelShape OUTER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, OUTER);
    public static final VoxelShape OUTER_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, OUTER);
    public static final VoxelShape OUTER_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, OUTER);
    public static final VoxelShape INNER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, INNER);
    public static final VoxelShape INNER_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, INNER);
    public static final VoxelShape INNER_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, INNER);
    public static final VoxelShape RIGHT_EDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, RIGHT_EDGE);
    public static final VoxelShape RIGHT_EDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, RIGHT_EDGE);
    public static final VoxelShape RIGHT_EDGE_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, RIGHT_EDGE);
    public static final VoxelShape LEFT_EDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, LEFT_EDGE);
    public static final VoxelShape LEFT_EDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, LEFT_EDGE);
    public static final VoxelShape LEFT_EDGE_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, LEFT_EDGE);

    public SimpleSofaBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(color, settings);
        SIMPLE_SOFAS.add(new FurnitureBlock((Block)this, "arm_chair"));
    }

    public static Stream<FurnitureBlock> streamSimpleSofas() {
        return SIMPLE_SOFAS.stream();
    }

    @Override
    public boolean canConnect(BlockGetter world, BlockPos pos, Direction direction, Direction tableDirection) {
        BlockState state = world.m_8055_(pos.m_142300_(direction));
        boolean canConnect = state.m_60734_() instanceof SimpleSofaBlock;
        return canConnect;
    }

    @Override
    public boolean isArmChair(BlockState state) {
        return state.m_60734_().getClass().isAssignableFrom(SimpleSofaBlock.class) && state.m_60734_() instanceof SimpleSofaBlock;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        ArmChairShape shape = (ArmChairShape)((Object)state.m_61143_((Property)SHAPE));
        switch (shape) {
            case STRAIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> STANDARD_NORTH;
                    case Direction.SOUTH -> STANDARD_SOUTH;
                    case Direction.EAST -> STANDARD_EAST;
                    default -> STANDARD;
                };
            }
            case MIDDLE: {
                return switch (dir) {
                    case Direction.NORTH -> MIDDLE_NORTH;
                    case Direction.SOUTH -> MIDDLE_SOUTH;
                    case Direction.EAST -> MIDDLE_EAST;
                    default -> MIDDLE;
                };
            }
            case OUTER_LEFT: {
                return switch (dir) {
                    case Direction.NORTH -> OUTER;
                    case Direction.SOUTH -> OUTER_EAST;
                    case Direction.EAST -> OUTER_NORTH;
                    default -> OUTER_SOUTH;
                };
            }
            case OUTER_RIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> OUTER_NORTH;
                    case Direction.SOUTH -> OUTER_SOUTH;
                    case Direction.EAST -> OUTER_EAST;
                    default -> OUTER;
                };
            }
            case LEFT_EDGE: {
                return switch (dir) {
                    case Direction.NORTH -> LEFT_EDGE_NORTH;
                    case Direction.SOUTH -> LEFT_EDGE_SOUTH;
                    case Direction.EAST -> LEFT_EDGE_EAST;
                    default -> LEFT_EDGE;
                };
            }
            case RIGHT_EDGE: {
                return switch (dir) {
                    case Direction.NORTH -> RIGHT_EDGE_NORTH;
                    case Direction.SOUTH -> RIGHT_EDGE_SOUTH;
                    case Direction.EAST -> RIGHT_EDGE_EAST;
                    default -> RIGHT_EDGE;
                };
            }
            case INNER_RIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> INNER_EAST;
                    case Direction.SOUTH -> INNER;
                    case Direction.EAST -> INNER_SOUTH;
                    default -> INNER_NORTH;
                };
            }
            case INNER_LEFT: {
                return switch (dir) {
                    case Direction.NORTH -> INNER_NORTH;
                    case Direction.SOUTH -> INNER_SOUTH;
                    case Direction.EAST -> INNER_EAST;
                    default -> INNER;
                };
            }
        }
        return STANDARD;
    }
}

