/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.DynamicRenderLayerInterface;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.StoveBlockEntity;
import com.unlikepaladin.pfm.blocks.forge.StoveBlockImpl;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StoveBlock
extends SmokerBlock
implements DynamicRenderLayerInterface {
    private static final List<FurnitureBlock> STOVES = new ArrayList<FurnitureBlock>();
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected static final VoxelShape STOVE = Shapes.m_83124_((VoxelShape)StoveBlock.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{StoveBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), StoveBlock.m_49796_((double)0.0, (double)16.0, (double)15.0, (double)16.0, (double)19.0, (double)16.0)});
    protected static final VoxelShape STOVE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STOVE);
    protected static final VoxelShape STOVE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, STOVE);
    protected static final VoxelShape STOVE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, STOVE);

    public StoveBlock(BlockBehaviour.Properties settings) {
        super(settings);
        if (this.getClass().isAssignableFrom(StoveBlock.class)) {
            STOVES.add(new FurnitureBlock((Block)this, "stove"));
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_48683_, (Comparable)Direction.NORTH)).m_61124_((Property)f_48684_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public static Stream<FurnitureBlock> streamStoves() {
        return STOVES.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_48683_, f_48684_, OPEN});
    }

    protected void m_7137_(Level world, BlockPos pos, Player player) {
        StoveBlock.openMenuScreen(world, pos, player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openMenuScreen(Level world, BlockPos pos, Player player) {
        void var2_2;
        void var1_1;
        StoveBlockImpl.openMenuScreen(world, (BlockPos)var1_1, (Player)var2_2);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (PaladinFurnitureMod.getModList().contains("cookingforblockheads")) {
            return StoveBlock.onUseCookingForBlockheads(state, world, pos, player, hand, hit);
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (hit.m_82434_() == Direction.UP && world.m_7702_(pos) instanceof StoveBlockEntity) {
            ItemStack itemStack;
            StoveBlockEntity stoveBlockEntity;
            Optional<CampfireCookingRecipe> optional;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof StoveBlockEntity && (optional = (stoveBlockEntity = (StoveBlockEntity)blockEntity).getRecipeFor(itemStack = player.m_21120_(hand))).isPresent() && stoveBlockEntity.addItem(player.m_150110_().f_35937_ ? itemStack.m_41777_() : itemStack, optional.get().m_43753_())) {
                player.m_36220_(Statistics.STOVE_OPENED);
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof StoveBlockEntity) {
                stoveBlockEntity = (StoveBlockEntity)blockEntity;
                for (int i = 0; i < stoveBlockEntity.getItemsBeingCooked().size(); ++i) {
                    ItemStack stack = (ItemStack)stoveBlockEntity.getItemsBeingCooked().get(i);
                    if (stack.m_41619_() || !world.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{stack}), world).isEmpty()) continue;
                    ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, stoveBlockEntity.m_8016_(i));
                    world.m_7967_((Entity)itemEntity);
                    player.m_36220_(Statistics.STOVE_OPENED);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        this.m_7137_(world, pos, player);
        return InteractionResult.CONSUME;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_48683_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_48683_);
        return switch (dir) {
            case Direction.WEST -> STOVE_WEST;
            case Direction.NORTH -> STOVE;
            case Direction.SOUTH -> STOVE_SOUTH;
            default -> STOVE_EAST;
        };
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        if (!((Boolean)state.m_61143_((Property)f_48684_)).booleanValue()) {
            return;
        }
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        if (random.nextDouble() < 0.1) {
            world.m_7785_(x, y, z, SoundEvents.f_12472_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        int min = 0;
        int max = 3;
        int griddleChosen = (int)Math.floor(Math.random() * (double)(max - min + 1) + (double)min);
        switch (griddleChosen) {
            case 0: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x - 0.25, y + 1.1, z - 0.2, 0.0, 0.0, 0.0);
                break;
            }
            case 1: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + 0.25, y + 1.1, z - 0.2, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + 0.25, y + 1.1, z + 0.2, 0.0, 0.0, 0.0);
                break;
            }
            case 3: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x - 0.25, y + 1.1, z + 0.2, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return StoveBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return StoveBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return StoveBlock.getModdedTicker(world, state, type);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> BlockEntityTicker<T> getModdedTicker(Level world, BlockState state, BlockEntityType<T> type) {
        void var2_2;
        void var1_1;
        return StoveBlockImpl.getModdedTicker(world, (BlockState)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static InteractionResult onUseCookingForBlockheads(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return StoveBlockImpl.onUseCookingForBlockheads(blockState, (Level)var1_1, (BlockPos)var2_2, (Player)var3_3, (InteractionHand)var4_4, (BlockHitResult)var5_5);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof StoveBlockEntity) {
            if (world instanceof ServerLevel) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((StoveBlockEntity)blockEntity));
                ((StoveBlockEntity)blockEntity).m_154995_((ServerLevel)world, Vec3.m_82512_((Vec3i)pos));
                Containers.m_19010_((Level)world, (BlockPos)pos, ((StoveBlockEntity)blockEntity).getItemsBeingCooked());
            }
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getCustomRenderLayer() {
        return RenderType.m_110466_();
    }
}

