/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.ClassicStoolBlock;
import com.unlikepaladin.pfm.menus.WorkbenchScreenHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WorkingTableBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    private static final List<WorkingTableBlock> WORKING_TABLES = new ArrayList<WorkingTableBlock>();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final Component TITLE = new TranslatableComponent("container.pfm.working_table");
    public static VoxelShape WORKTABLE_SHAPE = Shapes.m_83124_((VoxelShape)WorkingTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{WorkingTableBlock.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), WorkingTableBlock.m_49796_((double)1.5, (double)0.0, (double)1.0, (double)4.5, (double)1.0, (double)15.0), WorkingTableBlock.m_49796_((double)11.5, (double)0.0, (double)1.0, (double)14.5, (double)1.0, (double)15.0), WorkingTableBlock.m_49796_((double)0.0, (double)16.0, (double)14.0, (double)16.0, (double)18.0, (double)16.0), WorkingTableBlock.m_49796_((double)0.0, (double)16.0, (double)12.0, (double)1.0, (double)17.0, (double)14.0), WorkingTableBlock.m_49796_((double)15.0, (double)16.0, (double)12.0, (double)16.0, (double)17.0, (double)14.0)});
    public static VoxelShape WORKTABLE_SHAPE_SOUTH = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.SOUTH, WORKTABLE_SHAPE);
    public static VoxelShape WORKTABLE_SHAPE_EAST = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.EAST, WORKTABLE_SHAPE);
    public static VoxelShape WORKTABLE_SHAPE_WEST = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.WEST, WORKTABLE_SHAPE);

    public WorkingTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
        WORKING_TABLES.add(this);
    }

    public static Stream<WorkingTableBlock> streamWorkingTables() {
        return WORKING_TABLES.stream();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(world, pos));
        return InteractionResult.CONSUME;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return WORKTABLE_SHAPE_SOUTH;
            }
            case SOUTH: {
                return WORKTABLE_SHAPE;
            }
            case WEST: {
                return WORKTABLE_SHAPE_EAST;
            }
        }
        return WORKTABLE_SHAPE_WEST;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        return new SimpleMenuProvider((syncId, inventory, player) -> new WorkbenchScreenHandler(syncId, inventory, ContainerLevelAccess.m_39289_((Level)world, (BlockPos)pos)), TITLE);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

