/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.MicrowaveBlock;
import com.unlikepaladin.pfm.blocks.blockentities.forge.MicrowaveBlockEntityImpl;
import com.unlikepaladin.pfm.menus.MicrowaveScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.SoundIDs;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MicrowaveBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider,
WorldlyContainer,
RecipeHolder {
    public boolean isActive = false;
    private final ContainerOpenersCounter stateManager = new ContainerOpenersCounter(){

        protected void m_142292_(Level world, BlockPos pos, BlockState state) {
            if (state.m_60734_() instanceof MicrowaveBlock) {
                MicrowaveBlockEntity.this.playSound(state, SoundEvents.f_12012_, 0);
                MicrowaveBlockEntity.this.setOpen(state, true);
            }
        }

        protected void m_142289_(Level world, BlockPos pos, BlockState state) {
            if (state.m_60734_() instanceof MicrowaveBlock) {
                MicrowaveBlockEntity.this.playSound(state, SoundEvents.f_12011_, 0);
                MicrowaveBlockEntity.this.setOpen(state, false);
            }
        }

        protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof MicrowaveScreenHandler) {
                Container inventory = ((MicrowaveScreenHandler)player.f_36096_).getInventory();
                return inventory == MicrowaveBlockEntity.this;
            }
            return false;
        }
    };
    private static final int[] TOP_SLOTS = new int[]{0};
    public NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    int cookTime;
    int cookTimeTotal;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return MicrowaveBlockEntity.this.cookTime;
                }
                case 1: {
                    return MicrowaveBlockEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MicrowaveBlockEntity.this.cookTime = value;
                    break;
                }
                case 1: {
                    MicrowaveBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.f_44110_;

    public MicrowaveBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.MICROWAVE_BLOCK_ENTITY, pos, state);
        this.f_58857_ = this.m_58904_();
    }

    void playSound(BlockState state, SoundEvent soundEvent, int pitch) {
        float i;
        Vec3i vec3i = ((Direction)state.m_61143_((Property)MicrowaveBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        i = pitch == 0 ? (i = this.f_58857_.f_46441_.nextFloat() * 0.2f + 0.9f) : (i = (float)pitch);
        this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, i);
    }

    public ContainerData getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.pfm.microwave");
    }

    private static int getCookTime(Level world, RecipeType<? extends AbstractCookingRecipe> recipeType, Container inventory) {
        return world.m_7465_().m_44015_(recipeType, inventory, world).map(AbstractCookingRecipe::m_43753_).orElse(200);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.cookTime = nbt.m_128448_("CookTime");
        this.cookTimeTotal = nbt.m_128448_("CookTimeTotal");
        CompoundTag nbtCompound = nbt.m_128469_("RecipesUsed");
        this.isActive = nbt.m_128471_("isActive");
        for (String string : nbtCompound.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(string), nbtCompound.m_128451_(string));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128376_("CookTime", (short)this.cookTime);
        nbt.m_128376_("CookTimeTotal", (short)this.cookTimeTotal);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        CompoundTag nbtCompound = new CompoundTag();
        nbt.m_128379_("isActive", this.isActive);
        this.recipesUsed.forEach((identifier, integer) -> nbtCompound.m_128405_(identifier.toString(), integer.intValue()));
        nbt.m_128365_("RecipesUsed", (Tag)nbtCompound);
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.UP || side == Direction.DOWN) {
            return TOP_SLOTS;
        }
        return null;
    }

    protected Component m_6820_() {
        return this.m_5446_();
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new MicrowaveScreenHandler(this, syncId, playerInventory, (Container)this, this.propertyDelegate);
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return dir == Direction.DOWN && this.getRecipe((Container)new SimpleContainer(new ItemStack[]{stack})) == null;
    }

    public Recipe<?> getRecipe(Container inventory) {
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44110_, inventory, this.f_58857_).orElse(null);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return slot == 0;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        this.m_6596_();
        return stack;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = ContainerHelper.m_18966_(this.inventory, (int)slot);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        this.m_6596_();
        return stack;
    }

    public void provideRecipeInputs(StackedContents finder) {
        for (ItemStack itemStack : this.inventory) {
            finder.m_36491_(itemStack);
        }
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(slot);
        boolean bl = !stack.m_41619_() && stack.m_41656_(itemStack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemStack);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !bl) {
            this.cookTimeTotal = MicrowaveBlockEntity.getCookTime(this.f_58857_, this.recipeType, (Container)this);
            this.cookTime = 0;
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public Recipe<?> getRecipe() {
        return this.f_58857_.m_7465_().m_44015_(this.recipeType, (Container)this, this.f_58857_).orElse(null);
    }

    public static boolean canAcceptRecipeOutput(@Nullable Recipe<?> recipe, NonNullList<ItemStack> slots, int count) {
        if (((ItemStack)slots.get(0)).m_41619_() || recipe == null) {
            return false;
        }
        ItemStack itemStack = recipe.m_8043_();
        if (itemStack.m_41619_()) {
            return false;
        }
        ItemStack itemStack2 = (ItemStack)slots.get(0);
        if (itemStack2.m_41613_() < count && itemStack2.m_41613_() < itemStack2.m_41741_()) {
            return true;
        }
        return itemStack2.m_41613_() < itemStack.m_41741_();
    }

    public void m_6211_() {
        this.inventory.clear();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation identifier = recipe.m_6423_();
            this.recipesUsed.addTo((Object)identifier, 1);
        }
    }

    private static boolean craftRecipe(@Nullable Recipe<?> recipe, NonNullList<ItemStack> slots, int count) {
        if (recipe == null || !MicrowaveBlockEntity.canAcceptRecipeOutput(recipe, slots, count)) {
            return false;
        }
        ItemStack itemStack2 = recipe.m_8043_();
        slots.set(0, (Object)itemStack2.m_41777_());
        return true;
    }

    void setOpen(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)MicrowaveBlock.OPEN, (Comparable)Boolean.valueOf(open)), 10);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, MicrowaveBlockEntity blockEntity) {
        boolean bl = blockEntity.isActive;
        boolean bl2 = false;
        ItemStack itemStack = (ItemStack)blockEntity.inventory.get(0);
        if (blockEntity.isActive || !itemStack.m_41619_()) {
            Recipe recipe = world.m_7465_().m_44015_(blockEntity.recipeType, (Container)blockEntity, world).orElse(null);
            int i = blockEntity.m_6893_();
            if (blockEntity.isActive && MicrowaveBlockEntity.canAcceptRecipeOutput(recipe, blockEntity.inventory, i)) {
                ++blockEntity.cookTime;
                if (blockEntity.cookTime == blockEntity.cookTimeTotal) {
                    blockEntity.cookTime = 0;
                    blockEntity.cookTimeTotal = MicrowaveBlockEntity.getCookTime(world, blockEntity.recipeType, (Container)blockEntity);
                    if (MicrowaveBlockEntity.craftRecipe(recipe, blockEntity.inventory, i)) {
                        blockEntity.m_6029_(recipe);
                        state = (BlockState)state.m_61124_((Property)MicrowaveBlock.POWERED, (Comparable)Boolean.valueOf(false));
                        blockEntity.f_58857_.m_7731_(pos, state, 10);
                        blockEntity.playSound(state, SoundIDs.MICROWAVE_BEEP_EVENT, 1);
                        MicrowaveBlockEntity.setActiveonClient(blockEntity, false);
                        world.m_7260_(pos, state, state, 2);
                    }
                    bl2 = true;
                } else {
                    blockEntity.playSound(state, SoundIDs.MICROWAVE_RUNNING_EVENT, 1);
                }
            } else {
                blockEntity.cookTime = 0;
                if (itemStack.m_41619_()) {
                    MicrowaveBlockEntity.setActiveonClient(blockEntity, false);
                    world.m_7260_(pos, state, state, 2);
                }
            }
        } else if (!blockEntity.isActive && blockEntity.cookTime > 0) {
            blockEntity.cookTime = Mth.m_14045_((int)(blockEntity.cookTime - 2), (int)0, (int)blockEntity.cookTimeTotal);
        }
        if (bl != blockEntity.isActive) {
            bl2 = true;
        }
        if (bl2) {
            MicrowaveBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)MicrowaveBlock.FACING);
    }

    public void setActive(boolean active) {
        this.isActive = active;
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.m_128379_("isActive", active);
        this.m_183515_(nbtCompound);
        this.m_6596_();
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MicrowaveBlock.POWERED, (Comparable)Boolean.valueOf(true)), 2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setActiveonClient(MicrowaveBlockEntity microwaveBlockEntity, boolean active) {
        void var1_1;
        MicrowaveBlockEntityImpl.setActiveonClient(microwaveBlockEntity, (boolean)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends MicrowaveBlockEntity> getFactory() {
        return MicrowaveBlockEntityImpl.getFactory();
    }
}

