/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.PFMToasterBlock;
import com.unlikepaladin.pfm.blocks.blockentities.forge.PFMToasterBlockEntityImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PFMToasterBlockEntity
extends BlockEntity
implements WorldlyContainer {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    @Nullable
    private UUID lastUser;
    private static int toastTime = 240;
    private int toastProgress = 0;
    private boolean toasting = false;
    private boolean smoking = false;
    private int smokeProgress = 0;
    private boolean currentlyPowered = false;
    private boolean previouslyPowered = false;
    private boolean updateNeighbors = false;
    private boolean tickPitch = false;

    public PFMToasterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.TOASTER_BLOCK_ENTITY, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        this.toastProgress = nbt.m_128451_("toastProgress");
        this.toasting = nbt.m_128471_("toasting");
        this.smokeProgress = nbt.m_128451_("smokeProgress");
        this.smoking = nbt.m_128471_("smoking");
        this.lastUser = nbt.m_128441_("lastUser") ? nbt.m_128342_("lastUser") : null;
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("toastProgress", this.toastProgress);
        nbt.m_128379_("toasting", this.toasting);
        nbt.m_128405_("smokeProgress", this.smokeProgress);
        nbt.m_128379_("smoking", this.smoking);
        if (this.lastUser == null) {
            nbt.m_128473_("lastUser");
        } else {
            nbt.m_128362_("lastUser", this.lastUser);
        }
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        super.m_183515_(nbt);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    private void explode() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7471_(this.f_58858_, true);
            this.f_58857_.m_46518_((Entity)this.f_58857_.m_45924_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123343_(), 8.0, 10.0, false), (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 2.2f, true, Explosion.BlockInteraction.DESTROY);
        }
    }

    public Direction getToasterFacing() {
        if (this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof PFMToasterBlock) {
            return (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return Direction.NORTH;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItem(int i, ItemStack stack) {
        this.items.set(i, (Object)stack);
        PFMToasterBlockEntity.sync(this, this.f_58857_);
    }

    public Optional<Player> getLastUser() {
        return Optional.ofNullable(this.lastUser).map(arg_0 -> ((Level)this.f_58857_).m_46003_(arg_0));
    }

    public void setLastUser(@Nullable Player player) {
        this.lastUser = player == null ? null : player.m_142081_();
    }

    public ItemStack takeItem(@Nullable Player player) {
        int index = !((ItemStack)this.items.get(1)).m_41619_() ? 1 : 0;
        ItemStack stack = (ItemStack)this.items.get(index);
        this.items.set(index, (Object)ItemStack.f_41583_);
        this.updateNeighbors = true;
        this.setLastUser(player);
        return stack;
    }

    public boolean addItem(InteractionHand hand, Player player) {
        if (!this.toasting) {
            ItemStack playerItem = player.m_21120_(hand).m_41777_();
            playerItem.m_41764_(1);
            if (!((ItemStack)this.items.get(0)).m_41619_() && !((ItemStack)this.items.get(1)).m_41619_()) {
                return false;
            }
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            int index = !((ItemStack)this.items.get(0)).m_41619_() ? 1 : 0;
            this.items.set(index, (Object)playerItem);
            this.updateNeighbors = true;
            this.setLastUser(player);
            return true;
        }
        return false;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isMetal(ItemStack stack) {
        return PFMToasterBlockEntityImpl.isMetal(stack);
    }

    public boolean hasMetalInside() {
        if (PaladinFurnitureMod.getModList().contains("sandwichable")) {
            return PFMToasterBlockEntity.isMetal((ItemStack)this.items.get(0)) || PFMToasterBlockEntity.isMetal((ItemStack)this.items.get(1));
        }
        return ((ItemStack)this.items.get(0)).m_41778_().contains("iron") || ((ItemStack)this.items.get(1)).m_41778_().contains("iron");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sandwichableToast(PFMToasterBlockEntity pfmToasterBlockEntity) {
        PFMToasterBlockEntityImpl.sandwichableToast(pfmToasterBlockEntity);
    }

    private void toastItems() {
        if (PaladinFurnitureMod.getModList().contains("sandwichable")) {
            PFMToasterBlockEntity.sandwichableToast(this);
        } else {
            for (int i = 0; i < 2; ++i) {
                SimpleContainer inv = new SimpleContainer(new ItemStack[]{(ItemStack)this.items.get(i)});
                Optional match = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)inv, this.f_58857_);
                boolean changed = false;
                if (match.isPresent()) {
                    this.items.set(i, (Object)((CampfireCookingRecipe)match.get()).m_8043_().m_41777_());
                    changed = true;
                    continue;
                }
                if (!((ItemStack)this.items.get(i)).m_41614_()) continue;
                Item item = Items.f_42413_;
                this.items.set(i, (Object)new ItemStack((ItemLike)item, 1));
                changed = true;
            }
        }
    }

    public void startToasting(@Nullable Player player) {
        if (this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof PFMToasterBlock) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PFMToasterBlock.ON, (Comparable)Boolean.valueOf(true)));
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12632_, SoundSource.BLOCKS, 0.5f, 0.8f);
        this.toastProgress = 0;
        this.toasting = true;
        this.updateNeighbors = true;
        if (player != null) {
            this.setLastUser(player);
        }
    }

    public void stopToasting(@Nullable Player player) {
        if (this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof PFMToasterBlock) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PFMToasterBlock.ON, (Comparable)Boolean.valueOf(false)));
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12210_, SoundSource.BLOCKS, 0.8f, 4.0f);
        this.toastProgress = 0;
        this.toasting = false;
        this.updateNeighbors = true;
        if (player != null) {
            this.setLastUser(player);
        }
    }

    public int getComparatorOutput() {
        int r = 0;
        for (int i = 0; i < 2; ++i) {
            r += ((ItemStack)this.items.get(i)).m_41619_() ? 0 : 1;
        }
        r = (int)Math.round((double)r * 7.5);
        return r;
    }

    public boolean isToasting() {
        return this.toasting;
    }

    public int getToastingProgress() {
        return this.toastProgress;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, PFMToasterBlockEntity blockEntity) {
        int smokeTime = 80;
        if (blockEntity.updateNeighbors) {
            world.m_6289_(pos, world.m_8055_(pos).m_60734_());
            blockEntity.updateNeighbors = false;
        }
        blockEntity.previouslyPowered = blockEntity.currentlyPowered;
        blockEntity.currentlyPowered = world.m_46753_(pos);
        if (blockEntity.toasting) {
            ++blockEntity.toastProgress;
            if (blockEntity.toastProgress % 4 == 0 && blockEntity.toastProgress != toastTime) {
                world.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.05f, blockEntity.tickPitch ? 2.0f : 1.9f);
                boolean bl = blockEntity.tickPitch = !blockEntity.tickPitch;
            }
            if (blockEntity.hasMetalInside()) {
                blockEntity.explode();
            }
        }
        if (blockEntity.toastProgress == toastTime) {
            blockEntity.stopToasting(null);
            blockEntity.toastItems();
            blockEntity.smoking = true;
        }
        if (blockEntity.smoking) {
            if (blockEntity.smokeProgress % 3 == 0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, 0.0, 0.03, 0.0);
            }
            ++blockEntity.smokeProgress;
        }
        if (blockEntity.smokeProgress == smokeTime) {
            blockEntity.smoking = false;
            blockEntity.smokeProgress = 0;
        }
        if (blockEntity.currentlyPowered && !blockEntity.previouslyPowered && !blockEntity.toasting) {
            blockEntity.startToasting(null);
        }
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1};
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return ((ItemStack)this.items.get(slot)).m_41619_();
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)PFMToasterBlock.ON) == false;
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.m_8016_(slot);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = ((ItemStack)this.items.get(slot)).m_41777_();
        this.items.set(slot, (Object)ItemStack.f_41583_);
        this.setLastUser(null);
        PFMToasterBlockEntity.sync(this, this.f_58857_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        this.setLastUser(null);
        PFMToasterBlockEntity.sync(this, this.f_58857_);
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public void m_6211_() {
        this.items.clear();
        PFMToasterBlockEntity.sync(this, this.f_58857_);
    }

    public static void sync(PFMToasterBlockEntity blockEntity, Level world) {
        if (!world.f_46443_) {
            ((ServerLevel)world).m_7726_().m_8450_(blockEntity.m_58899_());
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends PFMToasterBlockEntity> getFactory() {
        return PFMToasterBlockEntityImpl.getFactory();
    }
}

