/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.basicDeskCabinet.forge;

import com.unlikepaladin.pfm.blocks.BasicDeskCabinetBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.blocks.models.forge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.forge.PFMForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeBasicDeskCabinetModel
extends PFMForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();
    public static ModelProperty<BlockState> NEIGHBOR_FACING = new ModelProperty();
    public static ModelProperty<BlockState> NEIGHBOR_OPPOSITE = new ModelProperty();

    public ForgeBasicDeskCabinetModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    public void appendProperties(ModelDataMap.Builder builder) {
        super.appendProperties(builder);
        builder.withProperty(CONNECTIONS);
        builder.withProperty(NEIGHBOR_FACING);
        builder.withProperty(NEIGHBOR_OPPOSITE);
    }

    @Override
    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData tileData) {
        if (state.m_60734_() instanceof BasicDeskCabinetBlock) {
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            this.appendProperties(builder);
            ModelDataMap data = builder.build();
            super.getModelData(world, pos, state, (IModelData)data);
            BasicDeskCabinetBlock block = (BasicDeskCabinetBlock)state.m_60734_();
            boolean north = block.canConnect(world.m_8055_(pos.m_142127_()));
            boolean east = block.canConnect(world.m_8055_(pos.m_142126_()));
            boolean west = block.canConnect(world.m_8055_(pos.m_142125_()));
            boolean south = block.canConnect(world.m_8055_(pos.m_142128_()));
            Direction isFacing = (Direction)state.m_61143_((Property)BasicDeskCabinetBlock.FACING);
            BlockState neighborStateFacing = world.m_8055_(pos.m_142300_(isFacing));
            BlockState neighborStateOpposite = world.m_8055_(pos.m_142300_(isFacing.m_122424_()));
            boolean isNeighborStateOppositeFacingDifferentDirection = neighborStateOpposite.m_61138_((Property)BlockStateProperties.f_61374_) ? block.isDifferentOrientation((BlockGetter)world, pos, (Direction)neighborStateOpposite.m_61143_((Property)BlockStateProperties.f_61374_)) : false;
            boolean isNeighborStateFacingDifferentDirection = neighborStateFacing.m_61138_((Property)BlockStateProperties.f_61374_) ? block.isDifferentOrientation((BlockGetter)world, pos, ((Direction)neighborStateFacing.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_()) : false;
            BlockState rightState = world.m_8055_(pos.m_142300_(isFacing.m_122428_()));
            boolean right = block.canConnect(rightState) && rightState.m_60734_() instanceof BasicDeskCabinetBlock;
            BlockState leftState = world.m_8055_(pos.m_142300_(isFacing.m_122427_()));
            boolean left = block.canConnect(leftState) && leftState.m_60734_() instanceof BasicDeskCabinetBlock;
            BitSet set = new BitSet();
            set.set(0, north);
            set.set(1, east);
            set.set(2, west);
            set.set(3, south);
            set.set(4, left);
            set.set(5, right);
            set.set(6, isNeighborStateOppositeFacingDifferentDirection);
            set.set(7, isNeighborStateFacingDifferentDirection);
            data.setData(CONNECTIONS, (Object)new ModelBitSetProperty(set));
            data.setData(NEIGHBOR_FACING, (Object)neighborStateFacing);
            data.setData(NEIGHBOR_OPPOSITE, (Object)neighborStateOpposite);
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        if (state != null && state.m_60734_() instanceof BasicDeskCabinetBlock && extraData.getData(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.getData(ForgeBasicDeskCabinetModel.CONNECTIONS)).connections != null) {
            int openOffset;
            ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
            BasicDeskCabinetBlock block = (BasicDeskCabinetBlock)state.m_60734_();
            BitSet set = ((ModelBitSetProperty)extraData.getData(ForgeBasicDeskCabinetModel.CONNECTIONS)).connections;
            boolean north = set.get(0);
            boolean east = set.get(1);
            boolean west = set.get(2);
            boolean south = set.get(3);
            Direction isFacing = (Direction)state.m_61143_((Property)BasicDeskCabinetBlock.FACING);
            switch (isFacing) {
                case SOUTH: {
                    secondaryQuads.addAll(this.legsDesk(state, side, rand, extraData, north, south, east, west, 18, 19, 16, 17));
                    break;
                }
                case NORTH: {
                    secondaryQuads.addAll(this.legsDesk(state, side, rand, extraData, north, south, east, west, 17, 16, 19, 18));
                    break;
                }
                case EAST: {
                    secondaryQuads.addAll(this.legsDesk(state, side, rand, extraData, north, south, east, west, 19, 17, 18, 16));
                    break;
                }
                default: {
                    secondaryQuads.addAll(this.legsDesk(state, side, rand, extraData, north, south, east, west, 16, 18, 17, 19));
                }
            }
            boolean left = set.get(4);
            boolean right = set.get(5);
            boolean isNeighborStateOppositeFacingDifferentDirection = set.get(6);
            boolean isNeighborStateFacingDifferentDirection = set.get(7);
            BlockState neighborStateFacing = (BlockState)extraData.getData(NEIGHBOR_FACING);
            BlockState neighborStateOpposite = (BlockState)extraData.getData(NEIGHBOR_OPPOSITE);
            int n = openOffset = (Boolean)state.m_61143_((Property)BasicDeskCabinetBlock.OPEN) != false ? 8 : 0;
            if (block.canConnect(neighborStateFacing) && neighborStateFacing.m_61138_((Property)BlockStateProperties.f_61374_)) {
                neighborFacing = (Direction)neighborStateFacing.m_61143_((Property)BlockStateProperties.f_61374_);
                if (neighborFacing.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() && isNeighborStateFacingDifferentDirection) {
                    if (neighborFacing == isFacing.m_122428_()) {
                        secondaryQuads.addAll(this.getTemplateBakedModels().get(4 + openOffset).getQuads(state, side, rand, extraData));
                    } else {
                        secondaryQuads.addAll(this.getTemplateBakedModels().get(5 + openOffset).getQuads(state, side, rand, extraData));
                    }
                } else {
                    secondaryQuads.addAll(this.middleDesk(state, side, rand, extraData, left, right, openOffset));
                }
            } else if (block.canConnect(neighborStateOpposite) && neighborStateOpposite.m_61138_((Property)BlockStateProperties.f_61374_)) {
                neighborFacing = (Direction)neighborStateOpposite.m_61143_((Property)BlockStateProperties.f_61374_);
                if (neighborFacing.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() && isNeighborStateOppositeFacingDifferentDirection) {
                    if (neighborFacing == isFacing.m_122428_()) {
                        secondaryQuads.addAll(this.getTemplateBakedModels().get(6 + openOffset).getQuads(state, side, rand, extraData));
                    } else {
                        secondaryQuads.addAll(this.getTemplateBakedModels().get(7 + openOffset).getQuads(state, side, rand, extraData));
                    }
                } else {
                    secondaryQuads.addAll(this.middleDesk(state, side, rand, extraData, left, right, openOffset));
                }
            } else {
                secondaryQuads.addAll(this.middleDesk(state, side, rand, extraData, left, right, openOffset));
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            return this.getQuadsWithTexture(secondaryQuads, ModelHelper.getOakPlankLogSprites(), spriteList);
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> legsDesk(BlockState state, Direction side, Random rand, IModelData extraData, boolean north, boolean south, boolean west, boolean east, int northLeg, int southLeg, int westLeg, int eastLeg) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (!north && !east) {
            quads.addAll(this.getTemplateBakedModels().get(northLeg).getQuads(state, side, rand, extraData));
        }
        if (!north && !west) {
            quads.addAll(this.getTemplateBakedModels().get(southLeg).getQuads(state, side, rand, extraData));
        }
        if (!south && !west) {
            quads.addAll(this.getTemplateBakedModels().get(eastLeg).getQuads(state, side, rand, extraData));
        }
        if (!south && !east) {
            quads.addAll(this.getTemplateBakedModels().get(westLeg).getQuads(state, side, rand, extraData));
        }
        return quads;
    }

    private List<BakedQuad> middleDesk(BlockState state, Direction side, Random rand, IModelData extraData, boolean left, boolean right, int openOffset) {
        if (left && right) {
            return this.getTemplateBakedModels().get(3 + openOffset).getQuads(state, side, rand, extraData);
        }
        if (left) {
            return this.getTemplateBakedModels().get(1 + openOffset).getQuads(state, side, rand, extraData);
        }
        if (right) {
            return this.getTemplateBakedModels().get(2 + openOffset).getQuads(state, side, rand, extraData);
        }
        return this.getTemplateBakedModels().get(openOffset).getQuads(state, side, rand, extraData);
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, Random random) {
        ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).m_6840_(state, face, random));
        ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
        secondaryQuads.addAll(this.getTemplateBakedModels().get(18).m_6840_(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(16).m_6840_(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(17).m_6840_(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(19).m_6840_(state, face, random));
        List<TextureAtlasSprite> spriteList = this.getSpriteList(stack);
        List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMForgeBakedModel.SpriteData(spriteList.get(0)));
        quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMForgeBakedModel.SpriteData(spriteList.get(1))));
        return quads;
    }
}

