/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.bed.forge;

import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.blocks.models.bed.BedInterface;
import com.unlikepaladin.pfm.blocks.models.forge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.forge.PFMForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeBedModel
extends PFMForgeBakedModel
implements BedInterface {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();

    public ForgeBedModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    public void appendProperties(ModelDataMap.Builder builder) {
        super.appendProperties(builder);
        builder.withProperty(CONNECTIONS);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state != null && extraData.getData(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.getData(ForgeBedModel.CONNECTIONS)).connections != null) {
            int classicOffset;
            BedPart part = (BedPart)state.m_61143_((Property)BedBlock.f_49440_);
            BitSet data = ((ModelBitSetProperty)extraData.getData(ForgeBedModel.CONNECTIONS)).connections;
            boolean left = data.get(0);
            boolean right = data.get(1);
            boolean bunk = data.get(2);
            boolean isClassic = state.m_60734_().m_7705_().contains("classic");
            int n = classicOffset = isClassic ? 12 : 0;
            if (part == BedPart.HEAD) {
                quads.addAll(this.getTemplateBakedModels().get(classicOffset + 3).getQuads(state, side, rand, extraData));
                if (!right) {
                    quads.addAll(this.getTemplateBakedModels().get(classicOffset + 6).getQuads(state, side, rand, extraData));
                }
                if (!left) {
                    quads.addAll(this.getTemplateBakedModels().get(classicOffset + 7).getQuads(state, side, rand, extraData));
                }
                if (bunk && !isClassic) {
                    quads.addAll(this.getTemplateBakedModels().get(classicOffset + 10).getQuads(state, side, rand, extraData));
                }
            } else {
                quads.addAll(this.getTemplateBakedModels().get(classicOffset + 2).getQuads(state, side, rand, extraData));
                if (!right) {
                    quads.addAll(this.getTemplateBakedModels().get(classicOffset + 4).getQuads(state, side, rand, extraData));
                }
                if (!left) {
                    quads.addAll(this.getTemplateBakedModels().get(classicOffset + 5).getQuads(state, side, rand, extraData));
                }
                if (!right && bunk) {
                    quads.addAll(this.getTemplateBakedModels().get(classicOffset + 8).getQuads(state, side, rand, extraData));
                }
                if (!left && bunk) {
                    quads.addAll(this.getTemplateBakedModels().get(classicOffset + 9).getQuads(state, side, rand, extraData));
                }
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            return this.getQuadsWithTexture(quads, ModelHelper.getOakBedSprites(), spriteList);
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, Random random) {
        int classicOffset = stack.m_41778_().contains("classic") ? 12 : 0;
        List<TextureAtlasSprite> spriteList = this.getSpriteList(stack);
        return this.getQuadsWithTexture(this.getTemplateBakedModels().get(classicOffset + 11).m_6840_(state, face, random), ModelHelper.getOakBedSprites(), spriteList);
    }

    @Override
    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter blockView, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData tileData) {
        if (state.m_60734_() instanceof SimpleBedBlock) {
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            this.appendProperties(builder);
            ModelDataMap data = builder.build();
            super.getModelData(blockView, pos, state, (IModelData)data);
            Direction dir = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            boolean isClassic = state.m_60734_().m_7705_().contains("classic");
            boolean left = this.isBed(blockView, pos, dir.m_122428_(), dir, state, isClassic);
            boolean right = this.isBed(blockView, pos, dir.m_122427_(), dir, state, isClassic);
            boolean bunk = this.isBed(blockView, pos, Direction.DOWN, dir, state, isClassic);
            BitSet set = new BitSet();
            set.set(0, left);
            set.set(1, right);
            set.set(2, bunk);
            data.setData(CONNECTIONS, (Object)new ModelBitSetProperty(set));
            return data;
        }
        return tileData;
    }
}

