/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.forge;

import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.models.AbstractBakedModel;
import com.unlikepaladin.pfm.client.forge.PFMBakedModelGetQuadsExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PFMForgeBakedModel
extends AbstractBakedModel
implements PFMBakedModelGetQuadsExtension {
    Map<Pair<ItemStack, Direction>, List<BakedQuad>> cache = new HashMap<Pair<ItemStack, Direction>, List<BakedQuad>>();
    public static ModelProperty<BlockState> STATE = new ModelProperty();
    public static boolean forceReload;
    Map<Pair<ResourceLocation, SpriteData>, List<BakedQuad>> separatedQuads = new ConcurrentHashMap<Pair<ResourceLocation, SpriteData>, List<BakedQuad>>();
    Map<Pair<SpriteData, BakedQuad>, BakedQuad> quadToTransformedQuad = new ConcurrentHashMap<Pair<SpriteData, BakedQuad>, BakedQuad>();
    private static final Map<Pair<VertexFormatElement.Usage, Integer>, Integer> ELEMENT_INTEGER_MAP;

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, Random random) {
        return this.m_6840_(state, face, random);
    }

    @Override
    public List<BakedQuad> getQuadsCached(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, Random random) {
        Pair directionPair = new Pair((Object)stack, (Object)face);
        if (this.cache.containsKey(directionPair)) {
            return this.cache.get(directionPair);
        }
        List<BakedQuad> quads = this.getQuads(stack, state, face, random);
        this.cache.put((Pair<ItemStack, Direction>)directionPair, quads);
        return quads;
    }

    public PFMForgeBakedModel(ModelState settings, List<BakedModel> templateBakedModels) {
        super(settings, templateBakedModels);
    }

    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData tileData) {
        tileData.setData(STATE, (Object)state);
        return tileData;
    }

    public List<BakedQuad> getQuadsWithTexture(List<BakedQuad> quads, List<TextureAtlasSprite> toReplace, List<TextureAtlasSprite> replacements) {
        if (quads == null) {
            return Collections.emptyList();
        }
        if (replacements == null || toReplace == null) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Replacement list was null, skipping transformation");
            return quads;
        }
        if (toReplace.size() != replacements.size()) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Replacement list was not the same size, skipping transformation, expected {} sprites, got {}", (Object)toReplace.size(), (Object)replacements.size());
            PaladinFurnitureMod.GENERAL_LOGGER.debug(toReplace);
            PaladinFurnitureMod.GENERAL_LOGGER.debug(replacements);
            return quads;
        }
        if (toReplace.equals(replacements)) {
            return quads;
        }
        for (BakedQuad quad : quads) {
            SpriteData sprite = new SpriteData(quad.m_173410_());
            Pair pair = new Pair((Object)sprite.getId(), (Object)sprite);
            if (this.separatedQuads.containsKey(pair)) {
                this.separatedQuads.putIfAbsent((Pair<ResourceLocation, SpriteData>)pair, new ArrayList());
                if (this.separatedQuads.get(pair).contains(quad)) continue;
                ArrayList<BakedQuad> newQuadList = new ArrayList<BakedQuad>((Collection)this.separatedQuads.get(pair));
                newQuadList.add(quad);
                this.separatedQuads.put((Pair<ResourceLocation, SpriteData>)pair, newQuadList);
                continue;
            }
            if (!this.separatedQuads.isEmpty()) {
                AtomicReference<Object> del = new AtomicReference<Object>(null);
                this.separatedQuads.keySet().forEach(identifierSpriteDataPair -> {
                    if (identifierSpriteDataPair != null && sprite.getId().equals(identifierSpriteDataPair.getFirst())) {
                        del.set(identifierSpriteDataPair);
                    }
                });
                if (del.get() != null) {
                    this.separatedQuads.remove(del.get());
                }
            }
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            list.add(quad);
            this.separatedQuads.put((Pair<ResourceLocation, SpriteData>)pair, list);
        }
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>(quads.size());
        for (Map.Entry<Pair<ResourceLocation, SpriteData>, List<BakedQuad>> entry : this.separatedQuads.entrySet()) {
            ResourceLocation keyId = (ResourceLocation)entry.getKey().getFirst();
            int index = IntStream.range(0, toReplace.size()).filter(i -> keyId.equals((Object)((TextureAtlasSprite)toReplace.get(i)).m_118413_())).findFirst().orElse(-1);
            if (index != -1) {
                SpriteData replacement = new SpriteData(replacements.get(index));
                transformedQuads.addAll(this.getQuadsWithTexture(entry.getValue().stream().filter(quads::contains).toList(), replacement));
                continue;
            }
            transformedQuads.addAll(entry.getValue().stream().filter(quads::contains).toList());
        }
        return transformedQuads;
    }

    public List<BakedQuad> getQuadsWithTexture(List<BakedQuad> quads, SpriteData spriteData) {
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>(quads.size());
        int uvVertexIndx = PFMForgeBakedModel.findVertexElement(VertexFormatElement.Usage.UV, 0);
        quads.forEach(quad -> {
            Pair quadKey = new Pair((Object)spriteData, quad);
            if (quad.m_173410_().m_118413_() == spriteData.getId() && !this.quadToTransformedQuad.containsKey(quadKey)) {
                this.quadToTransformedQuad.put((Pair<SpriteData, BakedQuad>)quadKey, (BakedQuad)quad);
                transformedQuads.add((BakedQuad)quad);
            } else if (this.quadToTransformedQuad.containsKey(quadKey)) {
                transformedQuads.add(this.quadToTransformedQuad.get(quadKey));
            } else {
                TextureAtlasSprite sprite = spriteData.getSprite();
                int[] vertexData = new int[quad.m_111303_().length];
                System.arraycopy(quad.m_111303_(), 0, vertexData, 0, vertexData.length);
                float[][] uv = new float[4][2];
                for (int vertexIndx = 0; vertexIndx < 4; ++vertexIndx) {
                    LightUtil.unpack((int[])vertexData, (float[])uv[vertexIndx], (VertexFormat)DefaultVertexFormat.f_85811_, (int)vertexIndx, (int)uvVertexIndx);
                    TextureAtlasSprite originalSprite = quad.m_173410_();
                    float frameU = originalSprite.m_174727_(uv[vertexIndx][0]);
                    float frameV = originalSprite.m_174741_(uv[vertexIndx][1]);
                    uv[vertexIndx][0] = sprite.m_118367_((double)frameU);
                    uv[vertexIndx][1] = sprite.m_118393_((double)frameV);
                    LightUtil.pack((float[])uv[vertexIndx], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)vertexIndx, (int)uvVertexIndx);
                }
                BakedQuad transformedQuad = new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
                this.quadToTransformedQuad.put((Pair<SpriteData, BakedQuad>)quadKey, transformedQuad);
                transformedQuads.add(transformedQuad);
            }
        });
        return transformedQuads;
    }

    public static int findVertexElement(VertexFormatElement.Usage type, int index) {
        VertexFormatElement element1;
        Pair pairToFind = new Pair((Object)type, (Object)index);
        if (ELEMENT_INTEGER_MAP.containsKey(pairToFind)) {
            return ELEMENT_INTEGER_MAP.get(pairToFind);
        }
        int id = 0;
        UnmodifiableIterator unmodifiableIterator = DefaultVertexFormat.f_85811_.m_86023_().iterator();
        while (unmodifiableIterator.hasNext() && ((element1 = (VertexFormatElement)unmodifiableIterator.next()).m_86048_() != type || element1.m_86049_() != index)) {
            ++id;
        }
        ELEMENT_INTEGER_MAP.put((Pair<VertexFormatElement.Usage, Integer>)pairToFind, id);
        return id;
    }

    public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
        if (data.hasProperty(STATE) && data.getData(STATE) != null) {
            return this.getSpriteList((BlockState)data.getData(STATE)).get(0);
        }
        return super.getParticleIcon(data);
    }

    public TextureAtlasSprite m_6160_() {
        return this.getTemplateBakedModels().get(0).m_6160_();
    }

    public void appendProperties(ModelDataMap.Builder builder) {
        builder.withProperty(STATE);
    }

    public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
        BlockState state = itemStack.m_41720_() instanceof BlockItem ? ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_() : null;
        HashMap<Direction, List<BakedQuad>> map = new HashMap<Direction, List<BakedQuad>>();
        Random random = new Random(1L);
        for (Direction direction : Direction.values()) {
            map.put(direction, this.getQuadsCached(itemStack, state, direction, random));
        }
        map.put(null, this.getQuadsCached(itemStack, state, null, random));
        PFMCachingBakedModel cachingBakedModel = new PFMCachingBakedModel(map, this.m_6160_());
        return List.of(Pair.of((Object)cachingBakedModel, (Object)ItemBlockRenderTypes.m_109279_((ItemStack)itemStack, (boolean)fabulous)));
    }

    public boolean isLayered() {
        return true;
    }

    static {
        ELEMENT_INTEGER_MAP = new ConcurrentHashMap<Pair<VertexFormatElement.Usage, Integer>, Integer>();
    }

    public static class SpriteData {
        float minU;
        float maxU;
        float minV;
        float maxV;
        int x;
        int y;
        ResourceLocation id;
        TextureAtlasSprite sprite;

        public SpriteData(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            this.minU = sprite.m_118409_();
            this.maxU = sprite.m_118410_();
            this.minV = sprite.m_118411_();
            this.maxV = sprite.m_118412_();
            this.x = sprite.m_174743_();
            this.y = sprite.m_174744_();
            this.id = sprite.m_118413_();
        }

        public boolean equals(Object obj) {
            return obj instanceof SpriteData && ((SpriteData)obj).id == this.id && ((SpriteData)obj).minV == this.minV && ((SpriteData)obj).maxV == this.maxV && ((SpriteData)obj).minU == this.minU && ((SpriteData)obj).maxU == this.maxU && ((SpriteData)obj).x == this.x && ((SpriteData)obj).y == this.y;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.minU), Float.valueOf(this.maxU), Float.valueOf(this.minV), Float.valueOf(this.maxV), this.x, this.y, this.id);
        }
    }

    public static final class PFMCachingBakedModel
    implements BakedModel {
        private final Map<Direction, List<BakedQuad>> transformedQuads;
        private final TextureAtlasSprite particleSprite;

        public PFMCachingBakedModel(Map<Direction, List<BakedQuad>> transformedQuads, TextureAtlasSprite particleSprite) {
            this.transformedQuads = transformedQuads;
            this.particleSprite = particleSprite;
        }

        public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction face, Random random) {
            return this.transformedQuads.get(face);
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particleSprite;
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PFMCachingBakedModel that = (PFMCachingBakedModel)obj;
            return Objects.equals(this.transformedQuads, that.transformedQuads) && Objects.equals(this.particleSprite, that.particleSprite);
        }

        public int hashCode() {
            return Objects.hash(this.transformedQuads, this.particleSprite);
        }

        public String toString() {
            return "PFMCachingBakedModel[transformedQuads=" + String.valueOf(this.transformedQuads) + ", particleSprite=" + String.valueOf(this.particleSprite) + "]";
        }
    }
}

