/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.mirror;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.blocks.models.mirror.forge.UnbakedMirrorModelImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class UnbakedMirrorModel
implements UnbakedModel {
    public static final String[] BASE_MODEL_PARTS = new String[]{"block/mirror/mirror_base", "block/mirror/mirror_top", "block/mirror/mirror_bottom", "block/mirror/mirror_left", "block/mirror/mirror_right", "block/mirror/mirror_right_top", "block/mirror/mirror_left_top", "block/mirror/mirror_right_bottom", "block/mirror/mirror_left_bottom"};
    public static final ResourceLocation[] DEFAULT_TEXTURES = new ResourceLocation[]{new ResourceLocation("minecraft", "block/white_concrete"), new ResourceLocation("minecraft", "block/glass"), new ResourceLocation("pfm", "block/mirror")};
    private static final ResourceLocation PARENT = new ResourceLocation("block/block");
    public static final ResourceLocation[] MIRROR_MODEL_IDS = new ResourceLocation[]{new ResourceLocation("pfm", "block/white_mirror"), new ResourceLocation("pfm", "block/gray_mirror")};
    private final List<String> MODEL_PARTS;
    protected final Material reflectTex;
    protected final Material glassTex;
    protected final Material frameTex;
    public static final List<ResourceLocation> ALL_MODEL_IDS = new ArrayList<ResourceLocation>(){
        {
            for (String part : BASE_MODEL_PARTS) {
                this.add(new ResourceLocation("pfm", part));
            }
            for (String part : BASE_MODEL_PARTS) {
                part = part.replace("mirror", "gray_mirror");
                this.add(new ResourceLocation("pfm", part));
            }
        }
    };

    public UnbakedMirrorModel(ResourceLocation reflect, ResourceLocation defaultFrameTexture, ResourceLocation glass, List<String> modelParts, DyeColor color) {
        this.reflectTex = new Material(TextureAtlas.f_118259_, reflect);
        this.frameTex = new Material(TextureAtlas.f_118259_, defaultFrameTexture);
        this.glassTex = new Material(TextureAtlas.f_118259_, glass);
        String[] stringArray = BASE_MODEL_PARTS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String modelPartName;
            String s = modelPartName = stringArray[i];
            if (color != DyeColor.WHITE) {
                s = s.replace("mirror", color.m_41065_() + "_mirror");
            }
            modelParts.add(s);
        }
        this.MODEL_PARTS = modelParts;
    }

    public Collection<ResourceLocation> m_7970_() {
        return List.of(PARENT);
    }

    public Collection<Material> m_5500_(Function<ResourceLocation, UnbakedModel> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        ArrayList<Material> list = new ArrayList<Material>(2);
        list.add(this.glassTex);
        list.add(this.frameTex);
        list.add(this.reflectTex);
        return list;
    }

    @Nullable
    public BakedModel m_7611_(ModelBakery loader, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotationContainer, ResourceLocation modelId) {
        LinkedHashMap<String, BakedModel> bakedModels = new LinkedHashMap<String, BakedModel>();
        for (String modelPartName : this.MODEL_PARTS) {
            bakedModels.put(modelPartName, loader.m_119349_(new ResourceLocation("pfm", modelPartName), rotationContainer));
        }
        return UnbakedMirrorModel.getBakedModel(textureGetter.apply(this.frameTex), textureGetter.apply(this.glassTex), textureGetter.apply(this.reflectTex), rotationContainer, bakedModels, this.MODEL_PARTS);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BakedModel getBakedModel(TextureAtlasSprite frame, TextureAtlasSprite glassTex, TextureAtlasSprite reflectTex, ModelState settings, Map<String, BakedModel> bakedModels, List<String> MODEL_PARTS) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return UnbakedMirrorModelImpl.getBakedModel(frame, (TextureAtlasSprite)var1_1, (TextureAtlasSprite)var2_2, (ModelState)var3_3, (Map<String, BakedModel>)var4_4, (List<String>)var5_5);
    }
}

