/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.mirror.forge;

import com.unlikepaladin.pfm.blocks.MirrorBlock;
import com.unlikepaladin.pfm.blocks.models.forge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.forge.PFMForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeMirrorModel
extends PFMForgeBakedModel {
    protected final TextureAtlasSprite glassTex;
    protected final TextureAtlasSprite reflectTex;
    private final List<String> modelParts;
    public static ModelProperty<ModelBitSetProperty> DIRECTIONS = new ModelProperty();

    public ForgeMirrorModel(TextureAtlasSprite frame, TextureAtlasSprite glassTex, TextureAtlasSprite reflectTex, ModelState settings, Map<String, BakedModel> bakedModels, List<String> MODEL_PARTS) {
        super(settings, bakedModels.values().stream().toList());
        this.modelParts = MODEL_PARTS;
        this.glassTex = glassTex;
        this.reflectTex = reflectTex;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData));
        if (state != null && state.m_60734_() instanceof MirrorBlock && extraData.getData(DIRECTIONS) != null && ((ModelBitSetProperty)extraData.getData(ForgeMirrorModel.DIRECTIONS)).connections != null) {
            BitSet connections = ((ModelBitSetProperty)extraData.getData(ForgeMirrorModel.DIRECTIONS)).connections;
            if (!connections.get(0)) {
                quads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData));
            }
            if (!connections.get(1)) {
                quads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData));
            }
            if (!connections.get(2)) {
                quads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData));
            }
            if (!connections.get(3)) {
                quads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData));
            }
            if (!connections.get(4)) {
                quads.addAll(this.getTemplateBakedModels().get(6).getQuads(state, side, rand, extraData));
            }
            if (!connections.get(5)) {
                quads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, side, rand, extraData));
            }
            if (!connections.get(6)) {
                quads.addAll(this.getTemplateBakedModels().get(5).getQuads(state, side, rand, extraData));
            }
            if (!connections.get(7)) {
                quads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, side, rand, extraData));
            }
        }
        return quads;
    }

    @Override
    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter blockView, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData tileData) {
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        if (state.m_60734_() instanceof MirrorBlock) {
            MirrorBlock block = (MirrorBlock)state.m_60734_();
            Direction facing = (Direction)state.m_61143_((Property)MirrorBlock.f_54117_);
            BitSet connections = new BitSet(8);
            connections.set(0, block.canConnect(blockView.m_8055_(pos.m_7494_()), state));
            connections.set(1, block.canConnect(blockView.m_8055_(pos.m_7495_()), state));
            connections.set(2, block.canConnect(blockView.m_8055_(pos.m_142300_(facing.m_122427_())), state));
            connections.set(3, block.canConnect(blockView.m_8055_(pos.m_142300_(facing.m_122428_())), state));
            connections.set(4, block.canConnect(blockView.m_8055_(pos.m_142300_(facing.m_122427_()).m_7494_()), state));
            connections.set(5, block.canConnect(blockView.m_8055_(pos.m_142300_(facing.m_122427_()).m_7495_()), state));
            connections.set(6, block.canConnect(blockView.m_8055_(pos.m_142300_(facing.m_122428_()).m_7494_()), state));
            connections.set(7, block.canConnect(blockView.m_8055_(pos.m_142300_(facing.m_122428_()).m_7495_()), state));
            ModelBitSetProperty mirrorDirections = new ModelBitSetProperty(connections);
            builder.withInitial(DIRECTIONS, (Object)mirrorDirections);
        }
        return builder.build();
    }
}

