/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.modernDinnerTable.forge;

import com.unlikepaladin.pfm.blocks.ModernDinnerTableBlock;
import com.unlikepaladin.pfm.blocks.models.forge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.forge.PFMForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeModernDinnerTableModel
extends PFMForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();

    public ForgeModernDinnerTableModel(ModelState settings, List<BakedModel> modelList) {
        super(settings, modelList);
    }

    @Override
    public void appendProperties(ModelDataMap.Builder builder) {
        super.appendProperties(builder);
        builder.withProperty(CONNECTIONS);
    }

    @Override
    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData tileData) {
        if (state.m_60734_() instanceof ModernDinnerTableBlock) {
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            this.appendProperties(builder);
            ModelDataMap data = builder.build();
            super.getModelData(world, pos, state, (IModelData)data);
            ModernDinnerTableBlock block = (ModernDinnerTableBlock)state.m_60734_();
            Direction.Axis dir = (Direction.Axis)state.m_61143_(ModernDinnerTableBlock.AXIS);
            boolean left = block.isTable((BlockGetter)world, pos, dir, -1);
            boolean right = block.isTable((BlockGetter)world, pos, dir, 1);
            BitSet set = new BitSet();
            set.set(0, left);
            set.set(1, right);
            data.setData(CONNECTIONS, (Object)new ModelBitSetProperty(set));
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        if (state != null && state.m_60734_() instanceof ModernDinnerTableBlock && extraData.getData(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.getData(ForgeModernDinnerTableModel.CONNECTIONS)).connections != null) {
            ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>();
            ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
            BitSet set = ((ModelBitSetProperty)extraData.getData(ForgeModernDinnerTableModel.CONNECTIONS)).connections;
            boolean left = set.get(0);
            boolean right = set.get(1);
            baseQuads.addAll(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData));
            if (left && right) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData));
            }
            if (!left && right) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData));
            }
            if (!right && left) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData));
            }
            if (!right && !left) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData));
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMForgeBakedModel.SpriteData(spriteList.get(0)));
            quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMForgeBakedModel.SpriteData(spriteList.get(1))));
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, Random random) {
        ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).m_6840_(state, face, random));
        ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(3).m_6840_(state, face, random));
        List<TextureAtlasSprite> spriteList = this.getSpriteList(stack);
        List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMForgeBakedModel.SpriteData(spriteList.get(0)));
        quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMForgeBakedModel.SpriteData(spriteList.get(1))));
        return quads;
    }
}

