/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.cookingforblockheads.forge;

import com.unlikepaladin.pfm.blocks.ClassicNightstandBlock;
import com.unlikepaladin.pfm.blocks.KitchenCabinetBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.blocks.forge.StoveBlockImpl;
import com.unlikepaladin.pfm.compat.cookingforblockheads.forge.PFMCookingTableBlock;
import com.unlikepaladin.pfm.compat.cookingforblockheads.forge.StoveBlockEntityBalm;
import com.unlikepaladin.pfm.compat.cookingforblockheads.forge.menu.StoveScreenHandlerBalm;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.TriFunc;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class PFMCookingForBlockHeadsCompat {
    public static final PFMCookingTableBlock COOKING_TABLE_BLOCK = new PFMCookingTableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)PaladinFurnitureModBlocksItems.GRAY_STOVE));

    public static void initBlockConnectors() {
        ArrayList connectorBlocks = new ArrayList(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(KitchenDrawerBlock.class).getAllBlocks());
        connectorBlocks.addAll(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getAllBlocks());
        connectorBlocks.addAll(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(KitchenCabinetBlock.class).getAllBlocks());
        connectorBlocks.addAll(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(ClassicNightstandBlock.class).getAllBlocks());
        connectorBlocks.addAll(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getAllBlocks());
        connectorBlocks.addAll(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getAllBlocks());
        connectorBlocks.addAll(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(KitchenSinkBlock.class).getAllBlocks());
        connectorBlocks.addAll(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(KitchenWallCounterBlock.class).getAllBlocks());
        connectorBlocks.addAll(PaladinFurnitureModBlocksItems.furnitureEntryMap.get(KitchenCounterBlock.class).getAllBlocks());
        connectorBlocks.addAll(List.of(PaladinFurnitureModBlocksItems.WHITE_FRIDGE, PaladinFurnitureModBlocksItems.XBOX_FRIDGE, PaladinFurnitureModBlocksItems.GRAY_FRIDGE, PaladinFurnitureModBlocksItems.IRON_FRIDGE));
        connectorBlocks.addAll(List.of(PaladinFurnitureModBlocksItems.WHITE_STOVE, PaladinFurnitureModBlocksItems.GRAY_STOVE, PaladinFurnitureModBlocksItems.IRON_STOVE));
        connectorBlocks.addAll(List.of(PaladinFurnitureModBlocksItems.GRAY_FREEZER, PaladinFurnitureModBlocksItems.IRON_FREEZER, PaladinFurnitureModBlocksItems.WHITE_FREEZER));
        connectorBlocks.forEach(KitchenMultiBlock::registerConnectorBlock);
    }

    public static <T extends AbstractContainerMenu> TriFunc<Integer, Inventory, FriendlyByteBuf, T> getStoveScreenHandler() {
        return (integer, playerInventory, packetByteBuf) -> {
            BlockPos pos = packetByteBuf.m_130135_();
            BlockEntity blockEntity = playerInventory.f_35978_.f_19853_.m_7702_(pos);
            return new StoveScreenHandlerBalm((int)integer, (Inventory)playerInventory, (StoveBlockEntityBalm)blockEntity);
        };
    }

    public static void openMenuScreen(Level world, BlockPos pos, Player player) {
        StoveBlockEntityBalm stove = (StoveBlockEntityBalm)world.m_7702_(pos);
        if (!world.f_46443_) {
            Balm.getNetworking().openGui(player, (MenuProvider)stove);
        }
    }

    public static BlockEntity getStoveBlockEntity(BlockPos pos, BlockState state) {
        return new StoveBlockEntityBalm(pos, state);
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getStoveTicker(Level world, BlockEntityType<T> type) {
        if (world.f_46443_) {
            return StoveBlockImpl.checkType(type, BlockEntities.STOVE_BLOCK_ENTITY, StoveBlockEntityBalm::clientTick);
        }
        return StoveBlockImpl.checkType(type, BlockEntities.STOVE_BLOCK_ENTITY, StoveBlockEntityBalm::serverTick);
    }

    public static InteractionResult onUseStove(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == ModItems.heatingUnit) {
            return InteractionResult.PASS;
        }
        if (hit.m_82434_() == Direction.UP && CookingRegistry.isToolItem((ItemStack)heldItem)) {
            StoveBlockEntityBalm tileOven;
            Direction stateFacing = (Direction)state.m_61143_((Property)StoveBlock.f_48683_);
            double hx = hit.m_82450_().f_82479_ - (double)hit.m_82425_().m_123341_();
            double hz = hit.m_82450_().f_82481_ - (double)hit.m_82425_().m_123343_();
            switch (stateFacing) {
                case NORTH: {
                    hx = 1.0 - (hit.m_82450_().f_82479_ - (double)hit.m_82425_().m_123341_());
                    hz = 1.0 - (hit.m_82450_().f_82481_ - (double)hit.m_82425_().m_123343_());
                    break;
                }
                case WEST: {
                    hz = 1.0 - (hit.m_82450_().f_82479_ - (double)hit.m_82425_().m_123341_());
                    hx = hit.m_82450_().f_82481_ - (double)hit.m_82425_().m_123343_();
                    break;
                }
                case EAST: {
                    hz = hit.m_82450_().f_82479_ - (double)hit.m_82425_().m_123341_();
                    hx = 1.0 - (hit.m_82450_().f_82481_ - (double)hit.m_82425_().m_123343_());
                }
            }
            int index = -1;
            if (hx < 0.5 && hz < 0.5) {
                index = 1;
            } else if (hx >= 0.5 && hz < 0.5) {
                index = 0;
            } else if (hx < 0.5 && hz >= 0.5) {
                index = 3;
            } else if (hx >= 0.5 && hz >= 0.5) {
                index = 2;
            }
            if (index != -1 && (tileOven = (StoveBlockEntityBalm)level.m_7702_(pos)) != null && tileOven.getToolItem(index).m_41619_()) {
                ItemStack toolItem = heldItem.m_41620_(1);
                tileOven.setToolItem(index, toolItem);
            }
            return InteractionResult.SUCCESS;
        }
        StoveBlockEntityBalm oven = (StoveBlockEntityBalm)level.m_7702_(pos);
        if (hit.m_82434_() == state.m_61143_((Property)BlockStateProperties.f_61374_) && oven != null) {
            if (player.m_6144_()) {
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_() && oven.getSmeltingResult(heldItem) != ItemStack.f_41583_) {
                heldItem = ContainerUtils.insertItemStacked((Container)oven.getInputContainer(), (ItemStack)heldItem, (boolean)false);
                player.m_21008_(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_() && StoveBlockEntityBalm.isItemFuel(heldItem)) {
                heldItem = ContainerUtils.insertItemStacked((Container)oven.getFuelContainer(), (ItemStack)heldItem, (boolean)false);
                player.m_21008_(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        if (!level.f_46443_) {
            Balm.getNetworking().openGui(player, (MenuProvider)oven);
        }
        return InteractionResult.SUCCESS;
    }
}

