/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.unlikepaladin.pfm.recipes.FreezingRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FreezingCategory
implements IRecipeCategory<FreezingRecipe> {
    public static final TranslatableComponent TITLE = new TranslatableComponent("rei.pfm.freezer");
    public final IDrawable ICON;
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("pfm", "freezing");
    private final IDrawable BACKGROUND;
    public static final ResourceLocation FREEZE_GUI = new ResourceLocation("pfm", "textures/gui/container/freezer.png");
    protected final IDrawableStatic staticFreezeIcon;
    protected final IDrawableAnimated animatedFreezeIcon;
    private final int regularFreezeTime;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    protected static final int inputSlot = 0;
    protected static final int fuelSlot = 1;
    protected static final int outputSlot = 2;

    public FreezingCategory(final IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.WHITE_FREEZER));
        this.BACKGROUND = guiHelper.createDrawable(FREEZE_GUI, 55, 16, 82, 54);
        this.staticFreezeIcon = guiHelper.createDrawable(FREEZE_GUI, 176, 0, 12, 12);
        this.animatedFreezeIcon = guiHelper.createAnimatedDrawable(this.staticFreezeIcon, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.regularFreezeTime = 100;
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer freezeTime) {
                return guiHelper.drawableBuilder(FREEZE_GUI, 176, 14, 24, 17).buildAnimated(freezeTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return IDENTIFIER;
    }

    public Class getRecipeClass() {
        return FreezingRecipe.class;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setIngredients(FreezingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, FreezingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }

    protected IDrawableAnimated getArrow(FreezingRecipe recipe) {
        int freezeTime = recipe.m_43753_();
        if (freezeTime <= 0) {
            freezeTime = this.regularFreezeTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)freezeTime);
    }

    protected void drawFreezeTime(FreezingRecipe recipe, PoseStack poseStack, int y) {
        int freezeTime = recipe.m_43753_();
        if (freezeTime > 0) {
            int freezeTimeSeconds = freezeTime / 20;
            Component timeString = Component.m_130674_((String)(freezeTimeSeconds + "s"));
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            fontRenderer.m_92889_(poseStack, timeString, (float)(this.BACKGROUND.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected void drawExperience(FreezingRecipe recipe, PoseStack poseStack, int y) {
        float experience = recipe.m_43750_();
        if (experience > 0.0f) {
            Component experienceString = Component.m_130674_((String)(experience + " XP"));
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)experienceString);
            fontRenderer.m_92889_(poseStack, experienceString, (float)(this.BACKGROUND.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    public void draw(FreezingRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        this.animatedFreezeIcon.draw(poseStack, 1, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(poseStack, 24, 18);
        this.drawExperience(recipe, poseStack, 0);
        this.drawFreezeTime(recipe, poseStack, 45);
    }
}

