/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.jei;

import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class FurnitureCategory
implements IRecipeCategory<FurnitureRecipe> {
    private final IDrawable BACKGROUND;
    public static final ResourceLocation TEXTURE_GUI_VANILLA = new ResourceLocation("pfm:textures/gui/gui_jei.png");
    public final IDrawable ICON;
    public static final TranslatableComponent TITLE = new TranslatableComponent("rei.pfm.furniture");
    private final ICraftingGridHelper craftingGridHelper;
    private static final int craftOutputSlot = 9;
    private static final int craftInputSlot1 = 0;
    private int itemsPerInnerRecipe;
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("pfm", "furniture");
    Map<FurnitureRecipe, List<ItemStack>> inputCache = new HashMap<FurnitureRecipe, List<ItemStack>>();
    Map<ItemStack, List<List<ItemStack>>> itemStackListMap = new HashMap<ItemStack, List<List<ItemStack>>>();
    private final Map<FurnitureRecipe, List<ItemStack>> outputs = new HashMap<FurnitureRecipe, List<ItemStack>>();
    Map<ItemStack, ItemStack> focusToOutput = new HashMap<ItemStack, ItemStack>();
    Map<FurnitureRecipe, List<List<ItemStack>>> cachedInput = new HashMap<FurnitureRecipe, List<List<ItemStack>>>();
    Map<FurnitureRecipe, List<ItemStack>> cachedOutput = new HashMap<FurnitureRecipe, List<ItemStack>>();

    public FurnitureCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.WORKING_TABLE));
        this.BACKGROUND = guiHelper.createDrawable(TEXTURE_GUI_VANILLA, 0, 60, 116, 54);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(0);
    }

    @NotNull
    public ResourceLocation getUid() {
        return IDENTIFIER;
    }

    @NotNull
    public Class<FurnitureRecipe> getRecipeClass() {
        return FurnitureRecipe.class;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setIngredients(FurnitureRecipe recipe, IIngredients iingredients) {
        this.itemsPerInnerRecipe = recipe.getMaxInnerRecipeSize();
        if (!this.inputCache.containsKey(recipe)) {
            ArrayList inputEntries = new ArrayList();
            for (FurnitureRecipe.CraftableFurnitureRecipe innerRecipe : recipe.getInnerRecipes()) {
                List<List<ItemStack>> finalList = this.collectIngredientsFromRecipe(innerRecipe);
                finalList.forEach(inputEntries::addAll);
            }
            this.inputCache.put(recipe, inputEntries);
        }
        iingredients.setInputs(VanillaTypes.ITEM, this.inputCache.get(recipe));
        iingredients.setOutputs(VanillaTypes.ITEM, this.getOutputEntries(recipe));
    }

    public List<List<ItemStack>> collectIngredientsFromRecipe(FurnitureRecipe.CraftableFurnitureRecipe recipe) {
        if (this.itemStackListMap.containsKey(recipe.m_8043_())) {
            return this.itemStackListMap.get(recipe.m_8043_());
        }
        List<Ingredient> ingredients = recipe.getIngredients();
        HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack stack : ingredient.m_43908_()) {
                if (!containedItems.containsKey(stack.m_41720_())) {
                    containedItems.put(stack.m_41720_(), stack.m_41613_());
                    continue;
                }
                containedItems.put(stack.m_41720_(), (Integer)containedItems.get(stack.m_41720_()) + stack.m_41613_());
            }
        }
        ArrayList<List<ItemStack>> listOfList = new ArrayList<List<ItemStack>>();
        for (Map.Entry entry : containedItems.entrySet()) {
            listOfList.add(List.of(new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())));
        }
        if (listOfList.size() != this.itemsPerInnerRecipe) {
            while (listOfList.size() != this.itemsPerInnerRecipe) {
                listOfList.add(List.of());
            }
        }
        this.itemStackListMap.put(recipe.m_8043_(), listOfList);
        return listOfList;
    }

    public List<ItemStack> getOutputEntries(FurnitureRecipe recipe) {
        if (!this.outputs.containsKey(recipe)) {
            this.outputs.put(recipe, recipe.getInnerRecipes().stream().map(FurnitureRecipe.CraftableFurnitureRecipe::m_8043_).toList());
        }
        return this.outputs.get(recipe);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @NotNull FurnitureRecipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(9, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 0 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        IFocus focused = recipeLayout.getFocus(VanillaTypes.ITEM);
        if (focused != null && focused.getMode() == IFocus.Mode.OUTPUT) {
            if (!this.focusToOutput.containsKey(focused.getValue())) {
                boolean broke = false;
                for (List listOfOutputs : ingredients.getOutputs(VanillaTypes.ITEM)) {
                    for (ItemStack stack : listOfOutputs) {
                        if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)focused.getValue()))) continue;
                        this.focusToOutput.put((ItemStack)focused.getValue(), stack);
                        broke = true;
                        break;
                    }
                    if (!broke) continue;
                    break;
                }
            }
            List<ItemStack> output = List.of(this.focusToOutput.get(focused.getValue()));
            List<List<ItemStack>> inputs = this.collectIngredientsFromRecipe(recipe.getInnerRecipeFromOutput(this.focusToOutput.get(focused.getValue())));
            guiItemStacks.set(9, output);
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        } else {
            if (!this.cachedOutput.containsKey(recipe)) {
                List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
                ArrayList finalOutput = new ArrayList();
                for (List list : outputs) {
                    finalOutput.addAll(list);
                }
                this.cachedOutput.put(recipe, finalOutput);
            }
            guiItemStacks.set(9, this.cachedOutput.get(recipe));
            if (!this.cachedInput.containsKey(recipe)) {
                ArrayList finalInput = new ArrayList(this.itemsPerInnerRecipe);
                for (int i = 0; i < this.itemsPerInnerRecipe; ++i) {
                    finalInput.add(new ArrayList());
                }
                for (FurnitureRecipe.CraftableFurnitureRecipe inner : recipe.getInnerRecipes()) {
                    List<List<ItemStack>> stsk = this.collectIngredientsFromRecipe(inner);
                    for (int i = 0; i < stsk.size(); ++i) {
                        ((List)finalInput.get(i % this.itemsPerInnerRecipe)).addAll((Collection)stsk.get(i));
                    }
                }
                this.cachedInput.put(recipe, finalInput);
            }
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, this.cachedInput.get(recipe));
        }
        recipeLayout.setShapeless();
    }
}

