/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.patchouli;

import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class FurnitureRecipeProcessor
implements IComponentProcessor {
    private FurnitureRecipe recipe;
    private ResourceLocation variant;
    private boolean isBase;

    public void setup(IVariableProvider variables) {
        String recipeId = variables.get("recipe").asString();
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        Recipe recipe = manager.m_44043_(new ResourceLocation(recipeId)).orElse(null);
        this.recipe = recipe instanceof FurnitureRecipe ? (FurnitureRecipe)recipe : null;
        this.variant = variables.has("variant") ? ResourceLocation.m_135820_((String)variables.get("variant").asString()) : null;
    }

    public IVariable process(@NotNull String key) {
        if (this.recipe != null) {
            List<FurnitureRecipe.CraftableFurnitureRecipe> innerRecipeList = this.variant != null ? this.recipe.getInnerRecipesForVariant(this.variant) : this.recipe.getInnerRecipes();
            if (key.startsWith("item")) {
                int index = Integer.parseInt(key.substring(4)) - 1;
                ItemStack[] ingredientsArr = new ItemStack[innerRecipeList.size()];
                for (int i = 0; i < innerRecipeList.size(); ++i) {
                    Ingredient ingredient;
                    ItemStack[] stacks;
                    FurnitureRecipe.CraftableFurnitureRecipe innerRecipe = innerRecipeList.get(i);
                    ingredientsArr[i] = index >= innerRecipe.getIngredients().size() ? ItemStack.f_41583_ : ((stacks = (ingredient = innerRecipe.getIngredients().get(index)).m_43908_()).length == 0 ? ItemStack.f_41583_ : stacks[0]);
                }
                return IVariable.from((Object)ingredientsArr);
            }
            if (key.equals("resultitem")) {
                ItemStack[] resultsArr = new ItemStack[innerRecipeList.size()];
                for (int i = 0; i < innerRecipeList.size(); ++i) {
                    FurnitureRecipe.CraftableFurnitureRecipe innerRecipe = innerRecipeList.get(i);
                    resultsArr[i] = innerRecipe.m_8043_();
                }
                return IVariable.from((Object)resultsArr);
            }
            if (key.equals("icon")) {
                ItemStack icon = this.recipe.m_8042_();
                return IVariable.from((Object)icon);
            }
            if (key.equals("text")) {
                return IVariable.wrap((String)(this.recipe.getOutputCount() + "x$(br)" + this.recipe.getName()));
            }
            if (key.equals("icount")) {
                return IVariable.wrap((Number)this.recipe.getOutputCount());
            }
            if (key.equals("iname")) {
                return IVariable.wrap((String)this.recipe.getName());
            }
        }
        return null;
    }

    public void refresh(Screen parent, int left, int top) {
        super.refresh(parent, left, top);
    }
}

