/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.config.option;

import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.config.option.ConfigOptionType;
import com.unlikepaladin.pfm.config.option.ConfigSizeTracker;
import com.unlikepaladin.pfm.config.option.Side;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class BooleanConfigOption
extends AbstractConfigOption<Boolean> {
    public static final ConfigOptionType<BooleanConfigOption> TYPE = new ConfigOptionType<BooleanConfigOption>(){

        @Override
        public BooleanConfigOption read(DataInput dataInput, int i, ConfigSizeTracker nbtTagSizeTracker) throws IOException {
            nbtTagSizeTracker.add(2400L);
            String title = dataInput.readUTF();
            String tooltip = dataInput.readUTF();
            String category = dataInput.readUTF();
            boolean value = dataInput.readBoolean();
            Side side = AbstractConfigOption.getSide(dataInput.readUTF());
            nbtTagSizeTracker.add(224L + 16L * (long)title.length());
            nbtTagSizeTracker.add(224L + 16L * (long)tooltip.length());
            nbtTagSizeTracker.add(224L + 16L * (long)category.length());
            nbtTagSizeTracker.add(64L);
            BooleanConfigOption booleanConfigOption = new BooleanConfigOption((Component)new TranslatableComponent(title), (Component)new TranslatableComponent(tooltip), category, value, side);
            return booleanConfigOption;
        }

        @Override
        public String getCrashReportName() {
            return "END";
        }

        @Override
        public boolean isImmutable() {
            return true;
        }
    };
    private final Component title;
    private final Component tooltip;
    private final String category;
    private boolean value;
    private final boolean defaultValue;
    private final Side side;

    public BooleanConfigOption(Component title, Component tooltip, String category, boolean value, Side side) {
        this.title = title;
        this.category = category;
        this.tooltip = tooltip;
        this.value = value;
        this.defaultValue = value;
        this.side = side;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Component getToolTip() {
        return this.tooltip;
    }

    @Override
    public void setValue(Boolean value) {
        this.value = value;
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public boolean isDefault() {
        return this.value == this.defaultValue;
    }

    @Override
    public Side getSide() {
        return this.side;
    }

    @Override
    public byte getConfigType() {
        return 1;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeUTF(((TranslatableComponent)this.title).m_131328_());
        output.writeUTF(((TranslatableComponent)this.tooltip).m_131328_());
        output.writeUTF(this.category);
        output.writeBoolean(this.value);
        output.writeUTF(this.side.m_7912_());
    }
}

