/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantRegistryBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class StoneVariantRegistry
extends VariantRegistryBase<StoneVariant> {
    public static final StoneVariant STONE = new StoneVariant(new ResourceLocation("stone"), Blocks.f_50069_, Blocks.f_50652_);
    public static final StoneVariantRegistry INSTANCE = new StoneVariantRegistry();

    public static Collection<String> getNamespaces() {
        return StoneVariantRegistry.INSTANCE.variants.values().stream().map(VariantBase::getNamespace).collect(Collectors.toUnmodifiableList());
    }

    public static Collection<StoneVariant> getVariants() {
        return Collections.unmodifiableCollection(StoneVariantRegistry.INSTANCE.variants.values());
    }

    @Nullable
    public static StoneVariant getVariant(ResourceLocation name) {
        return StoneVariantRegistry.INSTANCE.variants.getOrDefault(name, STONE);
    }

    public static Optional<StoneVariant> getOptionalVariant(ResourceLocation name) {
        return StoneVariantRegistry.INSTANCE.variants.containsKey(name) ? Optional.of((StoneVariant)StoneVariantRegistry.INSTANCE.variants.get(name)) : Optional.empty();
    }

    @Override
    public Optional<StoneVariant> getVariantFromBlock(Block baseBlock, ResourceLocation blockId) {
        Material mat;
        BlockState state;
        String name = null;
        String path = blockId.m_135815_();
        if (blockId.m_135827_().equals("tfc")) {
            Optional cobble;
            if (path.contains("rock/polished/") && (cobble = Registry.f_122824_.m_6612_(new ResourceLocation(blockId.m_135827_(), path.replace("polished", "raw")))).isPresent()) {
                ResourceLocation id = new ResourceLocation(blockId.m_135827_(), path.replace("rock/polished/", ""));
                return Optional.of(new StoneVariant(id, baseBlock, (Block)cobble.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_polished")) {
            name = path.substring(0, path.length() - "_polished".length());
        } else if (path.startsWith("polished_")) {
            name = path.substring("polished_".length());
        } else if (path.endsWith("_polish")) {
            name = path.substring(0, path.length() - "_polish".length());
        } else if (path.startsWith("polish_")) {
            name = path.substring("polish_".length());
        }
        String namespace = blockId.m_135827_();
        if (!(namespace.equals("cozy_home") || namespace.equals("adorn") || name == null || namespace.equals("securitycraft") || namespace.equals("absentbydesign") || namespace.equals("chipped") || namespace.equals("polydecorations") || namespace.equals("extshape") || namespace.equals("modernlife") || namespace.equals("ars_nouveau") && path.contains("sconce") || (state = baseBlock.m_49966_()).m_61147_().size() > 2 || baseBlock instanceof SlabBlock || name.contains("slab") || baseBlock instanceof BasePressurePlateBlock || name.contains("pressure_plate") || (mat = state.m_60767_()) != Material.f_76278_)) {
            name = name.replace("/", "_");
            ResourceLocation id = new ResourceLocation(blockId.m_135827_(), name);
            Block rawBlock = StoneVariantRegistry.findRaw(id);
            if (rawBlock != null) {
                return Optional.of(new StoneVariant(id, baseBlock, rawBlock));
            }
        }
        return Optional.empty();
    }

    @Override
    public StoneVariant getDefaultType() {
        return STONE;
    }

    @Override
    public Class<StoneVariant> getType() {
        return StoneVariant.class;
    }

    @Nullable
    private static Block findRaw(ResourceLocation id) {
        ResourceLocation[] test = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_()), new ResourceLocation(id.m_135827_(), id.m_135815_() + "raw"), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_raw"), new ResourceLocation(id.m_135827_(), "raw_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), "raw" + id.m_135815_()), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_cobble"), new ResourceLocation(id.m_135827_(), id.m_135815_() + "cobble"), new ResourceLocation(id.m_135827_(), "cobble_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), "cobble" + id.m_135815_()), new ResourceLocation(id.m_135815_()), new ResourceLocation(id.m_135815_() + "raw"), new ResourceLocation(id.m_135815_() + "_raw"), new ResourceLocation("raw_" + id.m_135815_()), new ResourceLocation("raw" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_cobble"), new ResourceLocation(id.m_135815_() + "cobble"), new ResourceLocation("cobble_" + id.m_135815_()), new ResourceLocation("cobble" + id.m_135815_())};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!Registry.f_122824_.m_7804_(r)) continue;
            temp = (Block)Registry.f_122824_.m_7745_(r);
            break;
        }
        return temp;
    }
}

