/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.networking.forge;

import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.ToiletState;
import com.unlikepaladin.pfm.registry.SoundIDs;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class ToiletUsePacket {
    private final BlockPos blockPos;

    public ToiletUsePacket(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public static void handle(ToiletUsePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos blockPos = msg.blockPos;
            Level world = Objects.requireNonNull(player).m_20193_();
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
                if (world.m_46805_(blockPos)) {
                    world.m_46597_(blockPos, (BlockState)world.m_8055_(blockPos).m_61124_(BasicToiletBlock.TOILET_STATE, (Comparable)((Object)ToiletState.DIRTY)));
                    world.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundIDs.TOILET_USED_EVENT, SoundSource.BLOCKS, 0.3f, world.f_46441_.nextFloat() * 0.1f + 0.9f);
                } else {
                    player.m_5661_(Component.m_130674_((String)"Trying to access unloaded chunks, are you cheating?"), false);
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }

    public static void encode(ToiletUsePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.blockPos);
    }

    public static ToiletUsePacket decode(FriendlyByteBuf buffer) {
        BlockPos blockPos = buffer.m_130135_();
        return new ToiletUsePacket(blockPos);
    }
}

