/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.networking.forge;

import com.unlikepaladin.pfm.blocks.blockentities.TrashcanBlockEntity;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class TrashcanClearPacket {
    private final BlockPos blockPos;

    public TrashcanClearPacket(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public static void handle(TrashcanClearPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos entityPos = msg.blockPos;
            Level world = Objects.requireNonNull(player).m_20193_();
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
                if (world.m_46805_(entityPos)) {
                    TrashcanBlockEntity trashcanBlockEntity = (TrashcanBlockEntity)player.f_19853_.m_7702_(entityPos);
                    trashcanBlockEntity.m_6211_();
                } else {
                    player.m_5661_(Component.m_130674_((String)"Trying to access unloaded chunks, are you cheating?"), false);
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }

    public static void encode(TrashcanClearPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.blockPos);
    }

    public static TrashcanClearPacket decode(FriendlyByteBuf buffer) {
        BlockPos blockPos = buffer.m_130135_();
        return new TrashcanClearPacket(blockPos);
    }
}

