/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.dynamic.forge;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.data.materials.DynamicBlockRegistry;
import com.unlikepaladin.pfm.registry.dynamic.LateBlockRegistry;
import com.unlikepaladin.pfm.registry.dynamic.forge.LateBlockRegistryImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LateBlockRegistryForge {
    private static boolean hasRegisteredBlockSets = false;
    private static Pair<List<Runnable>, List<Consumer<RegistryEvent.Register<Item>>>> LATE_REGISTRATION_QUEUE = null;

    public static <R extends IForgeRegistryEntry<R>> void addDynamicBlockRegistration(Class<R> regType) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (LATE_REGISTRATION_QUEUE == null) {
            LATE_REGISTRATION_QUEUE = Pair.of(new ArrayList(), new ArrayList());
            bus.addGenericListener(Item.class, EventPriority.HIGHEST, LateBlockRegistryForge::registerLateBlockAndItems);
        }
        if (regType == Block.class || regType == Item.class) {
            if (regType == Block.class) {
                Consumer<RegistryEvent.Register> eventConsumer = e -> {
                    Runnable blockEvent = () -> {
                        IForgeRegistry registry = e.getRegistry();
                        if (registry instanceof ForgeRegistry) {
                            ForgeRegistry fr = (ForgeRegistry)registry;
                            boolean frozen = fr.isLocked();
                            fr.unfreeze();
                            try {
                                LateBlockRegistry.registerBlocks();
                            }
                            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                                throw new RuntimeException(ex);
                            }
                            LateBlockRegistryImpl.registerBlocks((RegistryEvent.Register<Block>)e);
                            if (frozen) {
                                fr.freeze();
                            }
                        }
                    };
                    ((List)LATE_REGISTRATION_QUEUE.getFirst()).add(blockEvent);
                };
                bus.addGenericListener(regType, EventPriority.HIGHEST, eventConsumer);
            } else {
                Consumer<RegistryEvent.Register> itemEvent = LateBlockRegistryImpl::registerItems;
                ((List)LATE_REGISTRATION_QUEUE.getSecond()).add(itemEvent);
            }
        }
    }

    public static void registerLateBlockAndItems(RegistryEvent.Register<Item> event) {
        if (!hasRegisteredBlockSets) {
            DynamicBlockRegistry.initialize();
            hasRegisteredBlockSets = true;
        }
        ((List)LATE_REGISTRATION_QUEUE.getFirst()).forEach(Runnable::run);
        ((List)LATE_REGISTRATION_QUEUE.getSecond()).forEach(registerConsumer -> registerConsumer.accept(event));
        ((List)LATE_REGISTRATION_QUEUE.getFirst()).clear();
        ((List)LATE_REGISTRATION_QUEUE.getSecond()).clear();
    }
}

