/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class DynamicFurnitureRecipeJsonFactory {
    private final Advancement.Builder builder = Advancement.Builder.m_138353_();
    private List<Ingredient> vanillaIngredients = Lists.newArrayList();
    private final String outputClass;
    private final int outputCount;
    private String group;
    private Map<String, Integer> variantChildren = new HashMap<String, Integer>();
    private final List<ResourceLocation> supportedVariants;
    @Nullable
    private final net.minecraft.nbt.Tag nbtElement;

    public DynamicFurnitureRecipeJsonFactory(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren) {
        this.outputClass = output.getSimpleName();
        this.outputCount = outputCount;
        this.nbtElement = null;
        this.supportedVariants = supportedVariants;
        this.variantChildren = variantChildren;
    }

    public DynamicFurnitureRecipeJsonFactory(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren, @Nullable net.minecraft.nbt.Tag nbtElement) {
        this.outputClass = output.getSimpleName();
        this.outputCount = outputCount;
        this.supportedVariants = supportedVariants;
        this.variantChildren = variantChildren;
        this.nbtElement = nbtElement;
    }

    public DynamicFurnitureRecipeJsonFactory(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren, List<Ingredient> inputs) {
        this.outputClass = output.getSimpleName();
        this.outputCount = outputCount;
        this.nbtElement = null;
        this.supportedVariants = supportedVariants;
        this.vanillaIngredients = inputs;
        this.variantChildren = variantChildren;
    }

    public DynamicFurnitureRecipeJsonFactory(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren, List<Ingredient> inputs, @Nullable net.minecraft.nbt.Tag nbtElement) {
        this.outputClass = output.getSimpleName();
        this.outputCount = outputCount;
        this.supportedVariants = supportedVariants;
        this.vanillaIngredients = inputs;
        this.variantChildren = variantChildren;
        this.nbtElement = nbtElement;
    }

    public DynamicFurnitureRecipeJsonFactory(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants) {
        this.outputClass = output.getSimpleName();
        this.outputCount = outputCount;
        this.supportedVariants = supportedVariants;
        this.nbtElement = null;
    }

    public DynamicFurnitureRecipeJsonFactory(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, @Nullable net.minecraft.nbt.Tag nbtElement) {
        this.outputClass = output.getSimpleName();
        this.outputCount = outputCount;
        this.supportedVariants = supportedVariants;
        this.nbtElement = nbtElement;
    }

    public static DynamicFurnitureRecipeJsonFactory create(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren, List<Ingredient> inputs, @Nullable net.minecraft.nbt.Tag nbtElement) {
        return new DynamicFurnitureRecipeJsonFactory(output, outputCount, supportedVariants, variantChildren, inputs, nbtElement);
    }

    public static DynamicFurnitureRecipeJsonFactory create(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren, List<Ingredient> inputs) {
        return new DynamicFurnitureRecipeJsonFactory(output, outputCount, supportedVariants, variantChildren, inputs);
    }

    public static DynamicFurnitureRecipeJsonFactory create(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren) {
        return new DynamicFurnitureRecipeJsonFactory(output, outputCount, supportedVariants, variantChildren);
    }

    public static DynamicFurnitureRecipeJsonFactory create(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren, @Nullable net.minecraft.nbt.Tag nbtElement) {
        return new DynamicFurnitureRecipeJsonFactory(output, outputCount, supportedVariants, variantChildren, nbtElement);
    }

    public static DynamicFurnitureRecipeJsonFactory create(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants) {
        return new DynamicFurnitureRecipeJsonFactory(output, outputCount, supportedVariants);
    }

    public static DynamicFurnitureRecipeJsonFactory create(Class<? extends Block> output, int outputCount, List<ResourceLocation> supportedVariants, @Nullable net.minecraft.nbt.Tag nbtElement) {
        return new DynamicFurnitureRecipeJsonFactory(output, outputCount, supportedVariants, nbtElement);
    }

    public DynamicFurnitureRecipeJsonFactory criterion(String string, CriterionTriggerInstance criterionConditions) {
        this.builder.m_138386_(string, criterionConditions);
        return this;
    }

    public DynamicFurnitureRecipeJsonFactory group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public String getOutputClass() {
        return this.outputClass;
    }

    public DynamicFurnitureRecipeJsonFactory vanillaInput(Tag<Item> tag) {
        return this.vanillaInput(Ingredient.m_43911_(tag));
    }

    public DynamicFurnitureRecipeJsonFactory vanillaInput(Ingredient ingredient) {
        return this.vanillaInput(ingredient, 1);
    }

    public DynamicFurnitureRecipeJsonFactory vanillaInput(ItemLike itemProvider) {
        return this.vanillaInput(itemProvider, 1);
    }

    public DynamicFurnitureRecipeJsonFactory vanillaInput(ItemLike itemProvider, int size) {
        for (int i = 0; i < size; ++i) {
            this.vanillaInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemProvider}));
        }
        return this;
    }

    public DynamicFurnitureRecipeJsonFactory vanillaInput(Ingredient ingredient, int size) {
        for (int i = 0; i < size; ++i) {
            this.vanillaIngredients.add(ingredient);
        }
        return this;
    }

    public DynamicFurnitureRecipeJsonFactory childInput(String ingredient, int size) {
        this.variantChildren.put(ingredient, size);
        return this;
    }

    public DynamicFurnitureRecipeJsonFactory childInput(String ingredient) {
        return this.childInput(ingredient, 1);
    }

    public void offerTo(Consumer<FinishedRecipe> exporter, ResourceLocation recipeId) {
        this.builder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        exporter.accept(new DynamicFurnitureRecipeJsonProvider(recipeId, this.outputClass, this.nbtElement, this.outputCount, this.group, this.vanillaIngredients, this.supportedVariants, this.variantChildren, this.builder, new ResourceLocation(recipeId.m_135827_(), "recipes/furniture/" + recipeId.m_135815_())));
    }

    public void offerTo(Consumer<FinishedRecipe> exporter) {
        this.offerTo(exporter, new ResourceLocation("pfm", this.getOutputClass().toLowerCase(Locale.US)));
    }

    public void offerTo(Consumer<FinishedRecipe> exporter, String recipePath) {
        ResourceLocation identifier2 = new ResourceLocation(recipePath);
        ResourceLocation identifier = new ResourceLocation("pfm", this.getOutputClass().toLowerCase(Locale.US));
        if (identifier2.equals((Object)identifier)) {
            throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
        }
        this.offerTo(exporter, identifier2);
    }

    public static class DynamicFurnitureRecipeJsonProvider
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final String outputClass;
        private final int count;
        private final String group;
        private final List<Ingredient> vanillaIngredients;
        private final Map<String, Integer> variantChildren;
        private final List<ResourceLocation> supportedVariants;
        private final Advancement.Builder builder;
        private final ResourceLocation advancementId;
        @Nullable
        private final net.minecraft.nbt.Tag nbtElement;

        public DynamicFurnitureRecipeJsonProvider(ResourceLocation recipeId, String outputClass, @Nullable net.minecraft.nbt.Tag nbtElement, int outputCount, String group, List<Ingredient> vanillaIngredients, List<ResourceLocation> supportedVariants, Map<String, Integer> variantChildren, Advancement.Builder builder, ResourceLocation advancementId) {
            this.recipeId = recipeId;
            this.outputClass = outputClass;
            this.count = outputCount;
            this.group = group;
            this.vanillaIngredients = vanillaIngredients;
            this.builder = builder;
            this.advancementId = advancementId;
            this.nbtElement = nbtElement;
            this.variantChildren = variantChildren;
            this.supportedVariants = supportedVariants;
        }

        public void m_7917_(JsonObject json) {
            if (this.group != null && !this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray identifierArray = new JsonArray();
            for (ResourceLocation identifier : this.supportedVariants) {
                identifierArray.add(identifier.toString());
            }
            json.add("supportedVariants", (JsonElement)identifierArray);
            JsonObject ingredients = new JsonObject();
            JsonArray ingredientArray = new JsonArray();
            for (Ingredient ingredient : this.vanillaIngredients) {
                ingredientArray.add(ingredient.m_43942_());
            }
            ingredients.add("vanillaIngredients", (JsonElement)ingredientArray);
            JsonObject variantChildrenObject = new JsonObject();
            for (Map.Entry<String, Integer> entry : this.variantChildren.entrySet()) {
                variantChildrenObject.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            ingredients.add("variantChildren", (JsonElement)variantChildrenObject);
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("outputClass", this.outputClass);
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            if (this.nbtElement != null) {
                JsonElement jsonElement = (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, this.nbtElement);
                jsonObject.add("tag", jsonElement);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeTypes.DYNAMIC_FURNITURE_SERIALIZER;
        }

        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.builder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

