/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.utilities;

import com.unlikepaladin.pfm.utilities.forge.PFMFileUtilImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.server.packs.PackResources;
import net.minecraft.util.StringRepresentable;

public class PFMFileUtil {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGamePath() {
        return PFMFileUtilImpl.getGamePath();
    }

    public static void deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                PFMFileUtil.deleteDir(f);
            }
        }
        file.delete();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<PackResources> getSubPacks(PackResources pack) {
        return PFMFileUtilImpl.getSubPacks(pack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ModLoader getModLoader() {
        return PFMFileUtilImpl.getModLoader();
    }

    public static enum ModLoader implements StringRepresentable
    {
        MINECRAFTFORGE("minecraftforge"),
        FABRIC("fabric"),
        INVALID("");

        private String loader;

        private ModLoader(String loader) {
            this.loader = loader;
        }

        public static ModLoader get(String modLoader) {
            for (ModLoader value : ModLoader.values()) {
                if (!value.loader.equals(modLoader)) continue;
                return value;
            }
            return INVALID;
        }

        public String m_7912_() {
            return this.loader;
        }
    }
}

