/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.ai_stuffs;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.ai_stuffs.IBrainedDragon;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.level.Level;

public class BehaviorManager {
    private final List<BehaviorEntry<?>> behaviors = new ArrayList();
    private DragonBehavior<?> activeBehavior = null;
    private Object activeDragon = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addBehavior(int priority, DragonBehavior<T> behavior) {
        List<BehaviorEntry<?>> list = this.behaviors;
        synchronized (list) {
            this.behaviors.add(new BehaviorEntry<T>(behavior, priority));
            this.behaviors.sort(Comparator.comparingInt(entry -> -entry.priority));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void executeBehaviors(IBrainedDragon<T> pEntity, Level level) {
        ArrayList behaviorsCopy;
        T pEntityInstance = pEntity.getSelf();
        DragonBehavior<T> candidateBehavior = null;
        List<BehaviorEntry<?>> list = this.behaviors;
        synchronized (list) {
            behaviorsCopy = new ArrayList(this.behaviors);
        }
        for (BehaviorEntry behaviorEntry : behaviorsCopy) {
            try {
                DragonBehavior<T> behavior = behaviorEntry.behavior;
                if (!behavior.canStart(pEntityInstance, level)) continue;
                candidateBehavior = behavior;
                break;
            }
            catch (ClassCastException e) {
            }
        }
        if (candidateBehavior != null && candidateBehavior != this.activeBehavior) {
            if (this.activeBehavior != null && this.activeDragon != null) {
                try {
                    this.activeBehavior.stop(this.activeDragon, level);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.activeBehavior = candidateBehavior;
            this.activeDragon = pEntityInstance;
            candidateBehavior.start(pEntityInstance, level);
        } else if (candidateBehavior == null) {
            if (this.activeBehavior != null && this.activeDragon != null) {
                try {
                    this.activeBehavior.stop(this.activeDragon, level);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                this.activeBehavior = null;
                this.activeDragon = null;
            }
        } else {
            candidateBehavior.start(pEntityInstance, level);
        }
    }

    private static class BehaviorEntry<T> {
        DragonBehavior<T> behavior;
        int priority;

        BehaviorEntry(DragonBehavior<T> behavior, int priority) {
            this.behavior = behavior;
            this.priority = priority;
        }
    }
}

