/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity;

import com.bdc.bdd.api.entity.core_classes.BddFlyingDragon;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BddAbstractDragon
extends BddFlyingDragon {
    public BddAbstractDragon(EntityType<? extends BddAbstractDragon> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    public void setTarget(@Nullable LivingEntity pLivingEntity) {
        if (!this.isAlive()) {
            super.setTarget(pLivingEntity);
        }
    }

    @Override
    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        Entity entity;
        this.setSleepDisturbTicks(500);
        if (pAmount > 0.0f && !this.isTame() && (entity = pSource.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            this.setTarget((LivingEntity)player);
        }
        if (pSource.getEntity() != null && pSource.getEntity().getVehicle() == this) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    @Override
    public void tick() {
        super.tick();
        LivingEntity livingEntity = this.getTarget();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.isCreative() && player.isSpectator()) {
                this.setTarget(null);
            } else if (this.isArmedWithinRange(3.0)) {
                this.setTarget((LivingEntity)player);
            }
        }
    }

    public void swing(@NotNull InteractionHand pHand) {
        this.swing(pHand, true);
    }

    public void swing(InteractionHand pHand, boolean pUpdateSelf) {
        super.swing(pHand, pUpdateSelf);
        this.setBiting(true);
    }
}

