/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity;

import com.bdc.bdd.api.ai_stuffs.IBrainedDragon;
import com.bdc.bdd.api.entity.BddAbstractDragon;
import com.bdc.bdd.api.entity.ai.behaviors.AggressionBehavior;
import com.bdc.bdd.api.entity.ai.behaviors.DragonTemptingBehavior;
import com.bdc.bdd.api.entity.ai.behaviors.FlyWanderBehavior;
import com.bdc.bdd.api.entity.ai.behaviors.FollowingBehavior;
import com.bdc.bdd.api.entity.ai.behaviors.FoodSeekingBehavior;
import com.bdc.bdd.api.entity.ai.behaviors.WanderingBehavior;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class BddDragon
extends BddAbstractDragon
implements IBrainedDragon<BddDragon> {
    public boolean canFly;
    public boolean canRide;

    public BddDragon(EntityType<? extends BddDragon> entityType, Level level, boolean canDragonFly, boolean canPlayerRide, int maxHunger, float flySpeed, float damage) {
        super((EntityType<? extends BddAbstractDragon>)entityType, level);
        this.canFly = canDragonFly;
        this.canRide = canPlayerRide;
        MAX_HUNGER = maxHunger;
        DEFAULT_FLYING_SPEED = flySpeed;
        DEFAULT_ATTACK_DAMAGE = damage;
    }

    @Override
    public void registerBehaviors() {
        this.addBehavior(7, new FoodSeekingBehavior());
        this.addBehavior(7, new AggressionBehavior());
        this.addBehavior(5, new DragonTemptingBehavior());
        this.addBehavior(0, new FollowingBehavior());
        this.addBehavior(1, new WanderingBehavior());
        this.addBehavior(0, new FlyWanderBehavior());
    }

    @Override
    public BddDragon getSelf() {
        return this;
    }

    @Override
    public boolean canActivate() {
        return !this.isAIDisabled();
    }

    public Vec3 adjustFirstPersonCamera(Vec3 rideOffset, Matrix4f boneMatrix) {
        if (boneMatrix != null) {
            Vector3f offset = new Vector3f((float)rideOffset.x(), (float)rideOffset.y(), (float)rideOffset.z());
            boneMatrix.transformPosition(offset);
            return new Vec3((double)offset.x(), (double)offset.y(), (double)offset.z());
        }
        return rideOffset;
    }

    @Override
    public boolean canBeRidden() {
        return this.canRide;
    }

    @Override
    public boolean canFly() {
        return this.canFly;
    }
}

