/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import java.util.logging.Level;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class AggressionBehavior
implements DragonBehavior<BddDragon> {
    private static final double AGGRESSION_RADIUS = 3.0;
    private static final double ATTACK_DISTANCE = 2.5;
    private LivingEntity targetPlayer = null;

    @Override
    public boolean canStart(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (!dragon.isWild() && !dragon.isCautious()) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"AggressionBehavior: Dragon is not wild or cautious, cannot execute");
            return false;
        }
        AABB searchBox = dragon.getBoundingBox().inflate(3.0);
        this.targetPlayer = level.getEntitiesOfClass(Player.class, searchBox, player -> !player.isCreative()).stream().findFirst().orElse(null);
        boolean canStart = this.targetPlayer != null && dragon.canMove();
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("AggressionBehavior: canStart: " + canStart + ", Target Player: " + (this.targetPlayer != null ? this.targetPlayer.getName().getString() : "None")));
        return canStart;
    }

    @Override
    public void start(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (this.targetPlayer != null && this.targetPlayer.isAlive()) {
            dragon.setTarget(this.targetPlayer);
            double distanceToPlayer = dragon.distanceToSqr((Entity)this.targetPlayer);
            if (distanceToPlayer <= 6.25) {
                dragon.setBiting(true);
                this.targetPlayer.hurt(level.damageSources().mobAttack((LivingEntity)dragon), dragon.getPower());
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon biting player: " + this.targetPlayer.getName().getString() + " at position: " + String.valueOf(this.targetPlayer.position())));
                dragon.getNavigation().stop();
                dragon.setDeltaMovement(Vec3.ZERO);
                dragon.setSprinting(false);
            } else {
                Vec3 playerPos = this.targetPlayer.position().add(0.0, 0.25, 0.0);
                double speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.getFlyingSpeed() : (double)dragon.getSpeed() * 8.0;
                dragon.setSprinting(true);
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.getNavigation().moveTo(playerPos.x, playerPos.y, playerPos.z, speed);
                } else {
                    dragon.setFlying(false);
                    dragon.getNavigation().moveTo(playerPos.x, playerPos.y, playerPos.z, speed);
                }
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon moving to player: " + this.targetPlayer.getName().getString() + " at position: " + String.valueOf(playerPos) + ", distance: " + Math.sqrt(distanceToPlayer)));
            }
        } else {
            this.targetPlayer = null;
            dragon.setTarget(null);
            dragon.getNavigation().stop();
            dragon.setSprinting(false);
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"No valid player target found, stopping aggression");
        }
    }

    @Override
    public void stop(BddDragon dragon, net.minecraft.world.level.Level level) {
        dragon.setTarget(null);
        this.targetPlayer = null;
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(Vec3.ZERO);
        dragon.setBiting(false);
        dragon.setFlying(false);
        dragon.setSprinting(false);
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)"AggressionBehavior stopped");
    }
}

