/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import java.util.Comparator;
import java.util.logging.Level;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class DragonAggressionBehavior
implements DragonBehavior<BddDragon> {
    private static final double SEARCH_RADIUS = 16.0;
    private static final double BITE_DISTANCE = 3.0;
    private static final int BITE_COOLDOWN_TICKS = 20;
    private Player targetPlayer = null;
    private int biteCooldown = 0;

    @Override
    public boolean canStart(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (!dragon.canMove() || !dragon.isArmed()) {
            return false;
        }
        this.targetPlayer = this.findClosestSurvivalPlayer(dragon, level);
        return this.targetPlayer != null && this.targetPlayer.isAlive() && !this.targetPlayer.isSpectator() && !this.targetPlayer.isCreative();
    }

    @Override
    public void start(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (level.isClientSide()) {
            return;
        }
        if (this.targetPlayer != null && this.targetPlayer.isAlive() && !this.targetPlayer.isSpectator() && !this.targetPlayer.isCreative() && dragon.isArmed()) {
            dragon.setTarget((LivingEntity)this.targetPlayer);
            double distanceToPlayer = dragon.distanceToSqr((Entity)this.targetPlayer);
            dragon.getLookControl().setLookAt(this.targetPlayer.getX(), this.targetPlayer.getEyeY(), this.targetPlayer.getZ(), 30.0f, 30.0f);
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon looking at player: " + this.targetPlayer.getName().getString() + " at position: " + String.valueOf(this.targetPlayer.position())));
            if (distanceToPlayer <= 9.0) {
                if (this.biteCooldown <= 0) {
                    dragon.triggerAnim("dragonAltAnimations", "bite");
                    BaseLogger.log((Level)BaseLogLevel.SUCCESS, (String)("Dragon biting player: " + this.targetPlayer.getName().getString() + " at position: " + String.valueOf(this.targetPlayer.position())));
                    this.biteCooldown = 20;
                }
                --this.biteCooldown;
                dragon.getNavigation().stop();
                dragon.setDeltaMovement(Vec3.ZERO);
            } else {
                double speed;
                Vec3 playerPos = this.targetPlayer.position().add(0.0, 0.25, 0.0);
                double d = speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.getFlyingSpeed() : (double)dragon.getSpeed() * 5.0;
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.getNavigation().moveTo(playerPos.x, playerPos.y, playerPos.z, speed);
                } else {
                    dragon.setFlying(false);
                    dragon.getNavigation().moveTo(playerPos.x, playerPos.y, playerPos.z, speed);
                }
                this.biteCooldown = Math.max(0, this.biteCooldown - 1);
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon moving to armed player: " + this.targetPlayer.getName().getString() + " at position: " + String.valueOf(playerPos) + ", distance: " + Math.sqrt(distanceToPlayer)));
            }
        } else {
            this.targetPlayer = null;
            dragon.setTarget(null);
            dragon.getNavigation().stop();
            this.biteCooldown = 0;
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"No valid armed player found or isArmed() false, stopping aggression");
        }
    }

    @Override
    public void stop(BddDragon dragon, net.minecraft.world.level.Level level) {
        dragon.setTarget(null);
        this.targetPlayer = null;
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(Vec3.ZERO);
        dragon.setFlying(false);
        this.biteCooldown = 0;
    }

    private Player findClosestSurvivalPlayer(BddDragon dragon, net.minecraft.world.level.Level level) {
        AABB searchBox = dragon.getBoundingBox().inflate(16.0);
        return level.getEntitiesOfClass(Player.class, searchBox, player -> player.isAlive() && !player.isSpectator() && !player.isCreative()).stream().min(Comparator.comparingDouble(player -> dragon.distanceToSqr((Entity)player))).orElse(null);
    }
}

