/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DragonTemptingBehavior
implements DragonBehavior<BddDragon> {
    private static final double TEMPT_RADIUS = 6.0;
    private static final double STOP_DISTANCE = 4.0;

    @Override
    public boolean canStart(BddDragon dragon, Level level) {
        if (!dragon.isFriendly() && !dragon.isTrusting()) {
            return false;
        }
        Player nearestPlayer = level.getNearestPlayer((Entity)dragon, 6.0);
        if (nearestPlayer == null || nearestPlayer.isSpectator()) {
            return false;
        }
        ItemStack mainHandItem = nearestPlayer.getMainHandItem();
        ItemStack offHandItem = nearestPlayer.getOffhandItem();
        return dragon.canMove() && (dragon.isFood(mainHandItem) || dragon.isFood(offHandItem));
    }

    @Override
    public void start(BddDragon dragon, Level level) {
        Player nearestPlayer = level.getNearestPlayer((Entity)dragon, 6.0);
        if (nearestPlayer != null) {
            double distanceToPlayer = dragon.distanceToSqr((Entity)nearestPlayer);
            if (distanceToPlayer < 16.0) {
                dragon.getNavigation().stop();
                dragon.setDeltaMovement(Vec3.ZERO);
            } else {
                double speed;
                double d = speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.getFlyingSpeed() : (double)dragon.getSpeed() * 8.0;
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.getNavigation().moveTo(nearestPlayer.getX(), nearestPlayer.getEyeY(), nearestPlayer.getZ(), speed);
                } else {
                    dragon.setFlying(false);
                    dragon.getNavigation().moveTo(nearestPlayer.getX(), nearestPlayer.getEyeY(), nearestPlayer.getZ(), speed);
                }
            }
            dragon.getLookControl().setLookAt(nearestPlayer.getX(), nearestPlayer.getEyeY(), nearestPlayer.getZ(), 30.0f, 30.0f);
        } else {
            dragon.getNavigation().stop();
            dragon.setDeltaMovement(Vec3.ZERO);
        }
    }

    @Override
    public void stop(BddDragon dragon, Level level) {
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(Vec3.ZERO);
        dragon.setFlying(false);
    }
}

