/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.util.BddUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class FlyWanderBehavior
implements DragonBehavior<BddDragon> {
    public static Random random = new Random();
    private static final double FOOD_SEARCH_RADIUS = 16.0;
    private int ticksUntilNewTarget = 0;
    private int ticksUntilFlightCheck = 0;
    private int ticksSinceLanding = 0;
    private int ticksSinceFlying = 0;
    private int ticksUntilVerticalChange = 0;
    private int verticalActionDuration = 0;
    private final int TARGET_REFRESH_TICKS;
    private final int FLIGHT_CHECK_TICKS;
    private final int LANDING_GRACE_TICKS = BddUtil.secondsToTicks(5);
    private final int MIN_FLYING_TICKS = BddUtil.secondsToTicks(3);
    private final int VERTICAL_CHECK_TICKS;
    private final int VERTICAL_ACTION_MIN_TICKS = BddUtil.secondsToTicks(2);
    private final int VERTICAL_ACTION_MAX_TICKS = BddUtil.secondsToTicks(5);

    public FlyWanderBehavior() {
        this.TARGET_REFRESH_TICKS = random.nextInt(BddUtil.secondsToTicks(7), BddUtil.secondsToTicks(14));
        this.FLIGHT_CHECK_TICKS = random.nextInt(BddUtil.secondsToTicks(3), BddUtil.secondsToTicks(6));
        this.VERTICAL_CHECK_TICKS = random.nextInt(BddUtil.secondsToTicks(5), BddUtil.secondsToTicks(10));
    }

    @Override
    public boolean canStart(BddDragon dragon, Level level) {
        AABB searchBox = dragon.getBoundingBox().inflate(16.0);
        boolean foodNearby = level.getEntitiesOfClass(ItemEntity.class, searchBox, item -> item.isAlive() && dragon.isFood(item.getItem())).stream().anyMatch(item -> dragon.distanceToSqr((Entity)item) <= 256.0);
        return !foodNearby && dragon.isDragonWandering() && !dragon.isArmed() && dragon.getTarget() == null && dragon.isAbleToFly() && dragon.canMove();
    }

    @Override
    public void start(BddDragon dragon, Level level) {
        if (!dragon.isFlying()) {
            ++this.ticksSinceLanding;
            this.ticksSinceFlying = 0;
        } else {
            ++this.ticksSinceFlying;
        }
        if (dragon.isDiving() && dragon.onGround()) {
            dragon.setDiving(false);
            dragon.setFlying(false);
            this.ticksSinceLanding = 0;
            this.ticksSinceFlying = 0;
            dragon.getNavigation().stop();
            dragon.setDeltaMovement(dragon.getDeltaMovement().x, 0.0, dragon.getDeltaMovement().z);
            this.selectRandomTarget(dragon, level);
        }
        if (this.ticksUntilFlightCheck > 0) {
            --this.ticksUntilFlightCheck;
        } else {
            this.ticksUntilFlightCheck = this.FLIGHT_CHECK_TICKS;
            if (!dragon.isFlying() && dragon.isAbleToFly() && dragon.random.nextFloat() < 0.35f && dragon.onGround() && this.ticksSinceLanding >= this.LANDING_GRACE_TICKS) {
                dragon.jumpFromGround();
                dragon.setFlying(true);
                this.selectRandomTarget(dragon, level);
            } else if (dragon.isFlying() && !dragon.isDiving() && dragon.random.nextFloat() < 0.8f) {
                dragon.setFlying(false);
                dragon.setDiving(true);
                this.ticksSinceLanding = 0;
                this.ticksSinceFlying = 0;
                dragon.getNavigation().stop();
                dragon.setDeltaMovement(dragon.getDeltaMovement().x, 0.0, dragon.getDeltaMovement().z);
                dragon.setDiving(false);
                this.selectRandomTarget(dragon, level);
            }
        }
        if (dragon.isFlying() && !dragon.isHovering() && !dragon.isGoingUp() && !dragon.isDiving()) {
            if (this.ticksUntilVerticalChange > 0) {
                --this.ticksUntilVerticalChange;
            } else if (this.ticksSinceFlying >= this.MIN_FLYING_TICKS) {
                this.ticksUntilVerticalChange = this.VERTICAL_CHECK_TICKS;
                if (dragon.random.nextFloat() < 0.5f) {
                    boolean shouldDive = dragon.random.nextBoolean();
                    if (shouldDive) {
                        dragon.setDiving(true);
                        dragon.setGoingUp(false);
                    } else {
                        dragon.setGoingUp(true);
                        dragon.setDiving(false);
                    }
                    this.verticalActionDuration = dragon.random.nextInt(this.VERTICAL_ACTION_MIN_TICKS, this.VERTICAL_ACTION_MAX_TICKS + 1);
                }
            }
        } else if (dragon.isFlying() && (dragon.isGoingUp() || dragon.isDiving())) {
            if (this.verticalActionDuration > 0) {
                --this.verticalActionDuration;
            } else {
                dragon.setGoingUp(false);
                dragon.setDiving(false);
                this.ticksUntilVerticalChange = this.VERTICAL_CHECK_TICKS;
            }
        }
        if (dragon.isFlying()) {
            this.selectRandomTarget(dragon, level);
        }
        if (dragon.targetPosition != null && dragon.isFlying()) {
            dragon.getNavigation().moveTo((double)dragon.targetPosition.getX() + 0.5, (double)dragon.targetPosition.getY(), (double)dragon.targetPosition.getZ() + 0.5, (double)dragon.getFlyingSpeed());
        }
    }

    @Override
    public void stop(BddDragon dragon, Level level) {
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(dragon.getDeltaMovement().x, 0.0, dragon.getDeltaMovement().z);
        dragon.setFlying(false);
        dragon.setDiving(false);
        dragon.setGoingUp(false);
        this.ticksUntilNewTarget = 0;
        this.ticksUntilFlightCheck = 0;
        this.ticksSinceLanding = 0;
        this.ticksSinceFlying = 0;
        this.ticksUntilVerticalChange = 0;
        this.verticalActionDuration = 0;
        dragon.targetPosition = null;
    }

    private void selectRandomTarget(BddDragon dragon, Level level) {
        if (!dragon.hasRestriction()) {
            dragon.targetPosition = null;
            return;
        }
        BlockPos restrictCenter = dragon.getRestrictCenter();
        float restrictRadius = dragon.getRestrictRadius();
        double angle = dragon.random.nextDouble() * 2.0 * Math.PI;
        double radius = Math.sqrt(dragon.random.nextDouble()) * (double)restrictRadius * 0.9;
        double offsetX = radius * Math.cos(angle);
        double offsetZ = radius * Math.sin(angle);
        double offsetY = radius * Math.sin(angle);
        double targetX = (double)restrictCenter.getX() + offsetX;
        double targetY = (double)restrictCenter.getY() + offsetY;
        double targetZ = (double)restrictCenter.getZ() + offsetZ;
        targetY = Mth.clamp((double)targetY, (double)(level.getMinBuildHeight() + 1), (double)(level.getMaxBuildHeight() - 1));
        dragon.targetPosition = new BlockPos((int)targetX, (int)targetY, (int)targetZ);
        if (!dragon.getNavigation().isStableDestination(dragon.targetPosition)) {
            dragon.targetPosition = null;
        }
    }
}

