/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.util.BddUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FollowingBehavior
implements DragonBehavior<BddDragon> {
    private double lastPlayerY = 0.0;
    private int verticalActionDuration = 0;
    private final int VERTICAL_ACTION_MIN_TICKS = BddUtil.secondsToTicks(2);
    private final int VERTICAL_ACTION_MAX_TICKS = BddUtil.secondsToTicks(5);

    @Override
    public boolean canStart(BddDragon dragon, Level level) {
        return dragon.isDragonFollowing() && dragon.getOwner() instanceof Player && !dragon.getOwner().isSpectator() && dragon.canMove();
    }

    @Override
    public void start(BddDragon dragon, Level level) {
        Player owner = (Player)dragon.getOwner();
        if (owner == null) {
            dragon.getNavigation().stop();
            return;
        }
        double distanceToOwner = dragon.distanceToSqr((Entity)owner);
        double followRadius = 100.0;
        double verticalDistance = Math.abs(dragon.getY() - owner.getY());
        double currentPlayerY = owner.getY();
        if (dragon.isFlying() && !dragon.isHovering()) {
            if (currentPlayerY > dragon.getY() + 0.1) {
                dragon.setGoingUp(true);
                dragon.setDiving(false);
                this.verticalActionDuration = dragon.random.nextInt(this.VERTICAL_ACTION_MIN_TICKS, this.VERTICAL_ACTION_MAX_TICKS + 1);
            } else if (currentPlayerY < dragon.getY() - 0.1) {
                dragon.setDiving(true);
                dragon.setGoingUp(false);
                this.verticalActionDuration = dragon.random.nextInt(this.VERTICAL_ACTION_MIN_TICKS, this.VERTICAL_ACTION_MAX_TICKS + 1);
            } else if (this.verticalActionDuration > 0) {
                --this.verticalActionDuration;
                if (Math.abs(dragon.getY() - currentPlayerY) <= 0.1) {
                    dragon.setGoingUp(false);
                    dragon.setDiving(false);
                    this.verticalActionDuration = 0;
                }
            } else {
                dragon.setGoingUp(false);
                dragon.setDiving(false);
            }
            dragon.getNavigation().moveTo(owner.getX(), owner.getY(), owner.getZ(), (double)dragon.getFlyingSpeed());
        }
        this.lastPlayerY = currentPlayerY;
        if (verticalDistance > 10.0 && dragon.isAbleToFly()) {
            if (!dragon.isFlying()) {
                dragon.jumpFromGround();
                dragon.setFlying(true);
                dragon.ticksSinceLanding = 0;
                dragon.ticksSinceFlying = 0;
            }
            dragon.setHovering(false);
            dragon.getNavigation().moveTo(owner.getX(), owner.getY(), owner.getZ(), (double)dragon.getFlyingSpeed());
            dragon.targetPosition = new BlockPos((int)owner.getX(), (int)owner.getY(), (int)owner.getZ());
        } else if (distanceToOwner <= followRadius && dragon.isFlying() && dragon.getY() >= currentPlayerY - 0.1) {
            if (!dragon.isHovering()) {
                dragon.setHovering(true);
                dragon.setFlying(true);
                dragon.getNavigation().stop();
                dragon.setDeltaMovement(Vec3.ZERO);
                dragon.targetPosition = null;
            }
        } else {
            dragon.setHovering(false);
            if (dragon.isAbleToFly() && !dragon.isFlying() && verticalDistance > 10.0) {
                dragon.jumpFromGround();
                dragon.setFlying(true);
                dragon.ticksSinceLanding = 0;
                dragon.ticksSinceFlying = 0;
            }
            double speed = dragon.isFlying() ? (double)dragon.getFlyingSpeed() : (double)dragon.getSpeed() * 8.0;
            dragon.getNavigation().moveTo(owner.getX(), owner.getY(), owner.getZ(), speed);
            dragon.targetPosition = new BlockPos((int)owner.getX(), (int)owner.getY(), (int)owner.getZ());
        }
    }

    @Override
    public void stop(BddDragon dragon, Level level) {
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(dragon.getDeltaMovement().x, 0.0, dragon.getDeltaMovement().z);
        dragon.setFlying(false);
        dragon.setHovering(false);
        dragon.setGoingUp(false);
        dragon.setDiving(false);
        dragon.targetPosition = null;
        this.verticalActionDuration = 0;
        this.lastPlayerY = 0.0;
    }
}

