/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.util.BddUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WanderingBehavior
implements DragonBehavior<BddDragon> {
    public static Random random = new Random();
    private static final double FOOD_SEARCH_RADIUS = 16.0;
    private static final int WATER_AVOID_RADIUS = 2;
    private static final int MAX_TARGET_TRIES = 20;
    private static final double ROTATION_SMOOTHNESS = 0.15;
    private static final float MAX_YAW_CHANGE = 7.5f;
    private int ticksUntilNewTarget = 0;
    private final int TARGET_REFRESH_TICKS = random.nextInt(BddUtil.secondsToTicks(7), BddUtil.secondsToTicks(14));

    @Override
    public boolean canStart(BddDragon dragon, Level level) {
        AABB searchBox = dragon.getBoundingBox().inflate(16.0);
        boolean foodNearby = level.getEntitiesOfClass(ItemEntity.class, searchBox, item -> item.isAlive() && dragon.isFood(item.getItem())).stream().anyMatch(item -> dragon.distanceToSqr((Entity)item) <= 256.0);
        return !foodNearby && dragon.isDragonWandering() && !dragon.isFlying() && !dragon.isArmed() && dragon.getTarget() == null && dragon.canMove();
    }

    @Override
    public void start(BddDragon dragon, Level level) {
        if (this.ticksUntilNewTarget > 0) {
            --this.ticksUntilNewTarget;
        }
        if (dragon.targetPosition == null || this.ticksUntilNewTarget <= 0 || dragon.getNavigation().isDone()) {
            this.selectRandomTarget(dragon, level);
            this.ticksUntilNewTarget = this.TARGET_REFRESH_TICKS;
        }
        if (dragon.targetPosition != null) {
            this.moveToTarget(dragon, level);
        }
    }

    @Override
    public void stop(BddDragon dragon, Level level) {
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(dragon.getDeltaMovement().x, 0.0, dragon.getDeltaMovement().z);
        this.ticksUntilNewTarget = 0;
        dragon.targetPosition = null;
    }

    private void selectRandomTarget(BddDragon dragon, Level level) {
        if (!dragon.hasRestriction()) {
            dragon.targetPosition = null;
            return;
        }
        BlockPos restrictCenter = dragon.getRestrictCenter();
        float restrictRadius = dragon.getRestrictRadius();
        BlockPos targetPos = null;
        for (int tryCount = 0; tryCount < 20; ++tryCount) {
            Path path;
            double angle = dragon.random.nextDouble() * 2.0 * Math.PI;
            double radius = Math.sqrt(dragon.random.nextDouble()) * (double)restrictRadius;
            double offsetX = radius * Math.cos(angle);
            double offsetZ = radius * Math.sin(angle);
            double offsetY = 0.0;
            double targetX = (double)restrictCenter.getX() + offsetX;
            double targetY = (double)restrictCenter.getY() + offsetY;
            double targetZ = (double)restrictCenter.getZ() + offsetZ;
            targetY = Mth.clamp((double)targetY, (double)(level.getMinBuildHeight() + 1), (double)(level.getMaxBuildHeight() - 1));
            BlockPos groundPos = new BlockPos((int)targetX, (int)targetY, (int)targetZ);
            while (groundPos.getY() > level.getMinBuildHeight() && level.getBlockState(groundPos.below()).isAir()) {
                groundPos = groundPos.below();
            }
            if (!this.isValidTarget(level, groundPos, dragon) || (path = dragon.getNavigation().createPath(groundPos, 1)) == null || !path.canReach()) continue;
            targetPos = groundPos;
            break;
        }
        dragon.targetPosition = targetPos;
    }

    private void moveToTarget(BddDragon dragon, Level level) {
        if (dragon.targetPosition == null) {
            return;
        }
        Path path = dragon.getNavigation().createPath(dragon.targetPosition, 1);
        if (path == null || !path.canReach()) {
            dragon.targetPosition = null;
            return;
        }
        dragon.getNavigation().moveTo(path, (double)(dragon.getSpeed() * 7.0f));
        Vec3 targetVec = new Vec3((double)dragon.targetPosition.getX() + 0.5 - dragon.getX(), 0.0, (double)dragon.targetPosition.getZ() + 0.5 - dragon.getZ());
        if (targetVec.lengthSqr() > 0.01) {
            float targetYaw = (float)(Mth.atan2((double)targetVec.z, (double)targetVec.x) * 57.29577951308232 - 90.0);
            float currentYaw = dragon.getYRot();
            float deltaYaw = Mth.wrapDegrees((float)(targetYaw - currentYaw));
            float smoothedYaw = currentYaw + Mth.clamp((float)deltaYaw, (float)-7.5f, (float)7.5f) * 0.15f;
            dragon.setYRot(smoothedYaw);
        }
        if (this.isOnHazardousEdge(dragon, level)) {
            dragon.getNavigation().stop();
            dragon.setDeltaMovement(dragon.getDeltaMovement().x * 0.5, 0.0, dragon.getDeltaMovement().z * 0.5);
            dragon.targetPosition = null;
        }
    }

    private boolean isValidTarget(Level level, BlockPos pos, BddDragon dragon) {
        if (!dragon.getNavigation().isStableDestination(pos)) {
            return false;
        }
        BlockPos below = pos.below();
        if (!level.getFluidState(below).isEmpty()) {
            return false;
        }
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos checkPos = below.offset(dx, 0, dz);
                if (!level.getFluidState(checkPos).is(FluidTags.WATER)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isOnHazardousEdge(BddDragon dragon, Level level) {
        Vec3 movement = dragon.getDeltaMovement();
        if (movement.lengthSqr() < 0.01) {
            return false;
        }
        Vec3 pos = dragon.position().add(movement.normalize().scale(1.0));
        BlockPos aheadPos = new BlockPos((int)pos.x, (int)dragon.getY(), (int)pos.z);
        BlockPos belowAhead = aheadPos.below();
        return level.getBlockState(belowAhead).isAir() || level.getFluidState(belowAhead).is(FluidTags.WATER);
    }
}

