/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.api.util.DragonAbilities;
import com.bdc.bdd.projectile.BaseLinearBoltProjectile;
import com.bdc.bdd.projectile.BaseLinearFlightProjectile;
import com.bdc.bdd.projectile.fire_ball.FireBolt;
import com.bdc.bdd.projectile.plasma_blast.PlasmaBlast;
import com.bdc.bdd.projectile.zipple_gas.ZipplebackGas;
import com.bdc.bdd.util.BDDKeyMappings;
import com.bdc.bdd.util.BddUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BddAbilityDragon
extends BddBaseDragon {
    private static final EntityDataAccessor<Boolean> IS_BITING = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ROARING = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TAIL_WHIPPING = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GAS_SPARK = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FIRE_BREATH_FUEL = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> BREATHING_FIRE = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> F_BREATHING_TICKS = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TICK_SINCE_LAST_FIRE = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> MARK_FIRED = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DRAGON_PROJ_SHOTS = SynchedEntityData.defineId(BddAbilityDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int BITE_COOLDOWN_TICKS = BddUtil.secondsToTicks(1);
    private static final int ROAR_COOLDOWN_TICKS = 16;
    private static final int TAIL_WHIP_COOLDOWN_TICKS = BddUtil.secondsToTicks(1);
    private static final int SHOT_REGEN_COOLDOWN_TICKS = BddUtil.minutesToSeconds(2);
    private static final int FUEL_REGEN_COOLDOWN_TICKS = BddUtil.secondsToTicks(5);
    public static final int MAX_FUEL = 2800;
    private static final int MAX_SHOTS = 6;
    private static final int FUEL_CONSUMPTION = 10;
    private static final int FUEL_REGEN_AMOUNT = 2;
    private static final int TICKS_SINCE_LAST_PROJ_SHOOT_SET = 20;
    private int biteTicks = 0;
    private int roarTicks = 0;
    private static final int BITE_DURATION = BddUtil.secondsToTicks(1);
    private static final int ROAR_DURATION = BddUtil.secondsToTicks(2);
    private final List<DragonAbilities> abilities = new ArrayList<DragonAbilities>();
    private int playerBoltBlastPendingScale = 0;
    private int playerBoltBlastPendingStopThreshold = 0;
    public int biteCooldown = 0;
    private int roarCooldown = 0;
    private int tailWhipCooldown = 0;
    private int explosionStrength = 5;
    private int projSize = 0;
    private int shotRegenCooldown = 0;
    private int fuelRegenCooldown = 0;

    public BddAbilityDragon(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.initializeAbilities();
    }

    public void initializeAbilities() {
        this.addAbility(DragonAbilities.ROAR);
        this.addAbility(DragonAbilities.BITE);
        this.addAbility(DragonAbilities.TAIL_WHIP);
        this.addAbility(DragonAbilities.FLIGHT_LOCK);
        this.addAbility(DragonAbilities.HOVER);
        this.addAbility(DragonAbilities.SPEED_UP);
        this.addAbility(DragonAbilities.SPEED_DOWN);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_BITING, (Object)false);
        builder.define(IS_ROARING, (Object)false);
        builder.define(TAIL_WHIPPING, (Object)false);
        builder.define(GAS_SPARK, (Object)false);
        builder.define(BREATHING_FIRE, (Object)false);
        builder.define(FIRE_BREATH_FUEL, (Object)2800);
        builder.define(F_BREATHING_TICKS, (Object)0);
        builder.define(MARK_FIRED, (Object)false);
        builder.define(TICK_SINCE_LAST_FIRE, (Object)0);
        builder.define(DRAGON_PROJ_SHOTS, (Object)6);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Biting", this.isBiting());
        compound.putBoolean("Roaring", this.isRoaring());
        compound.putBoolean("TailWhip", this.isTailWhipping());
        compound.putBoolean("SecondAbility", this.isUsingSecondAbility());
        compound.putInt("RemainingFuel", this.getRemainingFuel());
        compound.putInt("BreathingTicks", this.getFRemainingTicks());
        compound.putBoolean("FireBreathing", this.isBreathingFire());
        compound.putBoolean("MarkFired", this.isMarkFired());
        compound.putInt("TicksFire", this.getTicksSinceLastFire());
        compound.putInt("FireBlastShots", this.getProjectileShots());
        ListTag abilitiesTag = new ListTag();
        for (DragonAbilities ability : this.abilities) {
            abilitiesTag.add((Object)StringTag.valueOf((String)ability.name()));
        }
        compound.put("Abilities", (Tag)abilitiesTag);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setBiting(compound.getBoolean("Biting"));
        this.setRoaring(compound.getBoolean("Roaring"));
        this.setTailWhipping(compound.getBoolean("TailWhip"));
        this.setUsingSecondAbility(compound.getBoolean("SecondAbility"));
        this.setRemainingFuel(compound.getInt("RemainingFuel"));
        this.setFRemainingTicks(compound.getInt("BreathingTicks"));
        this.setBreathingFire(compound.getBoolean("FireBreathing"));
        this.setTicksSinceLastFire(compound.getInt("TicksFire"));
        this.setMarkFired(compound.getBoolean("MarkFired"));
        this.setProjectileShots(compound.getInt("FireBlastShots"));
        this.abilities.clear();
        ListTag abilitiesTag = compound.getList("Abilities", 8);
        for (int i = 0; i < abilitiesTag.size(); ++i) {
            String abilityName = abilitiesTag.getString(i);
            try {
                DragonAbilities ability = DragonAbilities.valueOf(abilityName);
                this.abilities.add(ability);
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid ability name in NBT: " + abilityName);
            }
        }
    }

    @Override
    public void addAbility(DragonAbilities ability) {
        if (ability != null && !this.abilities.contains((Object)ability)) {
            this.abilities.add(ability);
        }
    }

    @Override
    public boolean hasAbility(DragonAbilities ability) {
        return ability != null && this.abilities.contains((Object)ability);
    }

    @Override
    public List<DragonAbilities> getAbilities() {
        return new ArrayList<DragonAbilities>(this.abilities);
    }

    public boolean isBiting() {
        return this.hasAbility(DragonAbilities.BITE) && (Boolean)this.entityData.get(IS_BITING) != false;
    }

    public void setBiting(boolean biting) {
        if (this.hasAbility(DragonAbilities.BITE)) {
            this.entityData.set(IS_BITING, (Object)biting);
        }
        if (biting) {
            this.biteTicks = 0;
        }
        this.attackEntityInFront(this.getThroatPos1(this));
    }

    public boolean isRoaring() {
        return this.hasAbility(DragonAbilities.ROAR) && (Boolean)this.entityData.get(IS_ROARING) != false;
    }

    public void setRoaring(boolean roaring) {
        if (this.hasAbility(DragonAbilities.ROAR)) {
            this.entityData.set(IS_ROARING, (Object)roaring);
        }
        if (roaring) {
            this.roarTicks = 0;
        }
    }

    public boolean isTailWhipping() {
        return this.hasAbility(DragonAbilities.TAIL_WHIP) && (Boolean)this.entityData.get(TAIL_WHIPPING) != false;
    }

    public void setTailWhipping(boolean value) {
        if (this.hasAbility(DragonAbilities.TAIL_WHIP)) {
            this.entityData.set(TAIL_WHIPPING, (Object)value);
        }
    }

    public boolean isUsingSecondAbility() {
        return this.hasAbility(DragonAbilities.GAS_SPARK) && (Boolean)this.entityData.get(GAS_SPARK) != false;
    }

    public void setUsingSecondAbility(boolean value) {
        if (this.hasAbility(DragonAbilities.GAS_SPARK)) {
            this.entityData.set(GAS_SPARK, (Object)value);
        }
    }

    public boolean isBreathingFire() {
        return (Boolean)this.entityData.get(BREATHING_FIRE);
    }

    public void setBreathingFire(boolean breathing) {
        this.entityData.set(BREATHING_FIRE, (Object)breathing);
    }

    public int getRemainingFuel() {
        return (Integer)this.entityData.get(FIRE_BREATH_FUEL);
    }

    public void setRemainingFuel(int fuel) {
        this.entityData.set(FIRE_BREATH_FUEL, (Object)Mth.clamp((int)fuel, (int)0, (int)2800));
    }

    public int getFRemainingTicks() {
        return (Integer)this.entityData.get(F_BREATHING_TICKS);
    }

    public void setFRemainingTicks(int ticks) {
        this.entityData.set(F_BREATHING_TICKS, (Object)Math.max(ticks, 0));
    }

    public int getProjectileShots() {
        return (Integer)this.entityData.get(DRAGON_PROJ_SHOTS);
    }

    public void setProjectileShots(int shots) {
        this.entityData.set(DRAGON_PROJ_SHOTS, (Object)Mth.clamp((int)shots, (int)0, (int)6));
    }

    public boolean isMarkFired() {
        return (Boolean)this.entityData.get(MARK_FIRED);
    }

    public void setMarkFired(boolean fired) {
        this.entityData.set(MARK_FIRED, (Object)fired);
    }

    public int getTicksSinceLastFire() {
        return (Integer)this.entityData.get(TICK_SINCE_LAST_FIRE);
    }

    public void setTicksSinceLastFire(int ticks) {
        this.entityData.set(TICK_SINCE_LAST_FIRE, (Object)Math.max(ticks, 0));
    }

    public boolean hasTwoHeads() {
        return false;
    }

    @Override
    public void tick() {
        LivingEntity livingEntity;
        super.tick();
        Vec3 throatPos1 = this.getThroatPos1(this);
        Vec3 throatPos2 = this.getThroatPos2(this);
        Vec3 tailPos = this.getTailPos(this);
        if (this.biteCooldown > 0 && --this.biteCooldown == 0) {
            this.setBiting(false);
        }
        if (this.roarCooldown > 0 && --this.roarCooldown == 0) {
            this.setRoaring(false);
        }
        if (this.tailWhipCooldown > 0 && --this.tailWhipCooldown == 0) {
            this.setTailWhipping(false);
        }
        if (this.shotRegenCooldown > 0) {
            --this.shotRegenCooldown;
        }
        if (this.fuelRegenCooldown > 0) {
            --this.fuelRegenCooldown;
        }
        if ((livingEntity = this.getControllingPassenger()) instanceof Player) {
            boolean hasProjectileAbility;
            Player rider = (Player)livingEntity;
            Vec3 riderLook = rider.getViewVector(1.0f);
            int ticksLimit = this.getMaxPlayerBoltBlast();
            if (this.isBiting() && this.biteCooldown == 0) {
                this.setBiting(true);
                this.biteCooldown = BITE_COOLDOWN_TICKS;
            }
            if (this.isRoaring() && this.roarCooldown == 0) {
                this.setRoaring(true);
                this.roarCooldown = 16;
                this.playSound(SoundEvents.RAVAGER_ROAR, this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.isBiting()) {
                ++this.biteTicks;
                if (this.biteTicks >= BITE_DURATION) {
                    this.setBiting(false);
                    this.biteTicks = 0;
                }
            }
            if (this.isRoaring()) {
                ++this.roarTicks;
                if (this.roarTicks >= ROAR_DURATION) {
                    this.setRoaring(false);
                    this.roarTicks = 0;
                }
            }
            if (this.isTailWhipping() && this.tailWhipCooldown == 0) {
                this.setTailWhipping(true);
                this.tailWhipCooldown = TAIL_WHIP_COOLDOWN_TICKS;
                this.attackEntityWithTail(tailPos);
            }
            if (this.isBreathingFire() && this.getRemainingFuel() >= 10) {
                if (this.hasAbility(DragonAbilities.FIRE_BREATH)) {
                    this.setBreathingFire(true);
                    this.modifyFuel(-10);
                    this.setFRemainingTicks(20);
                    Vec3 lookVec = this.getLookAngle();
                    this.doFireBreathStream(throatPos1, lookVec);
                } else if (this.hasAbility(DragonAbilities.GAS_BOMB)) {
                    this.setBreathingFire(true);
                    this.modifyFuel(-10);
                    this.setFRemainingTicks(20);
                    this.fireGas(riderLook, throatPos1);
                }
            } else {
                this.setBreathingFire(false);
            }
            Object zipCloud = this.getNearestGasCloud(this.level.getEntitiesOfClass(ZipplebackGas.ZippleBackAOECloud.class, this.getTargetSearchArea(this.getFollowDistance())), (LivingEntity)this, this.getX(), this.getEyeY(), this.getZ());
            if (this.isUsingSecondAbility() && this.hasAbility(DragonAbilities.GAS_SPARK)) {
                this.setUsingSecondAbility(true);
                this.level.addParticle((ParticleOptions)ParticleTypes.LAVA, throatPos2.x, throatPos2.y - 0.3, throatPos2.z, 1.0, 1.0, 1.0);
                this.playSound(SoundEvents.FLINTANDSTEEL_USE, 15.0f, 1.0f);
                if (zipCloud != null) {
                    ((ZipplebackGas.ZippleBackAOECloud)((Object)zipCloud)).hurt(this.damageSources().inFire(), 1.0f);
                }
            }
            boolean bl = hasProjectileAbility = this.hasAbility(DragonAbilities.FIRE_BLAST) || this.hasAbility(DragonAbilities.PLASMA_BLAST);
            if (this.isMarkFired() && hasProjectileAbility && this.getProjectileShots() > 0) {
                this.setMarkFired(true);
                ++this.playerBoltBlastPendingStopThreshold;
                if (this.playerBoltBlastPendingScale <= ticksLimit + 1 && (double)this.playerBoltBlastPendingStopThreshold < (double)ticksLimit * 1.1) {
                    ++this.playerBoltBlastPendingScale;
                }
            } else if (this.playerBoltBlastPendingScale > 0) {
                --this.playerBoltBlastPendingScale;
                --this.playerBoltBlastPendingStopThreshold;
            }
            if (this.canFireProj()) {
                this.fireProjectile(riderLook, throatPos1);
            }
        }
        if (this.shotRegenCooldown == 0 && this.getProjectileShots() < 6) {
            this.setProjectileShots(this.getProjectileShots() + 1);
            this.shotRegenCooldown = SHOT_REGEN_COOLDOWN_TICKS;
        }
        if (this.fuelRegenCooldown == 0 && this.getRemainingFuel() < 2800 && !this.isBreathingFire()) {
            this.modifyFuel(2);
            this.fuelRegenCooldown = FUEL_REGEN_COOLDOWN_TICKS;
        }
        if (this.getFRemainingTicks() > 0) {
            this.setFRemainingTicks(this.getFRemainingTicks() - 1);
        }
        if (this.getFRemainingTicks() <= 0 && this.getControllingPassenger() == null) {
            this.setBreathingFire(false);
        }
        if (this.getTicksSinceLastFire() > 0) {
            this.setTicksSinceLastFire(this.getTicksSinceLastFire() - 1);
        }
        this.setMarkFired(this.getTicksSinceLastFire() >= 2);
        if (this.tier1()) {
            this.setProjsSize(0);
        } else if (this.tier2()) {
            this.setProjsSize(1);
        } else if (this.tier3()) {
            this.setProjsSize(2);
        } else if (this.tier4()) {
            this.setProjsSize(3);
        }
        this.setExplosionStrength();
    }

    public void doFireBreathStream(Vec3 mouthPos, Vec3 lookVec) {
        Level level = this.level();
        double step = 0.2;
        double maxDistance = 20.0;
        double spreadAngle = 0.3;
        for (double d = 0.0; d < maxDistance; d += step) {
            double spreadRadius = d * Math.tan(spreadAngle);
            for (int i = 0; i < 5; ++i) {
                BlockPos blockPos;
                double offsetX = (this.random.nextDouble() - 0.5) * spreadRadius;
                double offsetY = (this.random.nextDouble() - 0.5) * spreadRadius;
                double offsetZ = (this.random.nextDouble() - 0.5) * spreadRadius;
                Vec3 pos = mouthPos.add(lookVec.scale(d)).add(offsetX, offsetY, offsetZ);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                if (this.random.nextFloat() < 0.3f) {
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                }
                if (this.random.nextFloat() < 0.1f) {
                    level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                }
                if (!level.getBlockState(blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z)).isAir() || !level.getBlockState(blockPos.below()).isSolidRender((BlockGetter)level, blockPos.below()) || !(this.random.nextFloat() < 0.08f)) continue;
                level.setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
            }
            AABB hitbox = new AABB(mouthPos.x - spreadRadius, mouthPos.y - spreadRadius, mouthPos.z - spreadRadius, mouthPos.x + spreadRadius, mouthPos.y + spreadRadius, mouthPos.z + spreadRadius).move(lookVec.scale(d));
            for (Entity entity : level.getEntities((Entity)this, hitbox)) {
                if (entity == this || !entity.isAlive()) continue;
                entity.setRemainingFireTicks(2);
                entity.hurt(this.damageSources().inFire(), 2.0f);
            }
        }
    }

    public AABB getTargetSearchArea(double distance) {
        return this.getBoundingBox().inflate(distance, distance, distance);
    }

    public double getFollowDistance() {
        return this.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    @Nullable
    public <T extends ZipplebackGas.ZippleBackAOECloud> T getNearestGasCloud(List<? extends T> entities, @Nullable LivingEntity attacker, double x, double y, double z) {
        double minDistance = -1.0;
        ZipplebackGas.ZippleBackAOECloud nearest = null;
        for (ZipplebackGas.ZippleBackAOECloud entity : entities) {
            if (!this.test(attacker, entity, 17.0, 3.0, 3.0)) continue;
            double distance = entity.distanceToSqr(x, y, z);
            if (minDistance != -1.0 && !(distance < minDistance)) continue;
            minDistance = distance;
            nearest = entity;
        }
        return (T)((Object)nearest);
    }

    public boolean test(@Nullable LivingEntity attacker, ZipplebackGas.ZippleBackAOECloud target, double yRange, double xRange, double zRange) {
        if (attacker == null) {
            return true;
        }
        double xDiff = this.getX() - target.getX();
        double yDiff = this.getY() - target.getY();
        double zDiff = this.getZ() - target.getZ();
        if (yDiff > yRange || yDiff < -2.0 || xDiff > xRange || zDiff > zRange) {
            return false;
        }
        return this.getSensing().hasLineOfSight((Entity)target);
    }

    public int getProjsSize() {
        return this.projSize;
    }

    public void setProjsSize(int size) {
        this.projSize = size;
    }

    public boolean canFireProj() {
        return !this.isBaby();
    }

    public void modifyFuel(int amount) {
        this.setRemainingFuel(Mth.clamp((int)(this.getRemainingFuel() + amount), (int)0, (int)2800));
    }

    public void fireGas(Vec3 riderLook, Vec3 throat) {
        if (this.random.nextInt(10) == 1) {
            Vec3 lookVector = riderLook.normalize();
            ZipplebackGas gasProj = new ZipplebackGas(this, throat, lookVector, this.level());
            gasProj.setProjectileSize(5);
            gasProj.shoot(lookVector, 3.0f, 4.0);
            this.level.addFreshEntity((Entity)gasProj);
        }
    }

    public void fireProjectile(Vec3 riderLook, Vec3 throat) {
        if (!(this.tier1() || this.tier2() || this.tier3() || this.tier4())) {
            return;
        }
        boolean isFireBlast = this.hasAbility(DragonAbilities.FIRE_BLAST);
        boolean isPlasmaBlast = this.hasAbility(DragonAbilities.PLASMA_BLAST);
        boolean isBlastKeyDown = BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).isDown();
        if ((isFireBlast || isPlasmaBlast) && !isBlastKeyDown && this.getProjectileShots() > 0 && !this.isMarkFired()) {
            BaseLinearBoltProjectile bolt = isFireBlast ? new FireBolt(this, throat, riderLook, this.level, 8) : new PlasmaBlast(this, throat, riderLook, this.level, 8);
            this.setTicksSinceLastFire(20);
            bolt.shoot(riderLook, 1.0f, this.getBoltProjectileSpeed());
            bolt.setProjectileSize(this.getProjsSize());
            this.playSound(SoundEvents.LAVA_POP, 18.0f, 0.05f);
            this.level.addFreshEntity((Entity)bolt);
            this.setPlayerBoltBlastPendingStopThreshold(0);
            this.setPlayerBoltBlastPendingScale(0);
            this.setProjectileShots(this.getProjectileShots() - 1);
        }
    }

    protected float getBoltProjectileSpeed() {
        return 12.0f;
    }

    public void attackEntityInFront(Vec3 throatPos) {
        AABB area = new AABB(throatPos.x - 0.5, throatPos.y - 0.5, throatPos.z - 0.5, throatPos.x + 0.5, throatPos.y + 0.5, throatPos.z + 0.5);
        for (Entity entity : this.level.getEntities((Entity)this, area)) {
            if (entity == this) continue;
            double damage = this.getPower();
            entity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)damage);
            break;
        }
    }

    private void attackEntityWithTail(Vec3 tailPos) {
        AABB area = new AABB(tailPos.x - 0.5, tailPos.y - -0.5, tailPos.z - 0.5, tailPos.x + 0.5, tailPos.y + 0.5, tailPos.z + 0.5);
        for (Entity entity : this.level.getEntities((Entity)this, area)) {
            if (entity == this || !entity.isAlive()) continue;
            double damage = this.getPower();
            entity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)damage);
            Vec3 knockback = entity.position().subtract(this.position()).normalize().scale(1.5);
            entity.setDeltaMovement(entity.getDeltaMovement().add(knockback.x, 0.4, knockback.z));
            entity.hurtMarked = true;
            this.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, this.getSoundVolume(), this.getVoicePitch());
            break;
        }
    }

    public Vec3 getThroatPos1(BddAbilityDragon entity) {
        return this.getMatrixPos(entity, this.headMatrix);
    }

    public Vec3 getThroatPos2(BddAbilityDragon entity) {
        if (!this.hasTwoHeads()) {
            return this.getThroatPos1(entity);
        }
        return this.getMatrixPos(entity, this.headMatrix2);
    }

    public Vec3 getTailPos(BddAbilityDragon entity) {
        return this.getMatrixPos(entity, this.tailMatrix);
    }

    public int getExplosionStrength() {
        return this.explosionStrength;
    }

    public void setExplosionStrength() {
        this.explosionStrength = 5;
    }

    public float getProjectileDamage(BddAbilityDragon dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        float f;
        int tier = projectile.getDamageTier();
        float baseDamage = 22.0f;
        if (tier == 1) {
            baseDamage = 20.0f;
        } else if (tier == 2) {
            baseDamage = 21.0f;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f = (float)Math.floor(livingEntity.getMaxHealth() * this.getDamageMultiplierForTier(tier));
        } else {
            f = 0.0f;
        }
        float additionalDamage = f;
        return baseDamage + additionalDamage;
    }

    private float getDamageMultiplierForTier(int tier) {
        return switch (tier) {
            case 1 -> 0.05f;
            case 2 -> 0.08f;
            case 3 -> 0.1f;
            case 4 -> 0.11f;
            default -> 0.0f;
        };
    }

    public int getPlayerBoltBlastPendingScale() {
        return this.playerBoltBlastPendingScale;
    }

    public void setPlayerBoltBlastPendingScale(int scale) {
        this.playerBoltBlastPendingScale = scale;
    }

    public void setPlayerBoltBlastPendingStopThreshold(int threshold) {
        this.playerBoltBlastPendingStopThreshold = threshold;
    }

    public int getMaxPlayerBoltBlast() {
        return 40;
    }

    public boolean tier1() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.2 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.5;
    }

    public boolean tier2() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.5 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.75;
    }

    public boolean tier3() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.75 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.92;
    }

    public boolean tier4() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.92;
    }
}

