/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.api.entity.core_classes.BddSaddleDragon;
import com.bdc.bdd.api.entity.util.DragonMoveControl;
import com.bdc.bdd.api.entity.util.DragonPathNavigation;
import com.bdc.bdd.util.BddUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class BddFlyingDragon
extends BddSaddleDragon {
    private static final int GLIDING_FLAG = 7;
    public static final float MIN_FLYING_SPEED = 0.02f;
    private static final int FLIGHT_ANIMATION_FLY_DURATION = BddUtil.secondsToTicks(5);
    private static final int TURN_FLY_DURATION = BddUtil.secondsToTicks(2);
    private static final float GLIDE_SPEED_BOOST_MULTIPLIER = 2.7f;
    private static final float PITCH_THRESHOLD = 10.0f;
    private static final float DIVE_SPEED_INCREMENT = 0.002f;
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HOVERING = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GOING_UP = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GOING_DOWN = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FLIGHT_ANIMATION_TIMER = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DIVE_TIMER = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FORCE_GLIDE = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TURN_ANIMATION_TIMER = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SPEEDING_UP = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SPEEDING_DOWN = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean nearGround;
    private final GroundPathNavigation groundNavigation;
    private final FlyingPathNavigation flyingNavigation;
    public float lastYaw;
    private float bodyPitch = 0.0f;

    public BddFlyingDragon(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new DragonMoveControl(this);
        this.flyingNavigation = new FlyingPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.flyingNavigation.setCanFloat(true);
        this.groundNavigation.setCanFloat(true);
        this.navigation = this.groundNavigation;
        this.lastYaw = this.getYRot();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        DragonPathNavigation dragonNavigation = new DragonPathNavigation((Mob)this, level);
        dragonNavigation.setCanFloat(true);
        return dragonNavigation;
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(HOVERING, (Object)false);
        builder.define(GOING_UP, (Object)false);
        builder.define(GOING_DOWN, (Object)false);
        builder.define(FLIGHT_ANIMATION_TIMER, (Object)0);
        builder.define(DIVE_TIMER, (Object)0);
        builder.define(FORCE_GLIDE, (Object)false);
        builder.define(TURN_ANIMATION_TIMER, (Object)0);
        builder.define(SPEEDING_UP, (Object)false);
        builder.define(SPEEDING_DOWN, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.isFlying());
        compound.putBoolean("Hovering", this.isHovering());
        compound.putBoolean("GoingUp", this.isGoingUp());
        compound.putBoolean("Diving", this.isDiving());
        compound.putInt("FlightAnimationTimer", this.getFlightAnimationTimer());
        compound.putInt("DiveTimer", this.getDiveTimer());
        compound.putBoolean("ForceGlide", this.isForceGlide());
        compound.putInt("TurnAnimationTimer", this.getTurnAnimationTimer());
        compound.putBoolean("SpeedUp", this.isSpeedingUp());
        compound.putBoolean("SpeedDown", this.isSpeedingDown());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlying(compound.getBoolean("Flying"));
        this.setHovering(compound.getBoolean("Hovering"));
        this.setGoingUp(compound.getBoolean("GoingUp"));
        this.setDiving(compound.getBoolean("Diving"));
        this.setFlightAnimationTimer(compound.getInt("FlightAnimationTimer"));
        this.setDiveTimer(compound.getInt("DiveTimer"));
        this.setForceGlide(compound.getBoolean("ForceGlide"));
        this.setTurnAnimationTimer(compound.getInt("TurnAnimationTimer"));
        this.setSpeedingUp(compound.getBoolean("SpeedUp"));
        this.setSpeedingDown(compound.getBoolean("SpeedDown"));
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
        this.setNoGravity(flying);
        if (flying) {
            if (!this.level.isClientSide()) {
                this.setNavigation(true);
            }
        } else if (!this.level.isClientSide()) {
            this.setNavigation(false);
        }
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        this.setFlying(true);
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.5, 0.0));
        System.out.println("Dragon jumpFromGround called: flying=true, velocity=" + String.valueOf(this.getDeltaMovement()));
    }

    public boolean isAbleToFly() {
        return this.canFly() && !this.isBaby() && (this.hasTailFin() || this.hasFakeTailFin());
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.entityData.get(HOVERING);
    }

    @Override
    public void setHovering(boolean hovering) {
        this.entityData.set(HOVERING, (Object)hovering);
        this.setNoGravity(hovering);
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.entityData.get(GOING_UP);
    }

    @Override
    public void setGoingUp(boolean goingUp) {
        this.entityData.set(GOING_UP, (Object)goingUp);
    }

    @Override
    public boolean isDiving() {
        return (Boolean)this.entityData.get(GOING_DOWN);
    }

    @Override
    public void setDiving(boolean diving) {
        this.entityData.set(GOING_DOWN, (Object)diving);
        if (!diving) {
            this.setDiveTimer(0);
        }
    }

    public float getBodyPitch() {
        return this.bodyPitch;
    }

    public void setBodyPitch(float pitch) {
        this.bodyPitch = pitch;
    }

    public boolean isSpeedingUp() {
        return (Boolean)this.entityData.get(SPEEDING_UP);
    }

    public void setSpeedingUp(boolean speedingUp) {
        this.entityData.set(SPEEDING_UP, (Object)speedingUp);
    }

    public boolean isSpeedingDown() {
        return (Boolean)this.entityData.get(SPEEDING_DOWN);
    }

    public void setSpeedingDown(boolean speedingDown) {
        this.entityData.set(SPEEDING_DOWN, (Object)speedingDown);
    }

    public int getFlightAnimationTimer() {
        return (Integer)this.entityData.get(FLIGHT_ANIMATION_TIMER);
    }

    public void setFlightAnimationTimer(int timer) {
        this.entityData.set(FLIGHT_ANIMATION_TIMER, (Object)timer);
    }

    public int getDiveTimer() {
        return (Integer)this.entityData.get(DIVE_TIMER);
    }

    public void setDiveTimer(int timer) {
        this.entityData.set(DIVE_TIMER, (Object)timer);
    }

    public boolean isForceGlide() {
        return (Boolean)this.entityData.get(FORCE_GLIDE);
    }

    public void setForceGlide(boolean forceGlide) {
        this.entityData.set(FORCE_GLIDE, (Object)forceGlide);
    }

    public int getTurnAnimationTimer() {
        return (Integer)this.entityData.get(TURN_ANIMATION_TIMER);
    }

    public void setTurnAnimationTimer(int timer) {
        this.entityData.set(TURN_ANIMATION_TIMER, (Object)timer);
    }

    protected float getJumpPower() {
        return super.getJumpPower() / 7.0f;
    }

    public boolean shouldFly() {
        return this.isFlying() ? !this.onGround() : this.isAbleToFly() && !this.isInWater();
    }

    public void setNavigation(boolean flying) {
        this.navigation = flying ? this.flyingNavigation : this.groundNavigation;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isHighEnough(5)) {
            if (this.isControlledByLocalInstance()) {
                this.setFlying(true);
                this.setNoGravity(true);
            } else if (this.isAbleToFly()) {
                this.setFlying(true);
                this.setNoGravity(true);
                if (!this.level.isClientSide()) {
                    this.setNavigation(true);
                }
            } else {
                this.setFlying(false);
                this.setNoGravity(false);
            }
        } else {
            this.setFlying(false);
            this.setNoGravity(false);
        }
        if (this.isDiving() && this.isFlying()) {
            this.setDiveTimer(this.getDiveTimer() + 1);
        }
    }

    public void travel(@NotNull Vec3 travelVector) {
        LivingEntity driver = this.getControllingPassenger();
        boolean isCurrentlyFlying = this.isFlying();
        Vec3 movement = driver != null ? this.handleRiddenMovement(driver, travelVector) : this.handleUnriddenMovement(travelVector);
        if (isCurrentlyFlying && this.isControlledByLocalInstance()) {
            this.handleFlightMovement(driver, movement);
            if (this.getDeltaMovement().y < 0.1 && !this.isGoingUp()) {
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.9f));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.calculateEntityAnimation(true);
        } else {
            this.handleGroundMovement(driver, movement);
            super.travel(movement);
        }
        this.adjustFlyingSpeed(driver);
    }

    private Vec3 handleRiddenMovement(LivingEntity driver, Vec3 travelVector) {
        double moveSideways = travelVector.x;
        double moveY = travelVector.y;
        double moveForward = Math.min(Math.abs(driver.zza) + Math.abs(driver.xxa), 1.0f);
        float yaw = driver.yHeadRot;
        if (moveForward > 0.0) {
            yaw += (float)Mth.atan2((double)driver.zza, (double)driver.xxa) * 57.295776f - 90.0f;
        }
        this.yHeadRot = yaw;
        this.setXRot(driver.getXRot() * 0.68f);
        this.setYRot(Mth.rotateIfNecessary((float)this.yHeadRot, (float)this.getYRot(), (float)4.0f));
        if (!this.isControlledByLocalInstance()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.calculateEntityAnimation(true);
            return Vec3.ZERO;
        }
        if (this.isFlying()) {
            if (moveForward > 0.0 && driver instanceof Player) {
                Player player = (Player)driver;
                float pitch = player.getXRot();
                this.setGoingUp(pitch < -10.0f);
                this.setDiving(pitch > 10.0f);
            } else {
                this.setGoingUp(false);
                this.setDiving(false);
            }
            moveForward = this.isHovering() ? 0.0 : 1.0;
            moveSideways = 0.0;
            moveY = 0.0;
        }
        this.handleRiddenStateTransitions(driver);
        return new Vec3(moveSideways, moveY, moveForward);
    }

    private void handleRiddenStateTransitions(LivingEntity driver) {
        if (this.onGround()) {
            if (this.isFlying()) {
                this.setFlying(false);
            }
            if (driver instanceof Player) {
                Player player = (Player)driver;
                if (player.jumping) {
                    this.jumpFromGround();
                    this.setFlying(true);
                    this.setNoGravity(true);
                }
            }
        }
    }

    private Vec3 handleUnriddenMovement(Vec3 travelVector) {
        if (this.isControlledByLocalInstance()) {
            if (this.onGround()) {
                if (this.isFlying()) {
                    this.setFlying(false);
                }
                if (travelVector.y > 0.0) {
                    this.jumpFromGround();
                }
            } else if (travelVector.z > 0.0 && this.isAbleToFly()) {
                this.setFlying(true);
            }
        }
        return travelVector;
    }

    private void handleFlightMovement(LivingEntity driver, Vec3 movement) {
        if (this.isHovering()) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        Vec3 forwardDirection = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot()).normalize();
        double flightSpeed = this.getFlyingSpeed();
        if (this.isForceGlide()) {
            flightSpeed *= (double)2.7f;
        }
        if (this.isDiving()) {
            flightSpeed += (double)((float)this.getDiveTimer() * 0.002f);
        }
        double verticalSpeed = this.getVerticalSpeed(driver, flightSpeed);
        Vec3 forwardMovement = forwardDirection.scale(flightSpeed);
        Vec3 totalMovement = new Vec3(forwardMovement.x, verticalSpeed, forwardMovement.z);
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.9f).add(totalMovement));
    }

    private double getVerticalSpeed(LivingEntity driver, double flightSpeed) {
        double verticalSpeed = 0.0;
        if (this.isGoingUp()) {
            verticalSpeed = flightSpeed * 0.4;
        } else if (this.isDiving()) {
            verticalSpeed = -flightSpeed * 0.6;
        }
        return verticalSpeed;
    }

    private void handleGroundMovement(LivingEntity driver, Vec3 travelVector) {
        Vec3 riddenInput = driver != null ? this.getRiddenInput((Player)driver, travelVector) : travelVector;
        Vec3 adjustedMovement = this.rotateMovementToEntity(riddenInput, this.getYRot());
        double baseSpeedMultiplier = this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 4.0;
        double sprintSpeedMultiplier = this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 5.0;
        double effectiveSpeedMultiplier = this.isSprinting() ? sprintSpeedMultiplier : baseSpeedMultiplier;
        double currentY = this.getDeltaMovement().y;
        Vec3 newMovement = new Vec3(adjustedMovement.x * effectiveSpeedMultiplier, currentY, adjustedMovement.z * effectiveSpeedMultiplier).scale(0.9);
        this.setDeltaMovement(newMovement);
    }

    public void adjustFlyingSpeed(LivingEntity driver) {
        block9: {
            block8: {
                if (!(driver instanceof Player)) break block8;
                Player player = (Player)driver;
                if (this.isFlying()) break block9;
            }
            return;
        }
        float currentFlyingSpeed = this.getFlyingSpeed();
        float speedIncrement = 0.001f;
        if (this.isSpeedingUp()) {
            if (currentFlyingSpeed < MAX_FLYING_SPEED) {
                this.setFlyingSpeed(currentFlyingSpeed + speedIncrement);
            }
        } else if (this.isSpeedingDown() && currentFlyingSpeed > 0.02f) {
            this.setFlyingSpeed(currentFlyingSpeed - speedIncrement);
        }
    }

    public double getAltitude(int limit) {
        BlockPos.MutableBlockPos pointer = this.blockPosition().mutable().move(0, -1, 0);
        int min = this.level.dimensionType().minY();
        int i = 0;
        while (i <= limit && pointer.getY() > min && !this.level.getBlockState((BlockPos)pointer).isSolid()) {
            pointer.setY(this.getBlockY() - ++i);
        }
        return i;
    }

    public double getAltitude() {
        return this.getAltitude(this.level.getMaxBuildHeight());
    }

    public boolean isHighEnough(int height) {
        return this.getAltitude(height) >= (double)height;
    }
}

