/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.inventory.DragonContainer;
import com.bdc.bdd.registry.ItemRegistry;
import io.netty.buffer.Unpooled;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BddSaddleDragon
extends BddAbilityDragon {
    public static final int SADDLE_SLOT = 0;
    public static final int ARMOR_SLOT = 1;
    public static final int CHEST_SLOT = 2;
    public static final int TAIL_SLOT = 3;
    public static final int ROPE_SLOT = 4;
    private static final int INVENTORY_SIZE = 16;
    private static final EntityDataAccessor<Boolean> SADDLE = SynchedEntityData.defineId(BddSaddleDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.defineId(BddSaddleDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public SimpleContainer dragonContainer;
    public boolean hasChestVarChanged = false;

    public BddSaddleDragon(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.initDragonInv();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SADDLE, (Object)false);
        builder.define(CHESTED, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Chested", this.isChested());
        compound.putBoolean("Saddled", this.isSaddled());
        if (this.isTame() && this.dragonContainer != null) {
            ListTag listTag = new ListTag();
            for (int i = 0; i < this.dragonContainer.getContainerSize(); ++i) {
                ItemStack itemStack = this.dragonContainer.getItem(i);
                if (itemStack.isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putByte("Slot", (byte)i);
                CompoundTag itemData = (CompoundTag)itemStack.save((HolderLookup.Provider)this.registryAccess());
                itemTag.merge(itemData);
                listTag.add((Object)itemTag);
                System.out.println("Saving Item Tag for Slot " + i + ": " + String.valueOf(itemTag));
            }
            compound.put("Items", (Tag)listTag);
        }
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setChested(compound.getBoolean("Chested"));
        this.setSaddled(compound.getBoolean("Saddled"));
        System.out.println("Loaded Saddled: " + this.isSaddled() + ", Chested: " + this.isChested());
        if (this.isTame() && this.dragonContainer != null) {
            ListTag listTag = compound.getList("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag itemTag = listTag.getCompound(i);
                int slot = itemTag.getByte("Slot") & 0xFF;
                if (slot >= this.dragonContainer.getContainerSize()) continue;
                this.dragonContainer.setItem(slot, ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)itemTag));
            }
            System.out.println("Loaded Inventory Slot 0 (Saddle): " + String.valueOf(this.dragonContainer.getItem(0)));
        }
        this.updateContainerEquipment();
    }

    @Override
    public boolean isSaddled() {
        return (Boolean)this.entityData.get(SADDLE);
    }

    public void setSaddled(boolean saddled) {
        this.entityData.set(SADDLE, (Object)saddled);
    }

    @Override
    public boolean isSaddleable() {
        return this.isAbleToBeRidden() && this.isTame();
    }

    @Override
    public boolean canBeRoped() {
        return this.isAbleToBeRidden() && this.isTame();
    }

    @Override
    public void equipSaddle(@NotNull ItemStack itemStack, @Nullable SoundSource soundSource) {
        ItemStack ropeItem;
        if (this.isRoped() && !(ropeItem = this.dragonContainer.removeItemNoUpdate(4)).isEmpty()) {
            this.spawnAtLocation(ropeItem);
            this.setRoped(false);
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, this.getSoundSource(), 1.0f, 1.0f);
        }
        this.dragonContainer.setItem(0, new ItemStack((ItemLike)Items.SADDLE));
        this.setSaddled(true);
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.HORSE_SADDLE, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    public void equipTail(@NotNull ItemStack itemStack, @Nullable SoundSource soundSource) {
        if (!this.isSaddled()) {
            return;
        }
        this.dragonContainer.setItem(3, new ItemStack((ItemLike)ItemRegistry.PROSTHETIC_TAILFIN.get()));
        this.setFakeTailFin(true);
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.HORSE_SADDLE, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    public void equipRope(@NotNull ItemStack itemStack, @Nullable SoundSource soundSource) {
        this.dragonContainer.setItem(4, new ItemStack((ItemLike)ItemRegistry.ROPE.get()));
        this.setRoped(true);
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.HORSE_SADDLE, this.getSoundSource(), 1.0f, 1.0f);
    }

    public boolean isChested() {
        return (Boolean)this.entityData.get(CHESTED);
    }

    public void setChested(boolean chested) {
        this.entityData.set(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    protected void initDragonInv() {
        SimpleContainer previousContainer = this.dragonContainer;
        this.dragonContainer = new SimpleContainer(this.getInventorySize());
        if (previousContainer != null) {
            int minSize = Math.min(previousContainer.getContainerSize(), this.dragonContainer.getContainerSize());
            for (int i = 0; i < minSize; ++i) {
                ItemStack itemStack = previousContainer.getItem(i);
                if (itemStack.isEmpty()) continue;
                this.dragonContainer.setItem(i, itemStack.copy());
            }
        }
        this.updateContainerEquipment();
    }

    public void updateContainerEquipment() {
        if (!this.level.isClientSide() && this.dragonContainer != null) {
            this.setSaddled(!this.dragonContainer.getItem(0).isEmpty() && this.dragonContainer.getItem(0).is(Items.SADDLE));
            this.setRoped(!this.dragonContainer.getItem(4).isEmpty() && this.dragonContainer.getItem(4).is(ItemRegistry.ROPE.get()));
            this.setChested(!this.dragonContainer.getItem(2).isEmpty() && (this.dragonContainer.getItem(2).is(Items.CHEST) || this.dragonContainer.getItem(2).is(Items.ENDER_CHEST)));
            System.out.println("Updated Saddled: " + this.isSaddled() + ", Saddle Slot Item: " + String.valueOf(this.dragonContainer.getItem(0)));
        }
    }

    @Override
    @NotNull
    public InteractionResult handleEmptyStack(Player player) {
        if (!player.isShiftKeyDown()) {
            if (this.isAbleToBeRidden() && this.getHunger() > 10) {
                if (this.isTame() && !this.isLocked()) {
                    this.doPlayerRide(player);
                    return InteractionResult.SUCCESS;
                }
                if (this.isTame() && this.isLocked()) {
                    if (this.isOwnedBy((LivingEntity)player) || this.isRoped()) {
                        this.doPlayerRide(player);
                        return InteractionResult.SUCCESS;
                    }
                    player.displayClientMessage((Component)Component.literal((String)"This dragon is locked by its owner."), true);
                    return InteractionResult.FAIL;
                }
                player.displayClientMessage((Component)Component.literal((String)"This dragon cannot be ridden at this moment."), true);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"This dragon cannot be ridden at this moment."), true);
            }
        } else {
            if (this.isOwnedBy((LivingEntity)player)) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.FAIL;
            }
            player.displayClientMessage((Component)Component.literal((String)"Only the owner can command this dragon."), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public InteractionResult handleSpecialInteractions(Player player, @NotNull InteractionHand hand, ItemStack stack) {
        if (!(this.isOwnedBy((LivingEntity)player) || stack.getItem() != Items.SADDLE && stack.getItem() != ItemRegistry.PROSTHETIC_TAILFIN.get())) {
            player.displayClientMessage((Component)Component.literal((String)"Only the owner can equip this."), true);
            return InteractionResult.FAIL;
        }
        if (stack.getItem() == ItemRegistry.ROPE.get() && !this.isRoped() && !this.isTame() && this.isTrusting()) {
            this.setRoped(true);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            player.displayClientMessage((Component)Component.literal((String)"Your Dragon is now roped"), false);
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() == Items.SADDLE && !this.isSaddled() && this.isTame()) {
            this.equipSaddle(stack, this.getSoundSource());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            player.displayClientMessage((Component)Component.literal((String)"Your Dragon is now saddled"), false);
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() == ItemRegistry.PROSTHETIC_TAILFIN.get() && !this.hasTailFin() && !this.hasFakeTailFin() && this.isTame()) {
            if (!this.isSaddled()) {
                player.displayClientMessage((Component)Component.literal((String)"You must equip a saddle first to attach a prosthetic tailfin."), true);
                return InteractionResult.FAIL;
            }
            this.equipTail(stack, this.getSoundSource());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            player.displayClientMessage((Component)Component.literal((String)"Prosthetic Tail Equipped"), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void handleRiding(Player player) {
        if (this.isTame() || this.isTrusting()) {
            this.doPlayerRide(player);
        } else if (this.getOwner() != null) {
            player.displayClientMessage((Component)Component.literal((String)("This dragon belongs to: " + this.getOwner().getName().getString())), true);
        }
    }

    protected void doPlayerRide(Player player) {
        if (!this.level.isClientSide()) {
            player.setYRot(this.getYRot());
            player.setXRot(this.getXRot());
            player.startRiding((Entity)this);
        }
        if (this.isDragonSitting()) {
            this.setIsDragonWandering(true);
        }
        if (this.isDragonSleeping()) {
            this.setIsDragonSleeping(false);
        }
        if (this.isEating()) {
            this.setIsDragonWandering(true);
        }
        if (this.getTarget() != null) {
            this.setTarget(null);
        }
    }

    public boolean isAbleToBeRidden() {
        return this.canBeRidden() && !this.isBaby() && !this.isJuvenile();
    }

    public abstract boolean canBeRidden();

    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.getPassengers()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            if (this.getTarget() == passenger) continue;
            if (this.isTame() && !this.isLocked()) {
                return player;
            }
            if (!this.isTame() || !this.isLocked() || !this.isOwnedBy((LivingEntity)player) && !this.isRoped()) continue;
            return player;
        }
        return null;
    }

    public void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (passenger instanceof Player) {
            this.getNavigation().stop();
        }
    }

    protected void tickRidden(@NotNull Player player, @NotNull Vec3 travelVector) {
        super.tickRidden(player, travelVector);
        float yaw = player.yHeadRot;
        if (travelVector.z > 0.0) {
            yaw += (float)Mth.atan2((double)player.zza, (double)player.xxa) * 57.295776f - 90.0f;
        }
        this.yHeadRot = yaw;
        this.setXRot(player.getXRot() * 0.68f);
        this.setYRot(Mth.rotateIfNecessary((float)yaw, (float)this.getYRot(), (float)8.0f));
        this.calculateEntityAnimation(true);
    }

    @NotNull
    protected Vec3 getRiddenInput(Player driver, Vec3 move) {
        double moveSideways = move.x;
        double moveY = 0.0;
        double moveForward = Math.min((double)(Math.abs(driver.zza) + Math.abs(driver.xxa)), 1.5);
        float f = this.isShiftKeyDown() ? 0.3f : 1.0f;
        return new Vec3(moveSideways * (double)f, moveY, moveForward * (double)f);
    }

    public void baseTick() {
        super.baseTick();
        if (this.isControlledByLocalInstance() && this.getControllingPassenger() != null) {
            this.setSprinting(this.getControllingPassenger().isSprinting());
        }
    }

    public Vec3 rotateMovementToEntity(Vec3 inputMovement, float yaw) {
        double radians = Math.toRadians(yaw);
        double x = inputMovement.x * Math.cos(radians) - inputMovement.z * Math.sin(radians);
        double z = inputMovement.x * Math.sin(radians) + inputMovement.z * Math.cos(radians);
        return new Vec3(x, inputMovement.y, z);
    }

    protected void positionRider(@NotNull Entity entity, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MoveFunction moveFunction) {
        if (this.hasPassenger(entity)) {
            Vec3 vec3 = this.getRiderOffset(entity, 1.0f);
            moveFunction.accept(entity, this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
        }
    }

    public Vec3 getRiderOffset(Entity entity, float partialTick) {
        float x = this.getPassengersRidingXOffset();
        float y = (float)((this.isRemoved() ? (double)0.01f : this.getPassengersRidingOffset()) + entity.getVehicleAttachmentPoint((Entity)entity).y);
        if (this.getPassengers().size() > 1) {
            int i = this.getPassengers().indexOf(entity);
            x = i == 0 ? 0.2f : -0.6f;
            if (entity instanceof Animal) {
                x += 0.2f;
            }
        }
        Vec3 vec3 = new Vec3((double)x, (double)y, 0.0);
        vec3 = vec3.yRot(-this.getViewYRot(partialTick) * ((float)Math.PI / 180) - 1.5707964f);
        return new Vec3(vec3.x, vec3.y, vec3.z);
    }

    public abstract float getPassengersRidingXOffset();

    public abstract float getYRideOffset();

    public abstract float getLayerYOffset();

    public double getPassengersRidingOffset() {
        return (double)this.dimensions.height() * (double)this.getYRideOffset();
    }

    public void openCustomInventoryScreen(@NotNull Player pPlayer) {
        BddConstants.PlatformHelper.MISC.openDragonContainerMenu(pPlayer, this);
    }

    public DragonContainer createMenu(int id, Inventory inventory, BddSaddleDragon dragon) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeInt(dragon.getId());
        return new DragonContainer(id, inventory, buffer);
    }

    public void containerChanged(@NotNull Container container) {
    }

    public boolean inventoryEmpty() {
        if (this.dragonContainer == null) {
            return true;
        }
        for (int i = 3; i < this.dragonContainer.getContainerSize(); ++i) {
            if (this.dragonContainer.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getInventorySize() {
        return 22;
    }

    public int getInventoryColumns() {
        return 4;
    }

    protected void dropEquipment() {
        ItemStack mainHandItem;
        if (this.dragonContainer != null) {
            for (int i = 0; i < this.dragonContainer.getContainerSize(); ++i) {
                ItemStack itemStack = this.dragonContainer.getItem(i);
                if (itemStack.isEmpty() || EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)DataComponents.ENCHANTMENTS)) continue;
                this.spawnAtLocation(itemStack);
            }
        }
        if (!(mainHandItem = this.getItemBySlot(EquipmentSlot.MAINHAND)).isEmpty()) {
            this.spawnAtLocation(mainHandItem);
        }
    }

    protected void customServerAiStep() {
        if (this.hasChestVarChanged && this.dragonContainer != null && !this.isChested()) {
            this.processChestItems();
            this.hasChestVarChanged = false;
        }
    }

    private void processChestItems() {
        for (int i = 5; i < 17; ++i) {
            ItemStack item = this.dragonContainer.getItem(i);
            if (item.isEmpty()) continue;
            if (!this.level.isClientSide()) {
                this.spawnAtLocation(item, 1.0f);
            }
            this.dragonContainer.removeItemNoUpdate(i);
        }
    }
}

