/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.util;

import com.bdc.bdd.api.entity.core_classes.BddFlyingDragon;
import com.bdc.bdd.api.entity.util.DragonNodeEvaluator;
import java.util.logging.Level;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class DragonPathNavigation
extends FlyingPathNavigation {
    public DragonNodeEvaluator dragonNodeEvaluator;

    public DragonPathNavigation(Mob pMob, net.minecraft.world.level.Level pLevel) {
        super(pMob, pLevel);
    }

    protected PathFinder createPathFinder(int pMaxVisitedNodes) {
        this.dragonNodeEvaluator = new DragonNodeEvaluator(this.mob);
        this.nodeEvaluator = this.dragonNodeEvaluator;
        return new PathFinder(this.nodeEvaluator, pMaxVisitedNodes);
    }

    public boolean canCutCorner(PathType pathType) {
        return super.canCutCorner(pathType) || pathType == PathType.WATER;
    }

    protected Vec3 getTempMobPos() {
        return this.mob.position().subtract(0.0, 0.0, 0.0);
    }

    protected double getGroundY(Vec3 p_217794_) {
        return this.dragonNodeEvaluator.allowSwimming ? p_217794_.y : super.getGroundY(p_217794_);
    }

    @Nullable
    public Path createPath(BlockPos pos, int accuracy) {
        Path path;
        BddFlyingDragon dragon;
        this.dragonNodeEvaluator.allowSwimming = false;
        Mob mob = this.mob;
        this.dragonNodeEvaluator.allowFlying = mob instanceof BddFlyingDragon && (dragon = (BddFlyingDragon)mob).isFlying();
        this.setMaxVisitedNodesMultiplier(5.0f);
        mob = this.mob;
        if (mob instanceof BddFlyingDragon) {
            dragon = (BddFlyingDragon)mob;
            this.dragonNodeEvaluator.allowSwimming = dragon.level.getFluidState(pos).is((Fluid)Fluids.WATER);
        }
        if ((path = super.createPath(pos, accuracy)) == null || !path.canReach() || path.getNodeCount() <= 1) {
            int dif = this.mob.blockPosition().getY() - pos.getY();
            double jumpHeight = Math.max(1.125, (double)this.mob.maxUpStep());
            if ((double)Mth.abs((int)dif) >= jumpHeight || !this.dragonNodeEvaluator.allowFlying) {
                this.dragonNodeEvaluator.allowFlying = true;
                path = super.createPath(pos, accuracy);
            }
        }
        this.resetMaxVisitedNodesMultiplier();
        if (path != null) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Created path to " + String.valueOf(pos) + ", node count: " + path.getNodeCount() + ", can reach: " + path.canReach()));
        } else {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Failed to create path to " + String.valueOf(pos)));
        }
        return path;
    }

    public Path createPath(Entity entity, int accuracy) {
        Path path;
        this.dragonNodeEvaluator.allowSwimming = false;
        this.dragonNodeEvaluator.allowFlying = false;
        this.setMaxVisitedNodesMultiplier(5.0f);
        Mob mob = this.mob;
        if (mob instanceof BddFlyingDragon) {
            BddFlyingDragon dragon = (BddFlyingDragon)mob;
            this.dragonNodeEvaluator.allowSwimming = dragon.isInWater();
        }
        if ((path = super.createPath(entity, accuracy)) == null || !path.canReach() || path.getNodeCount() <= 1) {
            int dif = this.mob.blockPosition().getY() - entity.blockPosition().getY();
            double jumpHeight = Math.max(1.125, (double)this.mob.maxUpStep());
            if ((double)Mth.abs((int)dif) >= jumpHeight) {
                this.dragonNodeEvaluator.allowFlying = true;
                path = super.createPath(entity, accuracy);
            }
        }
        this.resetMaxVisitedNodesMultiplier();
        return path;
    }

    protected boolean canUpdatePath() {
        return true;
    }

    protected boolean canMoveDirectly(Vec3 p_217796_, Vec3 p_217797_) {
        return this.dragonNodeEvaluator.allowSwimming && this.mob.isInLiquid() && DragonPathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)p_217796_, (Vec3)p_217797_, (boolean)true);
    }

    public boolean isStableDestination(BlockPos pPos) {
        if (this.dragonNodeEvaluator.allowFlying) {
            return this.level.getBlockState(pPos).entityCanStandOn((BlockGetter)this.level, pPos, (Entity)this.mob) || this.level.getBlockState(pPos).isAir();
        }
        if (this.dragonNodeEvaluator.allowSwimming) {
            return !this.level.getBlockState(pPos.below()).isAir();
        }
        BlockPos blockpos = pPos.below();
        return this.level.getBlockState(blockpos).isSolidRender((BlockGetter)this.level, blockpos) || this.level.getBlockState(pPos).isAir();
    }

    public void tick() {
        double dz;
        if (this.path == null || this.path.isDone()) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"Path is null or done");
            super.tick();
            return;
        }
        Node currentNode = this.path.getNextNode();
        if (currentNode == null) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"No current path node");
            super.tick();
            return;
        }
        double dx = this.mob.getX() - (double)currentNode.x;
        double distanceSquared = dx * dx + (dz = this.mob.getZ() - (double)currentNode.z) * dz;
        boolean reached = distanceSquared < 0.5;
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Checking path node at " + String.valueOf(new BlockPos(currentNode.x, currentNode.y, currentNode.z)) + ", XZ distance: " + Math.sqrt(distanceSquared) + ", reached: " + reached));
        if (reached) {
            this.path.advance();
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"Advancing to next path node");
        }
        super.tick();
    }
}

