/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.render;

import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.api.model.BddDragonModel;
import com.bdc.bdd.api.render.layer.DragonGlowLayer;
import com.bdc.bdd.api.render.layer.DragonSaddleLayer;
import com.bdc.bdd.api.render.layer.DragonTailLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;
import software.bluelib.loader.renderer.entity.BlueEntityRenderer;

public class BddDragonRender<T extends BddDragon>
extends BlueEntityRenderer<T> {
    public float adultSize;
    public float babySize;

    public BddDragonRender(EntityRendererProvider.Context renderManager, float adultScale, float babyScale) {
        super(renderManager, new BddDragonModel(adultScale, babyScale));
        this.addRenderLayer(new DragonSaddleLayer(this));
        this.addRenderLayer(new DragonTailLayer(this));
        this.addRenderLayer(new DragonGlowLayer(this));
        this.adultSize = adultScale;
        this.babySize = babyScale;
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        BoneCache head = this.getBlueModel().getAnimationProcessor().getBone("head");
        BoneCache head2 = this.getBlueModel().getAnimationProcessor().getBone("head2");
        if (((BddBaseDragon)animatable).isBaby()) {
            poseStack.scale(this.adultSize / 3.5f, this.adultSize / 3.5f, this.adultSize / 3.5f);
        } else if (((BddBaseDragon)animatable).isJuvenile()) {
            poseStack.scale(this.adultSize / 2.5f, this.adultSize / 2.5f, this.adultSize / 2.5f);
        } else if (((BddBaseDragon)animatable).isTeen()) {
            poseStack.scale(this.adultSize / 1.5f, this.adultSize / 1.5f, this.adultSize / 1.5f);
        } else {
            poseStack.scale(this.adultSize, this.adultSize, this.adultSize);
        }
        if (((BddBaseDragon)animatable).isBaby()) {
            head.updateScale(this.adultSize * 1.3f, this.adultSize * 1.3f, this.adultSize * 1.3f);
            if (((BddAbilityDragon)animatable).hasTwoHeads()) {
                head2.updateScale(this.adultSize * 1.3f, this.adultSize * 1.3f, this.adultSize * 1.3f);
            }
        } else if (((BddBaseDragon)animatable).isJuvenile()) {
            head.updateScale(this.adultSize * 1.1f, this.adultSize * 1.1f, this.adultSize * 1.1f);
            if (((BddAbilityDragon)animatable).hasTwoHeads()) {
                head2.updateScale(this.adultSize * 1.1f, this.adultSize * 1.1f, this.adultSize * 1.1f);
            }
        } else if (((BddBaseDragon)animatable).isTeen()) {
            head.resetStateChanges();
        } else {
            head.resetStateChanges();
        }
        super.applyRotations(animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
    }

    public void renderRecursively(BoneCache bone, FullRenderContext<T> pContext) {
        BddDragon dragon;
        BddDragon animatable = (BddDragon)pContext.animatable();
        pContext.poseStack().pushPose();
        RenderUtils.translateMatrixToBone((PoseStack)pContext.poseStack(), (BoneCache)bone);
        RenderUtils.translateToPivotPoint((PoseStack)pContext.poseStack(), (BoneCache)bone);
        BddDragonRender.rotateMatrixAroundDragonBoneOrHead(pContext.poseStack(), bone, animatable, pContext.partialTick());
        RenderUtils.scaleMatrixForBone((PoseStack)pContext.poseStack(), (BoneCache)bone);
        if (bone.getName().equals("rider")) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            animatable.riderMatrix = new Matrix4f((Matrix4fc)localMatrix);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            localMatrix.translate((Vector3fc)new Vector3f((Vector3fc)this.getRenderOffset((Entity)animatable, 1.0f).toVector3f()));
            bone.setLocalSpaceMatrix(localMatrix);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            worldState.translate((Vector3fc)new Vector3f((Vector3fc)animatable.position().toVector3f()));
            bone.setWorldSpaceMatrix(worldState);
        } else if (bone.getName().equals("mouth")) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            animatable.headMatrix = new Matrix4f((Matrix4fc)localMatrix);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            localMatrix.translate((Vector3fc)new Vector3f((Vector3fc)this.getRenderOffset((Entity)animatable, 1.0f).toVector3f()));
            bone.setLocalSpaceMatrix(localMatrix);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            worldState.translate((Vector3fc)new Vector3f((Vector3fc)animatable.position().toVector3f()));
            bone.setWorldSpaceMatrix(worldState);
        } else if (bone.getName().equals("mouth2") && animatable instanceof BddAbilityDragon && (dragon = animatable).hasTwoHeads()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            dragon.headMatrix2 = new Matrix4f((Matrix4fc)localMatrix);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            localMatrix.translate((Vector3fc)new Vector3f((Vector3fc)this.getRenderOffset((Entity)animatable, 1.0f).toVector3f()));
            bone.setLocalSpaceMatrix(localMatrix);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            worldState.translate((Vector3fc)new Vector3f((Vector3fc)animatable.position().toVector3f()));
            bone.setWorldSpaceMatrix(worldState);
        } else if (bone.getName().equals("tail1")) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            animatable.tailMatrix = new Matrix4f((Matrix4fc)localMatrix);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            localMatrix.translate((Vector3fc)new Vector3f((Vector3fc)this.getRenderOffset((Entity)animatable, 1.0f).toVector3f()));
            bone.setLocalSpaceMatrix(localMatrix);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            worldState.translate((Vector3fc)new Vector3f((Vector3fc)animatable.position().toVector3f()));
            bone.setWorldSpaceMatrix(worldState);
        } else if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)localMatrix, (Vector3f)this.getRenderOffset((Entity)animatable, 1.0f).toVector3f()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)new Matrix4f((Matrix4fc)localMatrix), (Vector3f)animatable.position().toVector3f()));
        }
        RenderUtils.translateAwayFromPivotPoint((PoseStack)pContext.poseStack(), (BoneCache)bone);
        this.renderCubesOfBone(bone, pContext);
        if (!pContext.isReRender()) {
            this.applyRenderLayersForBone(bone, (IRenderContext)pContext);
        }
        this.renderChildBones(bone, pContext);
        pContext.poseStack().popPose();
    }

    public RenderType getRenderType(ResourceLocation pTexture, IRenderContext<T> pContext) {
        return RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation((Entity)((BddDragon)pContext.animatable())));
    }

    public static void rotateMatrixAroundDragonBoneOrHead(PoseStack poseStack, BoneCache bone, BddDragon dragon, float partialTick) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.mulPose(Axis.ZP.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.mulPose(Axis.YP.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.mulPose(Axis.XP.rotation(bone.getRotX()));
        }
        if (bone.getName().equals("head") || bone.getName().equals("head2")) {
            float diff = Mth.degreesDifference((float)Mth.lerp((float)partialTick, (float)dragon.yHeadRotO, (float)dragon.yHeadRot), (float)Mth.lerp((float)partialTick, (float)dragon.yBodyRotO, (float)dragon.yBodyRot));
            poseStack.mulPose(Axis.YP.rotationDegrees(diff));
        }
    }
}

