/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.render.layer;

import com.bdc.bdd.BddCommon;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.dragons.Nightfury;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class DragonSaddleLayer<T extends BddDragon>
extends BlueRenderLayer<T> {
    public DragonSaddleLayer(BlueRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(IRenderContext<T> pContext) {
        BddDragon animatable = (BddDragon)pContext.animatable();
        if (!animatable.isSaddled()) {
            return;
        }
        String dragonTypePath = animatable.returnDragonType().getPath();
        RenderType saddle = RenderType.entityCutout((ResourceLocation)BddCommon.Resource.resource("textures/saddle/" + dragonTypePath + "_saddle.png"));
        if (animatable instanceof Nightfury) {
            if (pContext instanceof FullRenderContext) {
                FullRenderContext full = (FullRenderContext)pContext;
                full.setPackedOverlay(OverlayTexture.NO_OVERLAY);
                full.setRenderType(saddle);
                full.setColor(0xFFFFFF);
                full.setBuffer(full.bufferSource().getBuffer(saddle));
                this.getRenderer().reRender((IRenderContext)full);
            } else if (pContext instanceof BaseRenderContext) {
                BaseRenderContext base = (BaseRenderContext)pContext;
                base.setPackedOverlay(OverlayTexture.NO_OVERLAY);
                base.setColor(0xFFFFFF);
                this.getRenderer().reRender((IRenderContext)base);
            }
        }
    }
}

