/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.inventory;

import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.util.BddGuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.text.WordUtils;

public class BddGuiOverlays {
    private static final Vec2 BOX_DIMENSIONS = new Vec2(100.0f, 115.0f);
    private static final int BOX_MARGIN = 20;
    private static final int BOX_COLOR = -1877329276;
    private static final int WHITE_TEXT = 14343394;
    private static final int GREEN_TEXT = 65280;
    private static final int RED_TEXT = 0xFF0000;
    private static final int YELLOW_TEXT = 16769792;
    private static final int POWER_BAR_BG = -13026978;
    private static final int POWER_BAR_FG = -16711936;
    private static final int STAMINA_BAR_BG = -13026978;
    private static final int STAMINA_BAR_FG = -16711936;

    public static void renderStatBox(GuiGraphics guiGraphics, Minecraft mc, BddBaseDragon dragon) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int imageWidth = (int)BddGuiOverlays.BOX_DIMENSIONS.x;
        int imageHeight = (int)BddGuiOverlays.BOX_DIMENSIONS.y;
        int guiScale = (Integer)mc.options.guiScale().get();
        int[] offsets = BddGuiOverlays.getGuiScaleOffsets(guiScale);
        int boxX = screenWidth - imageWidth - 20 + offsets[0];
        int boxY = screenHeight - imageHeight - 20 - offsets[1];
        BddGuiUtils.renderTranslucentBox(guiGraphics, boxX, boxY, imageWidth, imageHeight, -1877329276);
        String dragonType = WordUtils.capitalizeFully((String)dragon.returnDragonType().getPath().replace('_', ' '));
        guiGraphics.drawString(mc.font, dragonType, boxX + 5, boxY + 10, 14343394);
        String growth = BddGuiOverlays.getGrowthStage(dragon);
        guiGraphics.drawString(mc.font, "Growth: " + growth, boxX + 5, boxY + 26, 14343394);
        String tamedStatus = BddGuiOverlays.getTamedStatus(dragon);
        guiGraphics.drawString(mc.font, tamedStatus, boxX + 5, boxY + 37, 65280);
        String hungerStatus = BddGuiOverlays.getHungerStatus(dragon.getHunger());
        int hungerColor = BddGuiOverlays.getHungerColor(hungerStatus);
        guiGraphics.drawString(mc.font, "Hunger: ", boxX + 5, boxY + 48, 14343394);
        guiGraphics.drawString(mc.font, hungerStatus, boxX + 5 + mc.font.width("Hunger: "), boxY + 48, hungerColor);
        float power = dragon.getPower() / 10.0f;
        BddGuiUtils.renderProgressBar(guiGraphics, boxX + 40, boxY + 59, 50, 8, power, -13026978, -16711936);
        guiGraphics.drawString(mc.font, "Power: ", boxX + 5, boxY + 59, 14343394);
        float stamina = (float)dragon.getDragonStamina() / 100.0f;
        BddGuiUtils.renderProgressBar(guiGraphics, boxX + 45, boxY + 70, 50, 8, stamina, -13026978, -16711936);
        guiGraphics.drawString(mc.font, "Stamina: ", boxX + 5, boxY + 70, 14343394);
        guiGraphics.drawString(mc.font, "Preferred Food:", boxX + 5, boxY + 81, 14343394);
        int offsetX = 10;
        for (Item favoriteFood : dragon.getFavoriteFoods()) {
            BddGuiUtils.renderItemIcon(guiGraphics, boxX + offsetX, boxY + 89, favoriteFood);
            offsetX += 16;
        }
    }

    private static int[] getGuiScaleOffsets(int guiScale) {
        int[] nArray;
        switch (guiScale) {
            case 1: {
                int[] nArray2 = new int[2];
                nArray2[0] = 10;
                nArray = nArray2;
                nArray2[1] = 400;
                break;
            }
            case 2: {
                int[] nArray3 = new int[2];
                nArray3[0] = 15;
                nArray = nArray3;
                nArray3[1] = 190;
                break;
            }
            case 3: {
                int[] nArray4 = new int[2];
                nArray4[0] = 20;
                nArray = nArray4;
                nArray4[1] = 120;
                break;
            }
            case 0: 
            case 4: {
                int[] nArray5 = new int[2];
                nArray5[0] = 15;
                nArray = nArray5;
                nArray5[1] = 80;
                break;
            }
            default: {
                int[] nArray6 = new int[2];
                nArray6[0] = 0;
                nArray = nArray6;
                nArray6[1] = 0;
            }
        }
        return nArray;
    }

    private static String getGrowthStage(BddBaseDragon dragon) {
        if (dragon.isBaby()) {
            return "Baby";
        }
        if (dragon.isJuvenile()) {
            return "Juvenile";
        }
        if (dragon.isTeen()) {
            return "Teen";
        }
        return "Adult";
    }

    private static String getTamedStatus(BddBaseDragon dragon) {
        if (dragon.isTame() && dragon.getOwner() != null) {
            return "Owner: " + dragon.getOwner().getName().getString();
        }
        return dragon.getTrustState().getSerializedName();
    }

    private static String getHungerStatus(float hungerValue) {
        if (hungerValue >= (float)BddBaseDragon.MAX_HUNGER) {
            return "Full";
        }
        if (hungerValue >= (float)(BddBaseDragon.MAX_HUNGER - 20)) {
            return "Well Fed";
        }
        if (hungerValue >= (float)BddBaseDragon.MAX_HUNGER / 2.0f) {
            return "Peckish";
        }
        if (hungerValue >= (float)BddBaseDragon.MAX_HUNGER / 3.0f) {
            return "Hungry";
        }
        return "Starving";
    }

    private static int getHungerColor(String hungerStatus) {
        return switch (hungerStatus) {
            case "Starving" -> 0xFF0000;
            case "Peckish", "Hungry" -> 16769792;
            default -> 65280;
        };
    }
}

