/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.inventory;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.inventory.slots.DragonInventorySlot;
import com.bdc.bdd.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class DragonContainer
extends AbstractContainerMenu {
    private final List<DragonInventorySlot> inventorySlots = new ArrayList<DragonInventorySlot>();
    public BddDragon dragon;
    public Container dragonContainer;

    public DragonContainer(int iD, Inventory playerInv, FriendlyByteBuf data) {
        super(BddConstants.PlatformHelper.MISC.getDragonContainerType(), iD);
        int si;
        this.dragonContainer = this.dragon.dragonContainer;
        this.dragonContainer.startOpen(playerInv.player);
        this.addSlot(new Slot(this.dragonContainer, 0, -29, 9){

            public boolean mayPlace(@NotNull ItemStack stack) {
                if (stack.getItem() == Items.SADDLE && !this.hasItem() && DragonContainer.this.dragon.isTame()) {
                    return DragonContainer.this.dragon instanceof BddDragon;
                }
                return false;
            }

            public void setChanged() {
                if (DragonContainer.this.dragon != null) {
                    DragonContainer.this.dragon.updateContainerEquipment();
                }
            }

            public boolean isActive() {
                return DragonContainer.this.dragon.isTame();
            }
        });
        this.addSlot(new Slot(this.dragonContainer, 4, -29, 9){

            public boolean mayPlace(@NotNull ItemStack stack) {
                if (stack.getItem() == ItemRegistry.ROPE.get() && !this.hasItem() && DragonContainer.this.dragon.isTrusting() && !DragonContainer.this.dragon.isTame()) {
                    return DragonContainer.this.dragon instanceof BddDragon;
                }
                return false;
            }

            public void setChanged() {
                if (DragonContainer.this.dragon != null) {
                    DragonContainer.this.dragon.updateContainerEquipment();
                }
            }

            public boolean isActive() {
                return DragonContainer.this.dragon.isTrusting() && !DragonContainer.this.dragon.isTame();
            }
        });
        this.addSlot(new Slot(this.dragonContainer, 2, -29, 31){

            public boolean mayPickup(@NotNull Player pPlayer) {
                return DragonContainer.this.dragon.inventoryEmpty() || DragonContainer.this.dragon.dragonContainer.getItem(2).is(Items.ENDER_CHEST) && DragonContainer.this.dragon.isTame();
            }

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return itemStack.is(Items.CHEST) || itemStack.is(Items.ENDER_CHEST) && DragonContainer.this.dragon.isTame();
            }

            public void set(@NotNull ItemStack pStack) {
                super.set(pStack);
                DragonContainer.this.dragon.updateContainerEquipment();
                for (DragonInventorySlot slot : DragonContainer.this.inventorySlots) {
                    slot.setChestTypeChanged(DragonContainer.this.dragon.dragonContainer.getItem(2).is(Items.ENDER_CHEST));
                }
            }

            public int getMaxStackSize() {
                return 1;
            }

            public boolean isActive() {
                return DragonContainer.this.dragon.isTame();
            }
        });
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < this.dragon.getInventoryColumns(); ++x) {
                this.addSlot(new Slot(this.dragonContainer, 5 + x + y * this.dragon.getInventoryColumns(), 136 + x * 18, 93 + y * 18){

                    public boolean isActive() {
                        return DragonContainer.this.dragon.isChested();
                    }

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        return this.isActive();
                    }
                });
            }
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)playerInv, sj + (si + 1) * 9, -28 + sj * 18, 99 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)playerInv, si, -28 + si * 18, 157));
        }
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return this.dragonContainer.stillValid(playerIn) && this.dragon.isAlive() && this.dragon.distanceTo((Entity)playerIn) < 8.0f;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.dragonContainer.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.dragonContainer.getContainerSize(), this.slots.size(), true) : (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem() ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (this.getSlot(2).mayPlace(itemstack1) && !this.getSlot(2).hasItem() ? !this.moveItemStackTo(itemstack1, 2, 3, false) : (this.getSlot(3).mayPlace(itemstack1) && !this.getSlot(3).hasItem() ? !this.moveItemStackTo(itemstack1, 3, 4, false) : (this.getSlot(0).mayPlace(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : this.dragonContainer.getContainerSize() <= 4 || !this.moveItemStackTo(itemstack1, 4, this.dragonContainer.getContainerSize(), false)))))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        this.dragonContainer.stopOpen(playerIn);
    }
}

